/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.opencontrol.control;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.opencontrol.PdsOpenControlContext;
import kd.scm.pds.common.opencontrol.PdsOpenControlUtils;
import kd.scm.pds.common.opencontrol.control.IPdsOpenControlValidator;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsSupDecryptTaskValidator
implements IPdsOpenControlValidator {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsOpenControlContext context) {
        this.decryptTaskValidate(context);
    }

    protected void decryptTaskValidate(PdsOpenControlContext context) {
        QFilter baseFilter = PdsOpenControlUtils.getBaseFilter(context, context.getOpenTypeSchemeObj().getBoolean("isencryptbypkg"));
        DynamicObjectCollection allRows = QueryServiceHelper.query((String)"pds_supencryptdetail", (String)"id,isdecrypt", (QFilter[])baseFilter.toArray());
        if (allRows.size() == 0) {
            return;
        }
        List finishRows = allRows.stream().filter(e -> e.getBoolean("isdecrypt")).collect(Collectors.toList());
        String passType = PdsCommonUtils.object2String(context.getOpenTypeSchemeObj().get("supdecryptpass"), "2");
        StringBuilder message = PdsOpenControlUtils.verifyFinishNum(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5df2\u89e3\u5bc6", (String)"PdsSupDecryptTaskValidator_0", (String)"scm-pds-common", (Object[])new Object[0]), passType, finishRows.size(), allRows.size());
        if (message.length() > 0) {
            context.setSucced(false);
            context.setMessage(message);
        }
    }
}

