/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.opencontrol.create;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scm.pds.common.opencontrol.PdsOpenControlContext;
import kd.scm.pds.common.opencontrol.PdsOpenControlUtils;
import kd.scm.pds.common.opencontrol.create.IPdsControlDetailCreater;
import kd.scm.pds.common.util.MultiBasedataUtils;

public class PdsBidOpenDetailCreater
implements IPdsControlDetailCreater {
    private static final long serialVersionUID = 1L;

    @Override
    public void createDetail(PdsOpenControlContext context, String openType, DynamicObject schemeObj, List<DynamicObject> objList) {
        if (schemeObj.getInt("opennum") == 0) {
            return;
        }
        Set<Long> roleSet = MultiBasedataUtils.getBasedataIdSet(schemeObj, "openrole");
        if (null == roleSet || roleSet.size() == 0) {
            return;
        }
        boolean isEncryptByPkg = schemeObj.getBoolean("isopenbypkg");
        for (Map.Entry<Long, List<DynamicObject>> entry : context.getBizRoleMap().entrySet()) {
            if (!roleSet.contains(entry.getKey())) continue;
            HashSet<Long> bidderSet = new HashSet<Long>(entry.getValue().size());
            for (DynamicObject mytaskObj : entry.getValue()) {
                long bidderId;
                if (!PdsOpenControlUtils.isBidTypeMatch(context, mytaskObj, openType) || !bidderSet.add(bidderId = mytaskObj.getLong("bidder.id"))) continue;
                if (isEncryptByPkg && "2".equals(context.getManageType())) {
                    if (context.isOpenBySupplier()) {
                        context.getPackageSet().forEach(packageId -> context.getSupplierMap().keySet().forEach(supplierId -> PdsOpenControlUtils.createBidOpenDetail(context, packageId, supplierId, bidderId, openType, objList)));
                        continue;
                    }
                    context.getPackageSet().forEach(packageId -> PdsOpenControlUtils.createBidOpenDetail(context, packageId, 0L, bidderId, openType, objList));
                    continue;
                }
                if (context.isOpenBySupplier()) {
                    context.getSupplierMap().keySet().forEach(supplierId -> PdsOpenControlUtils.createBidOpenDetail(context, 0L, supplierId, bidderId, openType, objList));
                    continue;
                }
                PdsOpenControlUtils.createBidOpenDetail(context, 0L, 0L, bidderId, openType, objList);
            }
        }
    }
}

