/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.opencontrol.create;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pds.common.opencontrol.PdsOpenControlContext;
import kd.scm.pds.common.opencontrol.create.IPdsControlDetailCreater;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsEncryptSendMessage
implements IPdsControlDetailCreater {
    private static final long serialVersionUID = 1L;

    @Override
    public void createDetail(PdsOpenControlContext context, String openType, DynamicObject schemeObj, List<DynamicObject> objList) {
    }

    @Override
    public void sendMessage(PdsOpenControlContext context) {
        this.sendEncryptMessage(context.getProjectId(), "pds_bidopendetail");
        this.sendEncryptMessage(context.getProjectId(), "pds_encryptdetail");
        this.sendEncryptMessage(context.getProjectId(), "pds_supencryptdetail");
    }

    private void sendEncryptMessage(long projectId, String entityName) {
        QFilter qFilter = new QFilter("project", "=", (Object)projectId);
        qFilter.and("issend", "=", (Object)false);
        DynamicObject[] cols = BusinessDataServiceHelper.load((String)entityName, (String)"id,issend,senddate,bidder,supplier", (QFilter[])qFilter.toArray());
        DynamicObject[] distinctCols = Objects.equals(entityName, "pds_bidopendetail") || Objects.equals(entityName, "pds_encryptdetail") ? (DynamicObject[])Arrays.stream(cols).filter(PdsCommonUtils.distinctByKey(col -> col.getLong("bidder.id"))).toArray(DynamicObject[]::new) : (DynamicObject[])Arrays.stream(cols).filter(PdsCommonUtils.distinctByKey(col -> col.getLong("supplier.id"))).toArray(DynamicObject[]::new);
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        option.setVariableValue("ishasright", String.valueOf(true));
        OperationResult result = OperationServiceHelper.executeOperate((String)"sendmsg", (String)entityName, (DynamicObject[])distinctCols, (OperateOption)option);
        if (!result.isSuccess()) {
            return;
        }
        for (DynamicObject col2 : cols) {
            col2.set("issend", (Object)true);
            col2.set("senddate", (Object)TimeServiceHelper.now());
        }
        SaveServiceHelper.save((DynamicObject[])cols);
    }
}

