/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.opencontrol.create;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scm.pds.common.opencontrol.PdsOpenControlContext;
import kd.scm.pds.common.opencontrol.PdsOpenControlUtils;
import kd.scm.pds.common.opencontrol.create.IPdsControlDetailCreater;

public class PdsSupEncryptDetailCreater
implements IPdsControlDetailCreater {
    private static final long serialVersionUID = 1L;

    @Override
    public void createDetail(PdsOpenControlContext context, String openType, DynamicObject schemeObj, List<DynamicObject> objList) {
        if (schemeObj.getInt("supencryptnum") == 0) {
            return;
        }
        boolean isEncryptByPkg = schemeObj.getBoolean("isencryptbypkg");
        boolean isSupAutoEncrypt = schemeObj.getBoolean("issupautoencrypt");
        for (Map.Entry<Long, List<DynamicObject>> entry : context.getSupplierMap().entrySet()) {
            Set supPackageSet = entry.getValue().stream().map(e -> e.getLong("package.id")).collect(Collectors.toSet());
            DynamicObjectCollection supplierusers = new DynamicObjectCollection();
            for (DynamicObject supplierObj : entry.getValue()) {
                supplierusers.addAll((Collection)supplierObj.getDynamicObjectCollection("supplieruser"));
            }
            long bidderId = 0L;
            context.setSupplierusers(supplierusers);
            if (isEncryptByPkg && "2".equals(context.getManageType())) {
                context.getPackageSet().forEach(packageId -> {
                    if (supPackageSet.contains(packageId)) {
                        PdsOpenControlUtils.createSupEncryptDetail(context, packageId, (Long)entry.getKey(), bidderId, openType, objList, isSupAutoEncrypt);
                    }
                });
                continue;
            }
            PdsOpenControlUtils.createSupEncryptDetail(context, 0L, entry.getKey(), bidderId, openType, objList, isSupAutoEncrypt);
        }
    }
}

