/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.opencontrol.handle;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.scm.pds.common.mytask.SrcMyTaskContext;
import kd.scm.pds.common.opencontrol.PdsOpenControlFacade;
import kd.scm.pds.common.opencontrol.PdsOpenControlUtils;
import kd.scm.pds.common.opencontrol.handle.PdsBidOpenButtonHandler;
import kd.scm.pds.common.opencontrol.process.PdsTerminateProcess;
import kd.scm.pds.common.opencontrol.verify.PdsBidopenVerify;
import kd.scm.pds.common.opencontrol.verify.PdsTerminateVerify;
import kd.scm.pds.common.util.ListSelectUtils;
import kd.scm.pds.common.util.OpenFormUtils;

public class PdsBidOpenTaskHandler
extends AbstractListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        String opKey = ((AbstractOperate)evt.getSource()).getOperateKey();
        if (opKey.equals("refresh") || opKey.equals("close")) {
            return;
        }
        evt.setCancel(true);
        Set<Long> selectIds = ListSelectUtils.getListSelectPrimaryKeys(this.getView());
        SrcMyTaskContext context = new SrcMyTaskContext();
        context.setCurrView(this.getView());
        context.setSelectIds(selectIds);
        switch (opKey) {
            case "bidopen": {
                this.bidopenVerify(context);
                break;
            }
            case "terminate": {
                this.terminateVerify(context);
                break;
            }
        }
    }

    public void packageData(PackageDataEvent e) {
        if (e.getSource() instanceof ListOperationColumnDesc && "taskhandleop".equals(((ListOperationColumnDesc)e.getSource()).getKey())) {
            Set<String> todoTaskSet = PdsOpenControlFacade.getTodoTaskSet(e.getRowData(), PdsBidOpenButtonHandler.class.getSimpleName());
            List operationColItems = (List)e.getFormatValue();
            for (OperationColItem operationColItem : operationColItems) {
                if (null != todoTaskSet && todoTaskSet.contains(operationColItem.getOperationKey())) {
                    operationColItem.setVisible(true);
                    continue;
                }
                operationColItem.setVisible(false);
            }
        }
        super.packageData(e);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String key;
        super.closedCallBack(evt);
        switch (key = evt.getActionId()) {
            case "bidopen": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    protected void bidopenVerify(SrcMyTaskContext context) {
        PdsOpenControlFacade.taskVerify(context, PdsBidopenVerify.class.getSimpleName());
        if (context.isVerifyOk()) {
            OpenFormUtils.openDynamicPage(this.getView(), "pds_bidopentool", ShowType.Modal, PdsOpenControlUtils.getHandleInfoMap(context), new CloseCallBack((IFormPlugin)this, "bidopen"));
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f00\u6807\u6821\u9a8c", (String)"PdsBidOpenTaskHandler_0", (String)"scm-pds-common", (Object[])new Object[0]), context.getVerifyMessage(), MessageTypes.Default);
        }
    }

    protected void terminateVerify(SrcMyTaskContext context) {
        PdsOpenControlFacade.taskVerify(context, PdsTerminateVerify.class.getSimpleName());
        if (context.isVerifyOk()) {
            this.getPageCache().put("terminate", SerializationUtils.toJsonString(context.getHandleIds()));
            this.getView().showConfirm(context.getVerifyMessage(), MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener("terminate"));
        } else {
            this.getPageCache().put("terminate", null);
            this.getView().showMessage(ResManager.loadKDString((String)"\u4efb\u52a1\u7ec8\u6b62\u6821\u9a8c", (String)"PdsBidOpenTaskHandler_1", (String)"scm-pds-common", (Object[])new Object[0]), context.getVerifyMessage(), MessageTypes.Default);
        }
    }

    protected void terminateHandle() {
        if (this.getPageCache().get("terminate") != null) {
            SrcMyTaskContext context = new SrcMyTaskContext();
            context.setCurrView(this.getView());
            Set handleIds = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("terminate"), HashSet.class);
            context.setHandleIds(handleIds);
            PdsOpenControlFacade.taskProcess(context, PdsTerminateProcess.class.getSimpleName());
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key;
        if (MessageBoxResult.Cancel.getValue() == evt.getResult().getValue()) {
            return;
        }
        switch (key = evt.getCallBackId()) {
            case "terminate": {
                this.terminateHandle();
                break;
            }
        }
    }
}

