/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.opencontrol.handle;

import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scm.pds.common.mytask.ISrcMyTaskOperationHandler;
import kd.scm.pds.common.mytask.SrcMyTaskContext;
import kd.scm.pds.common.opencontrol.PdsOpenControlFacade;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;

public class PdsSupEncryptButtonHandler
implements ISrcMyTaskOperationHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcMyTaskContext context) {
        this.getTodoTaskSet(context);
    }

    protected void getTodoTaskSet(SrcMyTaskContext context) {
        Set<Long> supplierUserIds;
        boolean isIntersected;
        DynamicObject myTaskObj = context.getMyTaskObj();
        if (PdsOpenControlFacade.isProjectTaskEnd(myTaskObj)) {
            return;
        }
        long bidderId = myTaskObj.getLong("bidder.id");
        long loginUserId = RequestContext.get().getCurrUserId();
        Set<Long> loginUserIds = SupplierUtil.getSupplierUserIdsByCurrUserId();
        boolean bl = isIntersected = PdsCommonUtils.getIntersectSet(loginUserIds, supplierUserIds = MultiBasedataUtils.getBasedataIdSet(myTaskObj, "supplieruser")).size() > 0;
        if (bidderId != loginUserId && (bidderId != 0L || supplierUserIds.size() != 0 && !isIntersected)) {
            return;
        }
        Set<String> todoTaskSet = PdsSupEncryptButtonHandler.getInitTodoTaskSet();
        if (!myTaskObj.getBoolean("isencrypt")) {
            todoTaskSet.remove("decrypt");
        } else {
            todoTaskSet.remove("encrypt");
        }
        if (myTaskObj.getBoolean("isdecrypt")) {
            todoTaskSet.remove("decrypt");
            todoTaskSet.remove("terminate");
        }
        if (bidderId != loginUserId) {
            todoTaskSet.remove("terminate");
        }
        context.setTodoTaskSet(todoTaskSet);
    }

    public static Set<String> getInitTodoTaskSet() {
        return new HashSet<String>(){
            {
                this.add("encrypt");
                this.add("decrypt");
                this.add("terminate");
            }
        };
    }
}

