/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.opencontrol.handle;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.scm.pds.common.mytask.SrcMyTaskContext;
import kd.scm.pds.common.opencontrol.PdsOpenControlFacade;
import kd.scm.pds.common.opencontrol.PdsOpenControlUtils;
import kd.scm.pds.common.opencontrol.handle.PdsSupEncryptButtonHandler;
import kd.scm.pds.common.opencontrol.process.PdsTerminateProcess;
import kd.scm.pds.common.opencontrol.verify.PdsSupDecryptVerify;
import kd.scm.pds.common.opencontrol.verify.PdsSupEncryptVerify;
import kd.scm.pds.common.opencontrol.verify.PdsTerminateVerify;
import kd.scm.pds.common.util.ListSelectUtils;
import kd.scm.pds.common.util.OpenFormUtils;

public class PdsSupEncryptTaskHandler
extends AbstractListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        String opKey = ((AbstractOperate)evt.getSource()).getOperateKey();
        if (opKey.equals("refresh") || opKey.equals("close")) {
            return;
        }
        evt.setCancel(true);
        Set<Long> selectIds = ListSelectUtils.getListSelectPrimaryKeys(this.getView());
        SrcMyTaskContext context = new SrcMyTaskContext();
        context.setCurrView(this.getView());
        context.setSelectIds(selectIds);
        switch (opKey) {
            case "encrypt": {
                this.encryptVerify(context);
                break;
            }
            case "decrypt": {
                this.decryptVerify(context);
                break;
            }
            case "terminate": {
                this.terminateVerify(context);
                break;
            }
        }
    }

    public void packageData(PackageDataEvent e) {
        if (e.getSource() instanceof ListOperationColumnDesc && "taskhandleop".equals(((ListOperationColumnDesc)e.getSource()).getKey())) {
            Set<String> todoTaskSet = PdsOpenControlFacade.getTodoTaskSet(e.getRowData(), PdsSupEncryptButtonHandler.class.getSimpleName());
            List operationColItems = (List)e.getFormatValue();
            for (OperationColItem operationColItem : operationColItems) {
                if (null != todoTaskSet && todoTaskSet.contains(operationColItem.getOperationKey())) {
                    operationColItem.setVisible(true);
                    continue;
                }
                operationColItem.setVisible(false);
            }
        }
        super.packageData(e);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String key;
        super.closedCallBack(evt);
        switch (key = evt.getActionId()) {
            case "encrypt": 
            case "decrypt": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    protected void encryptVerify(SrcMyTaskContext context) {
        PdsOpenControlFacade.taskVerify(context, PdsSupEncryptVerify.class.getSimpleName());
        if (context.isVerifyOk()) {
            OpenFormUtils.openDynamicPage(this.getView(), "pds_encrypttool", ShowType.Modal, PdsOpenControlUtils.getHandleInfoMap(context), new CloseCallBack((IFormPlugin)this, "bidopen"));
        } else {
            this.getView().showMessage(context.getVerifyMessage());
        }
    }

    protected void decryptVerify(SrcMyTaskContext context) {
        PdsOpenControlFacade.taskVerify(context, PdsSupDecryptVerify.class.getSimpleName());
        if (context.isVerifyOk()) {
            OpenFormUtils.openDynamicPage(this.getView(), "pds_decrypttool", ShowType.Modal, PdsOpenControlUtils.getHandleInfoMap(context), new CloseCallBack((IFormPlugin)this, "bidopen"));
        } else {
            this.getView().showMessage(context.getVerifyMessage());
        }
    }

    protected void terminateVerify(SrcMyTaskContext context) {
        PdsOpenControlFacade.taskVerify(context, PdsTerminateVerify.class.getSimpleName());
        if (context.isVerifyOk()) {
            this.getPageCache().put("terminate", SerializationUtils.toJsonString(context.getHandleIds()));
            this.getView().showConfirm(context.getVerifyMessage(), MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener("terminate"));
        } else {
            this.getPageCache().put("terminate", null);
            this.getView().showMessage(context.getVerifyMessage());
        }
    }

    protected void terminateHandle() {
        if (this.getPageCache().get("terminate") != null) {
            SrcMyTaskContext context = new SrcMyTaskContext();
            context.setCurrView(this.getView());
            Set handleIds = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("terminate"), HashSet.class);
            context.setHandleIds(handleIds);
            PdsOpenControlFacade.taskProcess(context, PdsTerminateProcess.class.getSimpleName());
            this.getView().invokeOperation("refresh");
            if (context.isHandleOk()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u6210\u529f\u3002", (String)"PdsSupEncryptTaskHandler_0", (String)"scm-pds-common", (Object[])new Object[0]));
            } else {
                this.getView().showMessage(context.getHandleMessage());
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key;
        if (MessageBoxResult.Cancel.getValue() == evt.getResult().getValue()) {
            return;
        }
        switch (key = evt.getCallBackId()) {
            case "terminate": {
                this.terminateHandle();
                break;
            }
        }
    }
}

