/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.opencontrol.verify;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.mytask.ISrcMyTaskHandler;
import kd.scm.pds.common.mytask.SrcMyTaskContext;
import kd.scm.pds.common.opencontrol.PdsOpenControlUtils;
import kd.scm.pds.common.opencontrol.verify.PdsBidopenVerifyAllCondition;

public class PdsBidopenVerify
implements ISrcMyTaskHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcMyTaskContext context) {
        if (context.getSelectIds() == null || context.getSelectIds().size() == 0) {
            String verifyMessage = ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u4efb\u52a1\u8fdb\u884c \u5f00\u6807\u3002", (String)"PdsBidopenVerify_0", (String)"scm-pds-common", (Object[])new Object[0]);
            context.setVerifyMessage(verifyMessage);
            context.setVerifyOk(false);
            return;
        }
        QFilter qFilter = new QFilter("id", "in", context.getSelectIds());
        QFilter openStatus = new QFilter("isbidopen", "=", (Object)"0");
        QFilter userFilter = new QFilter("bidder", "=", (Object)RequestContext.get().getCurrUserId());
        qFilter.and(openStatus).and(userFilter);
        String selectFilelds = "id,project.id,package.id,supplier.id,opentype";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"pds_bidopendetail", (String)selectFilelds, (QFilter[])qFilter.toArray());
        if (rows == null || rows.size() == 0) {
            String verifyMessage = ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u5f00\u6807\u6761\u4ef6\uff08\u672a\u5f00\u6807\uff0c\u5904\u7406\u4eba\u4e3a\u5f53\u524d\u7528\u6237\uff09\u7684\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PdsBidopenVerify_1", (String)"scm-pds-common", (Object[])new Object[0]);
            context.setVerifyMessage(verifyMessage);
            context.setVerifyOk(false);
            return;
        }
        StringBuilder sb = this.verifyAllCondition(rows);
        if (null != sb && sb.length() > 0) {
            context.setVerifyMessage(sb.toString());
            context.setVerifyOk(false);
            return;
        }
        PdsOpenControlUtils.getHandleInfo(rows, context);
        String verifyMessage = String.format(ResManager.loadKDString((String)"\u5171\u6709\uff1a %1$s \u4e2a\u4efb\u52a1\u5c06\u88ab\u5f00\u6807\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PdsBidopenVerify_2", (String)"scm-pds-common", (Object[])new Object[0]), rows.size());
        context.setVerifyMessage(verifyMessage);
        context.setVerifyOk(true);
    }

    public StringBuilder verifyAllCondition(DynamicObjectCollection rows) {
        Set<String> taskSet = rows.stream().map(e -> e.getString("project.id") + '_' + e.getString("opentype")).collect(Collectors.toSet());
        ExtPluginContext context = new ExtPluginContext();
        context.setCompKeys(taskSet);
        ExtPluginFactory.executeExtplugin(PdsBidopenVerifyAllCondition.class.getSimpleName(), context, false);
        return context.getMessage();
    }
}

