/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.operation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.pds.common.validator.SrcValidatorFactory;
import kd.scm.pds.common.validator.SrcValidatorInstance;

public class PdsOperationService
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        List fields = args.getFieldKeys();
        fields.add("id");
        fields.add("projectf7");
        fields.add("srctype");
        fields.add("sourcetype");
        fields.add("template");
        fields.add("tplentry");
        fields.add("tplentry.tmp_component");
        fields.add("tplentry.tmp_bizobject");
        fields.add("tplentry.tmp_template");
        fields.add("tplentry.srctplid");
        fields.add("creator");
        fields.add("createtime");
        fields.add("billstatus");
        fields.add("bizstatus");
        fields.add("scorestatus");
        fields.add("opentype");
        fields.add("openstatus");
        fields.add("managetype");
        fields.add("taxtype");
        fields.add("currency");
        fields.add("biztype");
        fields.add("sourceclass");
        fields.add("decisiontype");
        fields.add("tieredtype");
        fields.add("source");
        fields.add("org");
        fields.add("srcbilltype");
        fields.add("isclarify");
        fields.add("ischanged");
        Set<String> propertis = this.getOnPreparePropertys();
        for (String pro : propertis) {
            fields.add(pro);
        }
    }

    private Set<String> getOnPreparePropertys() {
        HashSet<String> propertis = new HashSet<String>(8);
        SrcValidatorData validatorData = new SrcValidatorData();
        String entityKey = this.billEntityType.getName();
        String opKey = String.valueOf(this.operateMeta.get("key"));
        validatorData.setBizObject(entityKey);
        validatorData.setOperation(opKey);
        List<SrcValidatorInstance> validatorList = SrcValidatorFactory.getInstance().getValidatorList(validatorData);
        for (int i = 0; i < validatorList.size(); ++i) {
            ISrcValidator validator = validatorList.get(i).getValidator();
            if (null == validator) continue;
            propertis.addAll(validator.getOnPreparePropertys());
        }
        StringBuilder numberSb = new StringBuilder();
        numberSb.append(entityKey).append('_').append(opKey);
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(numberSb.toString(), null);
        for (IExtPluginHandler handler : handlers) {
            propertis.addAll(handler.getOnPreparePropertys());
        }
        numberSb.append("_after");
        handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(numberSb.toString(), null);
        for (IExtPluginHandler handler : handlers) {
            propertis.addAll(handler.getOnPreparePropertys());
        }
        return propertis;
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] billObjs = args.getDataEntities();
        for (DynamicObject billObj : billObjs = this.reLoadBillObjs(billObjs)) {
            ExtPluginContext context = new ExtPluginContext();
            context.setBillObj(billObj);
            context.setBillId(SrmCommonUtil.getPkValue((DynamicObject)billObj));
            context.setProjectId(SrmCommonUtil.getPkValue((DynamicObject)billObj));
            context.setEntityId(billObj.getDataEntityType().getName());
            context.setOperationKey(args.getOperationKey());
            this.doAuditOperation(context);
        }
    }

    private DynamicObject[] reLoadBillObjs(DynamicObject[] billObjs) {
        OperateOption option = this.getOption();
        if (null == option || null == option.getVariableValue("modeltypeforwf", null)) {
            return billObjs;
        }
        if (!"list".equals(option.getVariables().get("modeltypeforwf"))) {
            return billObjs;
        }
        Set<Long> idSet = Arrays.asList(billObjs).stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        return PdsCommonUtils.loadBillObjsByIdSet(billObjs[0].getDataEntityType().getName(), idSet);
    }

    private void doAuditOperation(ExtPluginContext context) {
        StringBuilder numberSb = new StringBuilder();
        numberSb.append(context.getEntityId()).append('_').append(context.getOperationKey());
        context.setPluginNumber(numberSb.toString());
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(numberSb.toString(), null);
        for (IExtPluginHandler handler : handlers) {
            handler.process(context);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        DynamicObject[] billObjs = args.getDataEntities();
        for (DynamicObject billObj : billObjs = this.reLoadBillObjs(billObjs)) {
            ExtPluginContext context = new ExtPluginContext();
            context.setBillObj(billObj);
            context.setBillId(SrmCommonUtil.getPkValue((DynamicObject)billObj));
            context.setProjectId(SrmCommonUtil.getPkValue((DynamicObject)billObj));
            context.setEntityId(billObj.getDataEntityType().getName());
            context.setOperationKey(args.getOperationKey());
            this.afterAuditHandle(context);
        }
    }

    private void afterAuditHandle(ExtPluginContext context) {
        StringBuilder numberSb = new StringBuilder();
        numberSb.append(context.getEntityId()).append('_').append(context.getOperationKey()).append("_after");
        context.setPluginNumber(numberSb.toString());
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(numberSb.toString(), null);
        for (IExtPluginHandler handler : handlers) {
            handler.process(context);
        }
    }
}

