/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.question;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.question.IPdsQuestionHandler;
import kd.scm.pds.common.question.ISrcQuestionButtonVisible;
import kd.scm.pds.common.question.ITndQuestionButtonVisible;
import kd.scm.pds.common.question.PdsQuestionContext;
import kd.scm.pds.common.question.PdsQuestionUtils;
import kd.scm.pds.common.question.clarify.ISrcQuestionClarifyFilter;
import kd.scm.pds.common.question.clarify.ISrcQuestionClarifyHandler;
import kd.scm.pds.common.question.clarify.ISrcQuestionClarifyPageInit;
import kd.scm.pds.common.question.clarify.ISrcQuestionClarifyProChg;
import kd.scm.pds.common.question.clarify.ITndQuestionClarifyFilter;
import kd.scm.pds.common.question.clarify.ITndQuestionClarifyHandler;
import kd.scm.pds.common.question.clarify.ITndQuestionClarifyPageInit;
import kd.scm.pds.common.question.clarify.ITndQuestionClarifyProChg;
import kd.scm.pds.common.question.query.ISrcQuestionQueryFilter;
import kd.scm.pds.common.question.query.ISrcQuestionQueryHandler;
import kd.scm.pds.common.question.query.ISrcQuestionQueryPageInit;
import kd.scm.pds.common.question.query.ISrcQuestionQueryProChg;
import kd.scm.pds.common.question.query.ITndQuestionQueryFilter;
import kd.scm.pds.common.question.query.ITndQuestionQueryHandler;
import kd.scm.pds.common.question.query.ITndQuestionQueryPageInit;
import kd.scm.pds.common.question.query.ITndQuestionQueryProChg;
import kd.scm.pds.common.question.reply.ISrcQuestionReplyAfterSave;
import kd.scm.pds.common.question.reply.ISrcQuestionReplyBeforeSave;
import kd.scm.pds.common.question.reply.ISrcQuestionReplyPageInit;
import kd.scm.pds.common.question.reply.ISrcQuestionReplyVerify;
import kd.scm.pds.common.question.reply.ISrcQuestionUnReplyHandler;
import kd.scm.pds.common.question.reply.ITndQuestionReplyAfterSave;
import kd.scm.pds.common.question.reply.ITndQuestionReplyBeforeSave;
import kd.scm.pds.common.question.reply.ITndQuestionReplyPageInit;
import kd.scm.pds.common.question.reply.ITndQuestionReplyVerify;
import kd.scm.pds.common.question.reply.ITndQuestionUnReplyHandler;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsQuestionFacade {
    public static void openQuestionList(IFormView currView, IDataModel model, String pageKey, boolean isProjectBill) {
        long projectId = PdsQuestionUtils.getProjectIdForQuestion(currView, model, isProjectBill);
        if (projectId == 0L) {
            OpenFormUtils.openListPage(currView, pageKey, ShowType.MainNewTabPage, null, null, null);
        } else {
            HashMap<String, Object> customParams = new HashMap<String, Object>(2);
            customParams.put("project", projectId);
            QFilter qFilter = new QFilter("project", "=", (Object)projectId);
            OpenFormUtils.openListPage(currView, pageKey, ShowType.MainNewTabPage, customParams, qFilter, null);
        }
    }

    public static void setQuestionButtonVisible(IFormView currView) {
        PdsQuestionContext context = new PdsQuestionContext();
        context.setView(currView);
        List handlers = null;
        if (currView.getEntityId().equals("src_question")) {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ISrcQuestionButtonVisible.class.getSimpleName(), null);
            context.setOrigin("1");
        } else {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ITndQuestionButtonVisible.class.getSimpleName(), null);
            context.setOrigin("2");
        }
        for (IPdsQuestionHandler handler : handlers) {
            if (!context.isSucced()) continue;
            handler.process(context);
        }
    }

    public static PdsQuestionContext questionUnReply(DynamicObject billObj) {
        PdsQuestionContext context = new PdsQuestionContext();
        context.setBillObj(billObj);
        List handlers = null;
        if (billObj.getDataEntityType().getName().equals("src_question")) {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ISrcQuestionUnReplyHandler.class.getSimpleName(), null);
            context.setOrigin("1");
        } else {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ITndQuestionUnReplyHandler.class.getSimpleName(), null);
            context.setOrigin("2");
        }
        for (IPdsQuestionHandler handler : handlers) {
            if (!context.isSucced()) continue;
            handler.process(context);
        }
        return context;
    }

    public static PdsQuestionContext replySelectVerify(String entityId, Map<String, Object> paramMap) {
        PdsQuestionContext context = new PdsQuestionContext();
        context.setParamMap(paramMap);
        context.setEntityId(entityId);
        List handlers = null;
        if (entityId.equals("src_question")) {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ISrcQuestionReplyVerify.class.getSimpleName(), null);
            context.setOrigin("1");
        } else {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ITndQuestionReplyVerify.class.getSimpleName(), null);
            context.setOrigin("2");
        }
        for (IPdsQuestionHandler handler : handlers) {
            if (!context.isSucced()) continue;
            handler.process(context);
        }
        return context;
    }

    public static void replyPageInit(IFormView currView) {
        PdsQuestionContext context = new PdsQuestionContext();
        context.setView(currView);
        List handlers = null;
        if (currView.getEntityId().equals("src_reply")) {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ISrcQuestionReplyPageInit.class.getSimpleName(), null);
            context.setOrigin("1");
        } else {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ITndQuestionReplyPageInit.class.getSimpleName(), null);
            context.setOrigin("2");
        }
        for (IPdsQuestionHandler handler : handlers) {
            if (!context.isSucced()) continue;
            handler.process(context);
        }
    }

    public static void replyFilter(IFormView currView, BeforeF7SelectEvent beforeF7Evt) {
        PdsQuestionContext context = new PdsQuestionContext();
        context.setView(currView);
        context.setBeforeF7Evt(beforeF7Evt);
        List<Object> handlers = Collections.emptyList();
        if (currView.getEntityId().equals("src_reply")) {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle("ISrcQuestionReplyFilter", null);
            context.setOrigin("1");
        }
        for (IPdsQuestionHandler handler : handlers) {
            if (!context.isSucced()) continue;
            handler.process(context);
        }
    }

    public static void replyBeforeSave(IFormView currView, BeforeDoOperationEventArgs beforeOpArgs) {
        PdsQuestionContext context = new PdsQuestionContext();
        context.setView(currView);
        context.setBeforeOpArgs(beforeOpArgs);
        List handlers = null;
        if (currView.getEntityId().equals("src_reply")) {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ISrcQuestionReplyBeforeSave.class.getSimpleName(), null);
            context.setOrigin("1");
        } else {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ITndQuestionReplyBeforeSave.class.getSimpleName(), null);
            context.setOrigin("2");
        }
        for (IPdsQuestionHandler handler : handlers) {
            if (!context.isSucced()) continue;
            handler.process(context);
        }
        if (!context.isSucced()) {
            beforeOpArgs.setCancel(true);
            context.getView().showMessage(context.getMessage().toString());
        }
    }

    public static void replyAfterSave(IFormView currView, AfterDoOperationEventArgs afterOpArgs) {
        PdsQuestionContext context = new PdsQuestionContext();
        context.setView(currView);
        context.setAfterOpArgs(afterOpArgs);
        List handlers = null;
        if (currView.getEntityId().equals("src_reply")) {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ISrcQuestionReplyAfterSave.class.getSimpleName(), null);
            context.setOrigin("1");
        } else {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ITndQuestionReplyAfterSave.class.getSimpleName(), null);
            context.setOrigin("2");
        }
        for (IPdsQuestionHandler handler : handlers) {
            if (!context.isSucced()) continue;
            handler.process(context);
        }
    }

    public static void queryPageInit(IFormView currView) {
        PdsQuestionContext context = new PdsQuestionContext();
        context.setView(currView);
        List handlers = null;
        if (currView.getEntityId().equals("src_query")) {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ISrcQuestionQueryPageInit.class.getSimpleName(), null);
            context.setOrigin("1");
        } else {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ITndQuestionQueryPageInit.class.getSimpleName(), null);
            context.setOrigin("2");
        }
        for (IPdsQuestionHandler handler : handlers) {
            if (!context.isSucced()) continue;
            handler.process(context);
        }
    }

    public static void queryFilter(IFormView currView, BeforeF7SelectEvent beforeF7Evt) {
        PdsQuestionContext context = new PdsQuestionContext();
        context.setView(currView);
        context.setBeforeF7Evt(beforeF7Evt);
        List handlers = null;
        if (currView.getEntityId().equals("src_query")) {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ISrcQuestionQueryFilter.class.getSimpleName(), null);
            context.setOrigin("1");
        } else {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ITndQuestionQueryFilter.class.getSimpleName(), null);
            context.setOrigin("2");
        }
        for (IPdsQuestionHandler handler : handlers) {
            if (!context.isSucced()) continue;
            handler.process(context);
        }
    }

    public static void queryPrgChg(IFormView currView, PropertyChangedArgs proChgArgs) {
        PdsQuestionContext context = new PdsQuestionContext();
        context.setView(currView);
        context.setProChgArgs(proChgArgs);
        List handlers = null;
        if (currView.getEntityId().equals("src_query")) {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ISrcQuestionQueryProChg.class.getSimpleName(), null);
            context.setOrigin("1");
        } else {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ITndQuestionQueryProChg.class.getSimpleName(), null);
            context.setOrigin("2");
        }
        for (IPdsQuestionHandler handler : handlers) {
            if (!context.isSucced()) continue;
            handler.process(context);
        }
    }

    public static void queryHandle(IFormView currView, BeforeDoOperationEventArgs beforeOpArgs) {
        PdsQuestionContext context = new PdsQuestionContext();
        context.setView(currView);
        context.setBeforeOpArgs(beforeOpArgs);
        List handlers = null;
        if (currView.getEntityId().equals("src_query")) {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ISrcQuestionQueryHandler.class.getSimpleName(), null);
            context.setOrigin("1");
        } else {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ITndQuestionQueryHandler.class.getSimpleName(), null);
            context.setOrigin("2");
        }
        for (IPdsQuestionHandler handler : handlers) {
            if (!context.isSucced()) continue;
            handler.process(context);
        }
        if (!context.isSucced()) {
            beforeOpArgs.setCancel(true);
            context.getView().showMessage(context.getMessage().toString());
        }
    }

    public static void clarifyPageInit(IFormView currView) {
        PdsQuestionContext context = new PdsQuestionContext();
        context.setView(currView);
        List handlers = null;
        if (currView.getEntityId().equals("src_clarify") || currView.getEntityId().equals("src_priceclarify")) {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ISrcQuestionClarifyPageInit.class.getSimpleName(), null);
            context.setOrigin("1");
        } else {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ITndQuestionClarifyPageInit.class.getSimpleName(), null);
            context.setOrigin("2");
        }
        for (IPdsQuestionHandler handler : handlers) {
            if (!context.isSucced()) continue;
            handler.process(context);
        }
    }

    public static void clarifyFilter(IFormView currView, BeforeF7SelectEvent beforeF7Evt) {
        PdsQuestionContext context = new PdsQuestionContext();
        context.setView(currView);
        context.setBeforeF7Evt(beforeF7Evt);
        List handlers = null;
        if (currView.getEntityId().equals("src_clarify") || currView.getEntityId().equals("src_priceclarify")) {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ISrcQuestionClarifyFilter.class.getSimpleName(), null);
            context.setOrigin("1");
        } else {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ITndQuestionClarifyFilter.class.getSimpleName(), null);
            context.setOrigin("2");
        }
        for (IPdsQuestionHandler handler : handlers) {
            if (!context.isSucced()) continue;
            handler.process(context);
        }
    }

    public static void clarifyPrgChg(IFormView currView, PropertyChangedArgs proChgArgs) {
        PdsQuestionContext context = new PdsQuestionContext();
        context.setView(currView);
        context.setProChgArgs(proChgArgs);
        List handlers = null;
        if (currView.getEntityId().equals("src_clarify") || currView.getEntityId().equals("src_priceclarify")) {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ISrcQuestionClarifyProChg.class.getSimpleName(), null);
            context.setOrigin("1");
        } else {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ITndQuestionClarifyProChg.class.getSimpleName(), null);
            context.setOrigin("2");
        }
        for (IPdsQuestionHandler handler : handlers) {
            if (!context.isSucced()) continue;
            handler.process(context);
        }
    }

    public static void clarifyHandle(IFormView currView, BeforeDoOperationEventArgs beforeOpArgs) {
        PdsQuestionContext context = new PdsQuestionContext();
        context.setView(currView);
        context.setBeforeOpArgs(beforeOpArgs);
        List handlers = null;
        if (currView.getEntityId().equals("src_clarify") || currView.getEntityId().equals("src_priceclarify")) {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ISrcQuestionClarifyHandler.class.getSimpleName(), null);
            context.setOrigin("1");
        } else {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ITndQuestionClarifyHandler.class.getSimpleName(), null);
            context.setOrigin("2");
        }
        for (IPdsQuestionHandler handler : handlers) {
            if (!context.isSucced()) continue;
            handler.process(context);
        }
        if (!context.isSucced()) {
            beforeOpArgs.setCancel(true);
            context.getView().showMessage(context.getMessage().toString());
        }
    }

    public static void auditAfterSave(IFormView currView, AfterDoOperationEventArgs args) {
        OperationResult result = args.getOperationResult();
        if (null != result && !result.isSuccess()) {
            return;
        }
        if (BillStatusEnum.AUDIT.getVal().equals(currView.getModel().getDataEntity().getString("billstatus"))) {
            return;
        }
        long projectId = currView.getModel().getDataEntity().getLong("project.id");
        long sourceFlowId = currView.getModel().getDataEntity().getLong("project.srctype.id");
        String priceClarifyType = PdsCommonUtils.object2String(ExtParameterUtils.getExtParameterValueById("pds_flowconfig", sourceFlowId, "isPriceClarifyAfterBidOpen", "0", projectId), "0");
        boolean isPriceClarify = currView.getModel().getDataEntity().getBoolean("isclarify");
        String publishtype = currView.getModel().getDataEntity().getString("publishtype");
        if ("7".equals(publishtype) || isPriceClarify && "1".equals(priceClarifyType) || !PdsQuestionUtils.isQuestionNeedAutid(currView)) {
            try {
                Object billId = args.getOperationResult().getSuccessPkIds().get(0);
                DynamicObject billObj = null;
                billObj = BusinessDataServiceHelper.loadSingle(billId, (String)"src_question");
                OperateOption option = OperateOption.create();
                option.setVariableValue("isStrict", "false");
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("WF", String.valueOf(false));
                OperationServiceHelper.executeOperate((String)"submit", (String)billObj.getDynamicObjectType().getName(), (Object[])new Long[]{billObj.getLong("id")}, (OperateOption)option);
                if (!isPriceClarify || !"2".equals(priceClarifyType) || "7".equals(publishtype)) {
                    OperationServiceHelper.executeOperate((String)"audit", (String)"src_question", (Object[])new Long[]{billObj.getLong("id")}, (OperateOption)option);
                }
            }
            catch (Exception e) {
                if (!isPriceClarify || !"2".equals(priceClarifyType)) {
                    currView.getModel().setValue("billstatus", (Object)BillStatusEnum.AUDIT.getVal());
                    currView.getModel().setValue("auditor", (Object)RequestContext.get().getCurrUserId());
                    currView.getModel().setValue("auditdate", (Object)TimeServiceHelper.now());
                } else {
                    currView.getModel().setValue("billstatus", (Object)BillStatusEnum.SUBMIT.getVal());
                }
                PdsCommonUtils.saveDynamicObjects(currView.getModel().getDataEntity(true));
            }
        }
    }
}

