/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.question;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.enums.QuestionTypeEnums;
import kd.scm.pds.common.question.PdsQuestionContext;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.ListSelectUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsQuestionUtils {
    public static long getProjectIdForQuestion(IFormView currView, IDataModel model, boolean isProjectBill) {
        long projectId = 0L;
        if (null != model) {
            projectId = !isProjectBill ? PdsCommonUtils.object2Long(model.getDataEntity().getDynamicObject("project").getPkValue()) : PdsCommonUtils.object2Long(model.getDataEntity().getPkValue());
            return projectId;
        }
        projectId = ListSelectUtils.selectOne(currView);
        if (projectId == 0L) {
            return projectId;
        }
        if (!isProjectBill) {
            BillList list = (BillList)currView.getControl("billlistap");
            QFilter qFilter = new QFilter("id", "=", (Object)projectId);
            DynamicObject billObj = QueryServiceHelper.queryOne((String)list.getEntityId(), (String)"project.id", (QFilter[])qFilter.toArray());
            projectId = billObj.getLong("project.id");
        }
        return projectId;
    }

    public static boolean isQuestionNeedAutid(IFormView currView) {
        boolean isQuestionAudit = false;
        Object isQuestionAuditObj = null;
        isQuestionAuditObj = Objects.equals("src", currView.getEntityId().substring(0, 3)) ? ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"ispurquestionaudit") : ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"issupquestionaudit");
        if (null != isQuestionAuditObj) {
            isQuestionAudit = (Boolean)isQuestionAuditObj;
        }
        return isQuestionAudit;
    }

    public static boolean isCreatedByCurrentRole(IFormView currView) {
        String publishType = currView.getModel().getDataEntity().getString("publishtype");
        if (Objects.equals("src", currView.getEntityId().substring(0, 3))) {
            return Objects.equals(QuestionTypeEnums.PUR_CLARIFY.getValue(), publishType) || Objects.equals(QuestionTypeEnums.PUR_QUERY.getValue(), publishType) || Objects.equals(QuestionTypeEnums.PUR_REPLY.getValue(), publishType);
        }
        return Objects.equals(QuestionTypeEnums.SUP_CLARIFY.getValue(), publishType) || Objects.equals(QuestionTypeEnums.SUP_QUERY.getValue(), publishType) || Objects.equals(QuestionTypeEnums.SUP_REPLY.getValue(), publishType);
    }

    public static List<Long> getBillIdsFromCustomParamMap(IFormView currView) {
        Object billIdsObj;
        List billIds = Collections.emptyList();
        Map<String, Object> paramMap = PdsCommonUtils.getCustomParamMap(currView);
        if (null != paramMap && paramMap.size() > 0 && null != (billIdsObj = paramMap.get("billid"))) {
            billIds = (List)billIdsObj;
        }
        return billIds;
    }

    public static long getProjectId(PdsQuestionContext context) {
        DynamicObject projectObj = context.getView().getModel().getDataEntity().getDynamicObject("project");
        return SrmCommonUtil.getPkValue((DynamicObject)projectObj);
    }

    public static boolean isTenderSupplier(PdsQuestionContext context) {
        DynamicObject projectObj = context.getView().getModel().getDataEntity().getDynamicObject("project");
        if (null == projectObj || BidOpenStatusEnums.NOOPEN.getValue().equals(projectObj.getString("openstatus"))) {
            return false;
        }
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)projectObj.getDynamicObject("srctype"));
        return ExtParameterUtils.convertToBoolen(ExtParameterUtils.getExtParameterValueById("pds_flowconfig", sourceFlowId, "isTenderSupplierForQuestion", false, SrmCommonUtil.getPkValue((DynamicObject)projectObj)));
    }

    public static QFilter supplierScopeFilter(PdsQuestionContext context) {
        DynamicObjectCollection rows = null;
        rows = PdsQuestionUtils.isTenderSupplier(context) ? PdsQuestionUtils.getTenderSupplierRows(context, PdsQuestionUtils.getProjectId(context)) : PdsQuestionUtils.getInviteSupplierRows(context, PdsQuestionUtils.getProjectId(context));
        Set supplierIds = rows.stream().map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
        QFilter supplierFilter = new QFilter("id", "in", supplierIds);
        return supplierFilter;
    }

    public static QFilter projectFilter(PdsQuestionContext context) {
        DynamicObjectCollection rows = PdsQuestionUtils.getInviteSupplierRows(context, 0L);
        Set projectIds = rows.stream().map(e -> e.getLong("billid")).collect(Collectors.toSet());
        QFilter projectFilter = new QFilter("id", "in", projectIds);
        return projectFilter;
    }

    public static QFilter packageFilter(PdsQuestionContext context) {
        DynamicObjectCollection rows = PdsQuestionUtils.getInviteSupplierRows(context, PdsQuestionUtils.getProjectId(context));
        Set packageIds = rows.stream().map(e -> e.getLong("package.id")).collect(Collectors.toSet());
        QFilter packageFilter = new QFilter("id", "in", packageIds);
        return packageFilter;
    }

    public static DynamicObjectCollection getInviteSupplierRows(PdsQuestionContext context, long projectId) {
        QFilter qfilter = new QFilter("isinvite", "=", (Object)"1");
        if (projectId > 0L) {
            qfilter.and("billid", "=", (Object)projectId);
        }
        if ("2".equals(context.getOrigin())) {
            qfilter.and("supplier", "in", PdsCommonUtils.getSupplierByUserOfBizPartner());
        }
        return QueryServiceHelper.query((String)"src_supplierinvite", (String)"billid,package.id,suppliertype,supplier.id", (QFilter[])qfilter.toArray());
    }

    public static DynamicObjectCollection getTenderSupplierRows(PdsQuestionContext context, long projectId) {
        QFilter qfilter = new QFilter("istender", "=", (Object)"1");
        if (projectId > 0L) {
            qfilter.and("billid", "=", (Object)projectId);
        }
        if ("2".equals(context.getOrigin())) {
            qfilter.and("supplier", "in", PdsCommonUtils.getSupplierByUserOfBizPartner());
        }
        return QueryServiceHelper.query((String)"src_bidopensupplier", (String)"billid,package.id,suppliertype,supplier.id", (QFilter[])qfilter.toArray());
    }
}

