/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.selecttool;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.pds.common.selecttool.IPdsInitContext;
import kd.scm.pds.common.selecttool.SupplierContext;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsInitContext
implements IPdsInitContext<SupplierContext> {
    private static final long serialVersionUID = 1L;

    @Override
    public void initContext(SupplierContext context) {
        DynamicObject billObj = context.getView().getModel().getDataEntity();
        context.setToolObj(billObj);
        this.initProject(context, billObj);
        this.initCategory(context, billObj);
        this.initPurOrg(context, billObj);
        this.initSupplier(context, billObj);
        this.initSupplyProvince(context, billObj);
        this.initSupplierStatus(context, billObj);
        this.initPerformance(context, billObj);
        this.initOtherInfo(context, billObj);
    }

    public void initProject(SupplierContext context, DynamicObject billObj) {
        context.setProjectId(billObj.getLong("project.id"));
        context.setPackageId(PdsCommonUtils.object2Long(context.getParamMap().get("packageid")));
        context.setPurlistId(PdsCommonUtils.object2Long(context.getParamMap().get("purlistid")));
        context.setManageType(billObj.getString("managetype"));
        context.setSourceTypeId(billObj.getLong("sourcetype.id"));
        context.setAmount(billObj.getBigDecimal("amount"));
        context.setIsSpecial(billObj.getBoolean("isspecial"));
        context.setBizTypeId(billObj.getLong("biztype.id"));
        context.setBizTypeName(billObj.getString("biztype.name"));
    }

    public void initCategory(SupplierContext context, DynamicObject billObj) {
        List<Long> purlistIds = ((DynamicObjectCollection)context.getView().getModel().getValue("purlist")).stream().map(row -> row.getLong("fbasedataid.material.id")).collect(Collectors.toList());
        context.setPurlistIds(purlistIds);
        List<Long> categoryIds = ((DynamicObjectCollection)context.getView().getModel().getValue("category")).stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toList());
        context.setCategoryIds(categoryIds);
        List<String> categorynames = ((DynamicObjectCollection)context.getView().getModel().getValue("category")).stream().map(row -> row.getString("fbasedataid.name")).collect(Collectors.toList());
        context.setCategoryNames(categorynames);
        context.setPurchaseType(PdsCommonUtils.getMulComboFieldValue(context.getView().getModel(), "purchasetype"));
        context.setAuditStatus(PdsCommonUtils.getMulComboFieldValue(context.getView().getModel(), "auditstatus"));
        context.setAllCategory(billObj.getBoolean("isallcategory"));
    }

    public void initPurOrg(SupplierContext context, DynamicObject billObj) {
        List<Long> purorgIds = ((DynamicObjectCollection)context.getView().getModel().getValue("purorg")).stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toList());
        context.setPurorgIds(purorgIds);
        List<String> purorgnames = ((DynamicObjectCollection)context.getView().getModel().getValue("purorg")).stream().map(row -> row.getString("fbasedataid.name")).collect(Collectors.toList());
        context.setPurorgNames(purorgnames);
        context.setPurdeptId(billObj.getLong("purdept.id"));
        context.setPurdeptName(billObj.getString("purdept.name"));
        context.setPurdeptNum(billObj.getString("purdept.number"));
        context.setPurgroupId(billObj.getLong("purgroup.id"));
        context.setPurgroupName(billObj.getString("purgroup.name"));
        context.setAllPurorg(billObj.getBoolean("isallpurorg"));
    }

    public void initSupplier(SupplierContext context, DynamicObject billObj) {
        Set<String> suppliertype = PdsCommonUtils.getMulComboFieldValue(context.getView().getModel(), "suppliertype");
        if (!CollectionUtils.isEmpty(suppliertype)) {
            context.setSupplierType(PdsCommonUtils.getMulComboFieldValue(context.getView().getModel(), "suppliertype"));
        }
        context.setVendorAttributes(PdsCommonUtils.getMulComboFieldValue(context.getView().getModel(), "vendorattribute"));
        context.setSellOff(billObj.getBoolean("isSelloff"));
        context.setExcSupplier(billObj.getString("excsupplier"));
    }

    public void initSupplyProvince(SupplierContext context, DynamicObject billObj) {
        List<Long> supplyprovinceIds = ((DynamicObjectCollection)context.getView().getModel().getValue("supplyprovince")).stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toList());
        context.setSupplyProvinceIds(supplyprovinceIds);
        List<String> supplyProvinceNames = ((DynamicObjectCollection)context.getView().getModel().getValue("supplyprovince")).stream().map(row -> row.getString("fbasedataid.name")).collect(Collectors.toList());
        context.setSupplyProvinceNames(supplyProvinceNames);
        context.setAllProvince(billObj.getBoolean("isallprovince"));
    }

    public void initSupplierStatus(SupplierContext context, DynamicObject billObj) {
        List<Long> supplierStatusIds = ((DynamicObjectCollection)context.getView().getModel().getValue("supplier_status")).stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toList());
        context.setSupplierStatusIds(supplierStatusIds);
        List<String> supplierstatusNames = ((DynamicObjectCollection)context.getView().getModel().getValue("supplier_status")).stream().map(row -> row.getString("fbasedataid.name")).collect(Collectors.toList());
        context.setSupplierStatusNames(supplierstatusNames);
    }

    public void initPerformance(SupplierContext context, DynamicObject billObj) {
        List<Long> performanceIds = ((DynamicObjectCollection)context.getView().getModel().getValue("performance")).stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toList());
        context.setPerformanceIds(performanceIds);
        List<String> performanceNames = ((DynamicObjectCollection)context.getView().getModel().getValue("performance")).stream().map(row -> row.getString("fbasedataid.name")).collect(Collectors.toList());
        context.setPerformanceNames(performanceNames);
    }

    public void initOtherInfo(SupplierContext context, DynamicObject billObj) {
        context.setMainNatures(PdsCommonUtils.getMulComboFieldValue(context.getView().getModel(), "mainnature"));
        context.setRandomCount((Integer)context.getView().getModel().getValue("expertcount"));
        if (context.getRandomCount() == 0) {
            context.setRandomCount(10000);
        }
    }
}

