/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.selecttool;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.field.ComboEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.enums.SrcBizTypeEnums;
import kd.scm.pds.common.inviteenum.SupplierTypeEnum;
import kd.scm.pds.common.selecttool.IPdsInitModel;
import kd.scm.pds.common.selecttool.PdsSelectUtils;
import kd.scm.pds.common.selecttool.SupplierContext;
import kd.scm.pds.common.util.ComboEditUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsPurlistUtils;

public class PdsInitModel
implements IPdsInitModel<SupplierContext> {
    @Override
    public void initModel(SupplierContext context) {
        this.initProject(context);
        if (context.getProjectObj() == null) {
            return;
        }
        this.initPickScheme(context);
        this.initCategory(context);
        this.initPurOrg(context);
        this.initPurchaseType(context);
        this.initSupplierType(context);
        this.initOtherInfo(context);
        this.initPurlist(context);
    }

    public void initPickScheme(SupplierContext context) {
        long pickSchemeId = PdsCommonUtils.object2Long(context.getParamMap().get("pickscheme"));
        if (pickSchemeId > 0L) {
            DynamicObject billObj = context.getView().getModel().getDataEntity(true);
            DynamicObject pickSchemeObj = BusinessDataServiceHelper.loadSingle((Object)pickSchemeId, (String)"src_supplierpick");
            List properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)pickSchemeObj);
            PdsCommonUtils.copyDynamicObjectValue(pickSchemeObj, billObj, properties, new HashSet<String>(), -1);
            context.getView().getModel().setValue("pickscheme", (Object)pickSchemeObj);
            context.setPickSchemeObj(pickSchemeObj);
            if ("2".equals(context.getView().getModel().getDataEntity().getString("isallsupplier"))) {
                context.setAllSupplier(true);
            }
        }
    }

    public void initProject(SupplierContext context) {
        String manageType;
        long projectId;
        Map<String, Object> paramMap = context.getParamMap();
        long l = projectId = paramMap.get("project") == null ? 0L : (Long)paramMap.get("project");
        if (projectId == 0L) {
            return;
        }
        context.getView().getModel().setValue("project", (Object)projectId);
        QFilter qfilter = PdsPurlistUtils.getOriginalPurlistQFilter(projectId);
        if (null != paramMap.get("purlist_id")) {
            Set<Long> purlistIds = PdsCommonUtils.object2Set(paramMap.get("purlist_id"));
            qfilter.and("id", "in", purlistIds);
        }
        if (null != paramMap.get("package_id")) {
            Set<Long> packageIds = PdsCommonUtils.object2Set(paramMap.get("package_id"));
            qfilter.and("id", "in", packageIds);
        }
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_project");
        DynamicObject baseinfoObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_project_base");
        switch (manageType = (String)context.getParamMap().get("managetype")) {
            case "2": {
                long packageId = paramMap.get("packageid") == null ? 0L : (Long)paramMap.get("packageid");
                context.getView().getModel().setValue("package", (Object)new Object[]{packageId});
                if (packageId <= 0L) break;
                qfilter = qfilter.and("package.id", "=", (Object)packageId);
                break;
            }
            case "3": {
                long purlistId = paramMap.get("purlistid") == null ? 0L : (Long)paramMap.get("purlistid");
                context.getView().getModel().setValue("purlist", (Object)new Object[]{purlistId});
                if (purlistId <= 0L) break;
                qfilter = qfilter.and("purlist.id", "=", (Object)purlistId);
                break;
            }
        }
        context.setProjectObj(projectObj);
        context.setBaseInfoObj(baseinfoObj);
        context.setPurlistQFilter(qfilter);
    }

    public void initCategory(SupplierContext context) {
        List<Object> categoryList = null;
        if (SourceTypeEnums.SELL_OFF.getValue().equals(context.getProjectObj().getString("sourcetype.number"))) {
            String number = context.getExtData().getSellCategoryNumber(context);
            DynamicObjectCollection rows = QueryServiceHelper.query((String)"bd_materialgroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
            categoryList = rows.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
        } else {
            DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"category.id", (QFilter[])context.getPurlistQFilter().toArray());
            categoryList = rows.stream().map(row -> row.getLong("category.id")).collect(Collectors.toList());
        }
        context.getView().getModel().setValue("category", (Object)categoryList.toArray(new Object[categoryList.size()]));
    }

    public void initPurOrg(SupplierContext context) {
        Set<Long> purOrgSet = PdsSelectUtils.getPurOrgSet(context, null);
        context.getView().getModel().setValue("purorg", (Object)purOrgSet.toArray(new Object[purOrgSet.size()]));
        context.getView().getModel().setValue("purdept", (Object)SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj().getDynamicObject("purdept")));
        context.getView().getModel().setValue("purgroup", (Object)SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj().getDynamicObject("purgroup")));
        context.getView().getModel().setValue("purgrouptype", (Object)",1,2,");
    }

    public void initPurchaseType(SupplierContext context) {
        String bizPattern = PdsCommonUtils.object2String(context.getBaseInfoObj().getString("biztype.number"), SrcBizTypeEnums.BIZTYPE3.getValue());
        if (SrcBizTypeEnums.BIZTYPE1.getValue().equals(bizPattern) || SrcBizTypeEnums.BIZTYPE2.getValue().equals(bizPattern)) {
            context.getView().getModel().setValue("purchasetype", (Object)"1");
        } else if (SrcBizTypeEnums.BIZTYPE3.getValue().equals(bizPattern)) {
            context.getView().getModel().setValue("purchasetype", (Object)",1,2,");
        } else if (SrcBizTypeEnums.BIZTYPE4.getValue().equals(bizPattern) || SrcBizTypeEnums.BIZTYPE5.getValue().equals(bizPattern)) {
            context.getView().getModel().setValue("purchasetype", (Object)"2");
        }
    }

    public void initSupplierType(SupplierContext context) {
        Boolean isspecial = context.getProjectObj().getBoolean("isspecial");
        BigDecimal amount = context.getBaseInfoObj().getBigDecimal("amount");
        String purNum = context.getProjectObj().getString("purdept.number");
        String sourcetypeNum = context.getProjectObj().getString("sourcetype.number");
        HashMap<String, String> comboMap = new HashMap<String, String>(16);
        BigDecimal limitAmount = new BigDecimal("0");
        limitAmount = context.getExtData().getLimitAmount(context);
        comboMap.put(SupplierTypeEnum.QUALIFIED.getValue(), SupplierTypeEnum.QUALIFIED.getName());
        if (!"A1".equals(purNum)) {
            comboMap.put(SupplierTypeEnum.TEMPORARY.getValue(), SupplierTypeEnum.TEMPORARY.getName());
        } else {
            if (amount.compareTo(limitAmount) < 0 || SourceTypeEnums.SELL_OFF.getValue().equals(sourcetypeNum)) {
                comboMap.put(SupplierTypeEnum.TEMPORARY.getValue(), SupplierTypeEnum.TEMPORARY.getName());
            }
            if (isspecial.booleanValue()) {
                comboMap.put(SupplierTypeEnum.SPECIAL.getValue(), SupplierTypeEnum.SPECIAL.getName());
            }
        }
        ComboEdit suppliertype = (ComboEdit)context.getView().getControl("suppliertype");
        suppliertype.setComboItems(ComboEditUtils.getComboList(comboMap));
        context.getView().getModel().setValue("suppliertype", (Object)SupplierTypeEnum.QUALIFIED.getValue());
    }

    public void initOtherInfo(SupplierContext context) {
        String managetype = context.getProjectObj().getString("managetype");
        context.getView().getModel().setValue("managetype", (Object)managetype);
        DynamicObject bizPattern = context.getBaseInfoObj().getDynamicObject("biztype");
        context.getView().getModel().setValue("biztype", (Object)SrmCommonUtil.getPkValue((DynamicObject)bizPattern));
        context.getView().getModel().setValue("sourcetype", (Object)SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj().getDynamicObject("sourcetype")));
        context.getView().getModel().setValue("amount", (Object)context.getBaseInfoObj().getBigDecimal("amount"));
        context.getView().getModel().setValue("sourceamount", (Object)context.getBaseInfoObj().getBigDecimal("sourceamount"));
        context.getView().getModel().setValue("isspecial", (Object)context.getProjectObj().getBoolean("isspecial"));
        context.getView().getModel().setValue("chassistype", (Object)SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj().getDynamicObject("chassistype")));
        int expertcount = PdsCommonUtils.object2Integer(PdsCommonUtils.getCustomParamValue(context.getView(), "expertcount"));
        if (expertcount > 0) {
            context.getView().getModel().setValue("expertcount", (Object)expertcount);
        }
    }

    public void initPurlist(SupplierContext context) {
        if (null == context.getPickSchemeObj() || "1".equals(context.getPickSchemeObj().getString("invitetype"))) {
            return;
        }
        String inviteType = context.getPickSchemeObj().getString("invitetype");
        String orderBy = "2".equals(inviteType) ? "package.packagename" : "purlistseq";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"package.id,purlist.id,package.packagename,purlist.materialnane,category.id", (QFilter[])context.getPurlistQFilter().toArray(), (String)orderBy);
        if (rows.size() == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)context.getView().getModel();
        model.beginInit();
        model.deleteEntryData("entryentity2");
        TableValueSetter ts = new TableValueSetter(new String[0]);
        if ("3".equals(inviteType)) {
            for (int i = 0; i < rows.size(); ++i) {
                DynamicObject row = (DynamicObject)rows.get(i);
                ts.set("purlistid", (Object)row.getLong("purlist.id"), i);
                ts.set("packageid", (Object)row.getLong("package.id"), i);
            }
        } else {
            HashSet<Long> packageIds = new HashSet<Long>(rows.size());
            for (int i = 0; i < rows.size(); ++i) {
                long packageId = ((DynamicObject)rows.get(i)).getLong("package.id");
                if (!packageIds.add(packageId)) continue;
                ts.set("packageid", (Object)packageId, i);
            }
        }
        model.batchCreateNewEntryRow("entryentity2", ts);
        model.endInit();
        context.getView().updateView("entryentity2");
    }
}

