/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.selecttool;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.selecttool.PdsSelectUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsPurlistUtils;

public class PdsInitModelByPurlist
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(ExtPluginContext context) {
        this.initCategoryAndOrg(context);
        context.getView().getModel().deleteEntryData("entryentity");
    }

    public void initCategoryAndOrg(ExtPluginContext context) {
        DynamicObject currentRow = PdsCommonUtils.getEntryEntitySelectRow(context.getView(), "entryentity2");
        if (null == currentRow) {
            return;
        }
        IDataModel model = context.getView().getModel();
        QFilter qfilter = PdsPurlistUtils.getOriginalPurlistQFilter(model.getDataEntity().getLong("project.id"));
        String inviteType = model.getDataEntity().getString("invitetype");
        if ("2".equals(inviteType)) {
            qfilter.and("package", "=", (Object)currentRow.getLong("packageid.id"));
        } else if ("3".equals(inviteType)) {
            qfilter.and("purlist", "=", (Object)currentRow.getLong("purlistid.id"));
        }
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"purlist.id,category.id,org.id", (QFilter[])qfilter.toArray());
        List<Object> purlistList = rows.stream().map(e -> e.getLong("purlist.id")).distinct().collect(Collectors.toList());
        model.setValue("purlist", (Object)purlistList.toArray(new Object[purlistList.size()]));
        List<Object> categoryList = rows.stream().map(e -> e.getLong("category.id")).distinct().collect(Collectors.toList());
        model.setValue("category", (Object)categoryList.toArray(new Object[categoryList.size()]));
        Set<Long> purOrgSet = PdsSelectUtils.getPurOrgSet(null, rows);
        model.setValue("purorg", (Object)purOrgSet.toArray(new Object[purOrgSet.size()]));
    }
}

