/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.selecttool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.selecttool.IPdsReturnData;
import kd.scm.pds.common.selecttool.SupplierContext;
import kd.scm.pds.common.suplinkman.PdsLinkManFacade;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsPurlistUtils;
import org.apache.commons.lang3.StringUtils;

public class PdsReturnDataByPickScheme
implements IPdsReturnData<SupplierContext> {
    private static final long serialVersionUID = 1L;

    @Override
    public void returnData(SupplierContext context) {
        String inviteType;
        if (null == context.getPickSchemeObj()) {
            return;
        }
        if (!this.verifyInviteData(context)) {
            return;
        }
        if (context.isAddSupplier()) {
            this.createAddSupplier(context);
            return;
        }
        this.deleteSupplier(context);
        ArrayList<DynamicObject> inviteSupList = new ArrayList<DynamicObject>();
        String manageType = context.getView().getModel().getDataEntity().getString("managetype");
        switch (inviteType = context.getView().getModel().getDataEntity().getString("invitetype")) {
            case "1": {
                this.createSupplierByProject(context, manageType, inviteSupList);
                break;
            }
            case "2": {
                this.createSupplierByPackage(context, manageType, inviteSupList);
                break;
            }
            case "3": {
                this.createSupplierByPurlist(context, manageType, inviteSupList);
            }
        }
    }

    public void createSupplierByProject(SupplierContext context, String manageType, List<DynamicObject> inviteSupList) {
        List<DynamicObject> supInfoList = this.getSupplierInfoList(context, null, "");
        Set<Long> supplierIds = supInfoList.stream().map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
        Map<Long, Map<String, String>> linkersMap = PdsLinkManFacade.getSupplierLinkMans(supplierIds);
        HashMap<Long, Set<Long>> sup_packageMap = new HashMap<Long, Set<Long>>();
        HashMap<Long, Set<Long>> sup_purlistMap = new HashMap<Long, Set<Long>>();
        Set packageIds = this.getPackageIds(context).stream().collect(Collectors.toSet());
        Set purlistIds = this.getPurlistIds(context).stream().collect(Collectors.toSet());
        for (DynamicObject supInfo : supInfoList) {
            long supplierId = supInfo.getLong("supplier.id");
            PdsCommonUtils.putMap_SetValue(sup_packageMap, Long.valueOf(supplierId), packageIds);
            PdsCommonUtils.putMap_SetValue(sup_purlistMap, Long.valueOf(supplierId), purlistIds);
        }
        switch (manageType) {
            case "1": {
                for (DynamicObject supInfo : supInfoList) {
                    this.createInviteSupplier(context, supInfo, 0L, inviteSupList, "", sup_packageMap, sup_purlistMap, linkersMap);
                }
                break;
            }
            case "2": {
                Iterator iterator = packageIds.iterator();
                while (iterator.hasNext()) {
                    long packageId = (Long)iterator.next();
                    for (DynamicObject supInfo : supInfoList) {
                        this.createInviteSupplier(context, supInfo, packageId, inviteSupList, "", sup_packageMap, sup_purlistMap, linkersMap);
                    }
                }
                break;
            }
            case "3": {
                this.createItemSupplier(context, supInfoList, inviteSupList, null, "");
            }
        }
        PdsCommonUtils.saveDynamicObjects(inviteSupList);
    }

    public void createSupplierByPackage(SupplierContext context, String manageType, List<DynamicObject> inviteSupList) {
        DynamicObjectCollection pkgRows = context.getView().getModel().getEntryEntity("entryentity2");
        List<Object> supInfoList = new ArrayList();
        HashMap<Long, Set<Long>> sup_packageMap = new HashMap<Long, Set<Long>>();
        HashMap<Long, Set<Long>> sup_purlistMap = new HashMap<Long, Set<Long>>();
        supInfoList = this.getAllSupplierInfoList(context, pkgRows, "sub", sup_packageMap, sup_purlistMap);
        Set<Long> supplierIds = supInfoList.stream().map(e -> e.getLong("subsupplier.id")).collect(Collectors.toSet());
        Map<Long, Map<String, String>> linkersMap = PdsLinkManFacade.getSupplierLinkMans(supplierIds);
        switch (manageType) {
            case "1": {
                for (DynamicObject dynamicObject : supInfoList) {
                    this.createInviteSupplier(context, dynamicObject, 0L, inviteSupList, "sub", sup_packageMap, sup_purlistMap, linkersMap);
                }
                break;
            }
            case "2": {
                for (DynamicObject dynamicObject : pkgRows) {
                    if (!dynamicObject.getBoolean("isselect")) continue;
                    supInfoList = this.getSupplierInfoList(context, dynamicObject.getDynamicObjectCollection("subentryentity"), "sub");
                    for (DynamicObject dynamicObject2 : supInfoList) {
                        this.createInviteSupplier(context, dynamicObject2, dynamicObject.getLong("packageid.id"), inviteSupList, "sub", sup_packageMap, sup_purlistMap, linkersMap);
                    }
                }
                break;
            }
            case "3": {
                this.createItemSupplier(context, supInfoList, inviteSupList, null, "sub");
            }
        }
        PdsCommonUtils.saveDynamicObjects(inviteSupList);
    }

    public void createSupplierByPurlist(SupplierContext context, String manageType, List<DynamicObject> inviteSupList) {
        List<Object> supInfoList = new ArrayList();
        HashMap<Long, Set<Long>> sup_packageMap = new HashMap<Long, Set<Long>>();
        HashMap<Long, Set<Long>> sup_purlistMap = new HashMap<Long, Set<Long>>();
        DynamicObjectCollection purRows = context.getView().getModel().getEntryEntity("entryentity2");
        supInfoList = this.getAllSupplierInfoList(context, purRows, "sub", sup_packageMap, sup_purlistMap);
        Set<Long> supplierIds = supInfoList.stream().map(e -> e.getLong("subsupplier.id")).collect(Collectors.toSet());
        Map<Long, Map<String, String>> linkersMap = PdsLinkManFacade.getSupplierLinkMans(supplierIds);
        switch (manageType) {
            case "1": {
                for (DynamicObject dynamicObject : supInfoList) {
                    this.createInviteSupplier(context, dynamicObject, 0L, inviteSupList, "sub", sup_packageMap, sup_purlistMap, linkersMap);
                }
                break;
            }
            case "2": {
                List<Long> packageIds = this.getPackageIds(context);
                for (long packageId : packageIds) {
                    for (DynamicObject dynamicObject : supInfoList) {
                        long supplierId = dynamicObject.getLong("subsupplier.id");
                        if (null == sup_packageMap.get(supplierId) || !((Set)sup_packageMap.get(supplierId)).contains(packageId)) continue;
                        this.createInviteSupplier(context, dynamicObject, packageId, inviteSupList, "sub", sup_packageMap, sup_purlistMap, linkersMap);
                    }
                }
                break;
            }
            case "3": {
                this.createItemSupplier(context, null, inviteSupList, purRows, "sub");
            }
        }
        PdsCommonUtils.saveDynamicObjects(inviteSupList);
    }

    public void createInviteSupplier(SupplierContext context, DynamicObject supInfo, long packageId, List<DynamicObject> inviteSupList, String prefix, Map<Long, Set<Long>> sup_packageMap, Map<Long, Set<Long>> sup_purlistMap, Map<Long, Map<String, String>> linkersMap) {
        Map<String, String> linkerMap;
        String compKey = PdsCommonUtils.object2String(PdsCommonUtils.getCustomParamValue(context.getView(), "compkey"), "src_supplier_invite");
        String entityName = "src_supplier_select".equals(compKey) ? "src_enrollsupplier" : "src_supplierinvite";
        DynamicObject supObj = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        long billid = "src_invitesupplier_chg".equals(compKey) ? PdsCommonUtils.object2Long(context.getParamMap().get("billid")) : context.getProjectId();
        List properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)supObj);
        PdsCommonUtils.copyDynamicObjectValue(supInfo, supObj, properties, new HashSet<String>(), -1, "", "");
        long supplierId = supInfo.getLong(prefix + "supplier" + '.' + "id");
        supObj.set("billid", (Object)billid);
        supObj.set("suppliertype", (Object)"bd_supplier");
        supObj.set("supplier", (Object)supplierId);
        supObj.set("supname", (Object)supInfo.getString(prefix + "supplier" + '.' + "name"));
        supObj.set("package", (Object)packageId);
        supObj.set("note", (Object)supInfo.getString(prefix + "note"));
        if (entityName.equals("src_supplierinvite")) {
            supObj.set("isinvite", (Object)supInfo.getBoolean(prefix + "isinvite"));
            if (null != sup_purlistMap && null != sup_purlistMap.get(supplierId)) {
                MultiBasedataUtils.setMultiBasedataForBillObj(supObj, sup_purlistMap.get(supplierId), "purlists");
                MultiBasedataUtils.setMultiBasedataForBillObj(supObj, sup_purlistMap.get(supplierId), "purlistscope");
                String puristNote = String.format(ResManager.loadKDString((String)"\u67e5\u770b(%1$s)", (String)"PdsReturnDataByPickScheme_1", (String)"scm-pds-common", (Object[])new Object[0]), sup_purlistMap.get(supplierId).size());
                supObj.set("purlistnote", (Object)puristNote);
            } else {
                supObj.set("purlists", null);
                supObj.set("purlistscope", null);
                supObj.set("purlistnote", null);
            }
        }
        if (null != (linkerMap = linkersMap.get(supplierId))) {
            supObj.set("linkman", (Object)linkerMap.get("linkman"));
            supObj.set("phone", (Object)linkerMap.get("phone"));
        }
        inviteSupList.add(supObj);
    }

    public void createItemSupplier(SupplierContext context, List<DynamicObject> supInfoList, List<DynamicObject> inviteSupList, DynamicObjectCollection purRows, String prefix) {
        DynamicObjectCollection rows;
        DynamicObject compObj = this.getItemSupplierCompObj(context);
        DynamicObjectCollection dynamicObjectCollection = rows = null == compObj ? null : compObj.getDynamicObjectCollection("entryentity");
        if (null == rows || rows.size() == 0) {
            return;
        }
        if (null != supInfoList) {
            for (DynamicObject row : rows) {
                Set<Long> baseDataIdSet = supInfoList.stream().map(e -> e.getLong(prefix + "supplier" + '.' + "id")).collect(Collectors.toSet());
                MultiBasedataUtils.setMultiBasedataForBillObj(row, baseDataIdSet, "supplier");
            }
        } else {
            for (DynamicObject purRow : purRows) {
                if (!purRow.getBoolean("isselect")) continue;
                supInfoList = this.getSupplierInfoList(context, purRow.getDynamicObjectCollection("subentryentity"), "sub");
                for (DynamicObject row : rows) {
                    if (purRow.getLong("purlistid.id") != row.getLong("purlist.id")) continue;
                    Set<Long> baseDataIdSet = supInfoList.stream().map(e -> e.getLong(prefix + "supplier" + '.' + "id")).collect(Collectors.toSet());
                    MultiBasedataUtils.setMultiBasedataForBillObj(row, baseDataIdSet, "supplier");
                }
            }
        }
        inviteSupList.add(compObj);
    }

    public void createAddSupplier(SupplierContext context) {
        String prefix = "1".equals(PdsCommonUtils.object2String(context.getParamMap().get("addsupplier"), "3")) ? "" : "sub";
        IDataModel model = context.getView().getParentView().getModel();
        DynamicObjectCollection purRows = context.getView().getModel().getEntryEntity("entryentity2");
        List<Object> supInfoList = new ArrayList();
        for (DynamicObject purRow : purRows) {
            if (!purRow.getBoolean("isselect") && StringUtils.isNotBlank((CharSequence)prefix)) continue;
            supInfoList = StringUtils.isNotBlank((CharSequence)prefix) ? this.getSupplierInfoList(context, purRow.getDynamicObjectCollection("subentryentity"), "sub") : this.getSupplierInfoList(context, null, "");
            long packageId1 = purRow.getLong("packageid.id");
            long purlistId1 = purRow.getLong("purlistid.id");
            for (int index = 0; index < model.getEntryRowCount("entryentity"); ++index) {
                DynamicObject row = model.getEntryRowEntity("entryentity", index);
                long purlistId2 = row.getLong("purlist.id");
                long packageId2 = row.getLong("package.id");
                long projectId2 = row.getLong("projectid.id");
                if (purlistId1 != purlistId2 && packageId1 != packageId2 && projectId2 != context.getProjectId()) continue;
                Set<Object> supplierIds = supInfoList.stream().map(e -> e.getLong(prefix + "supplier" + '.' + "id")).collect(Collectors.toSet());
                model.setValue("supplier", (Object)supplierIds.toArray(new Object[0]), index);
            }
        }
        context.getView().getParentView().updateView("entryentity");
        context.getView().sendFormAction(context.getView().getParentView());
    }

    public List<DynamicObject> getSupplierInfoList(SupplierContext context, DynamicObjectCollection rows, String prefix) {
        rows = null != rows ? rows : context.getToolObj().getDynamicObjectCollection("entryentity");
        String isuninvite = context.getToolObj().getString("isuninvite");
        List<Object> supInfoList = new ArrayList();
        supInfoList = "1".equals(isuninvite) ? rows.stream().filter(row -> row.getBoolean(prefix + "isinvite")).collect(Collectors.toList()) : rows.stream().collect(Collectors.toList());
        return supInfoList;
    }

    public List<DynamicObject> getAllSupplierInfoList(SupplierContext context, DynamicObjectCollection rows, String prefix, Map<Long, Set<Long>> sup_packageMap, Map<Long, Set<Long>> sup_purlistMap) {
        ArrayList<DynamicObject> allSupList = new ArrayList<DynamicObject>();
        HashSet<Long> allSupIds = new HashSet<Long>();
        for (DynamicObject row : rows) {
            if (!row.getBoolean("isselect")) continue;
            long packageId = row.getLong("packageid.id");
            long purlistId = row.getLong("purlistid.id");
            List<DynamicObject> subSupList = this.getSupplierInfoList(context, row.getDynamicObjectCollection("subentryentity"), "sub");
            for (DynamicObject subSup : subSupList) {
                long supplierId = subSup.getLong(prefix + "supplier" + '.' + "id");
                if (allSupIds.add(supplierId)) {
                    allSupList.add(subSup);
                }
                if (packageId > 0L) {
                    PdsCommonUtils.putMap_SetValue(sup_packageMap, Long.valueOf(supplierId), packageId);
                }
                if (purlistId <= 0L) continue;
                PdsCommonUtils.putMap_SetValue(sup_purlistMap, Long.valueOf(supplierId), purlistId);
            }
        }
        return allSupList;
    }

    public List<Long> getPackageIds(SupplierContext context) {
        QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId());
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_packagef7", (String)"id", (QFilter[])qfilter.toArray(), (String)"packagename");
        return rows.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
    }

    public List<Long> getPurlistIds(SupplierContext context) {
        QFilter qfilter = PdsPurlistUtils.getOriginalPurlistQFilter(context.getProjectId());
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"purlist.id", (QFilter[])qfilter.toArray(), (String)"purlistseq");
        return rows.stream().map(e -> e.getLong("purlist.id")).collect(Collectors.toList());
    }

    public DynamicObject getItemSupplierCompObj(SupplierContext context) {
        long billId = PdsCommonUtils.object2Long(PdsCommonUtils.getCustomParamValue(context.getView(), "billid"));
        String compKey = PdsCommonUtils.object2String(PdsCommonUtils.getCustomParamValue(context.getView(), "compkey"), "");
        if (billId > 0L && StringUtils.isNotEmpty((CharSequence)compKey) && QueryServiceHelper.exists((String)compKey, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)})) {
            return BusinessDataServiceHelper.loadSingle((Object)billId, (String)compKey);
        }
        return null;
    }

    public boolean verifyInviteData(SupplierContext context) {
        String inviteType = context.getView().getModel().getDataEntity().getString("invitetype");
        if (!"2".equals(inviteType) && !"3".equals(inviteType)) {
            return true;
        }
        if (!"3".equals(context.getView().getModel().getDataEntity().getString("isuninvite"))) {
            return true;
        }
        DynamicObjectCollection rows = context.getView().getModel().getEntryEntity("entryentity2");
        List<DynamicObject> supRows = this.getAllSupplierInfoList(context, rows, "sub", new HashMap<Long, Set<Long>>(), new HashMap<Long, Set<Long>>());
        if (supRows.stream().anyMatch(e -> !e.getBoolean("subisinvite") && StringUtils.isBlank((CharSequence)e.getString("subnote")))) {
            context.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u5907\u6ce8\u680f\u586b\u5199\u4e0d\u9080\u8bf7\u4f9b\u5e94\u5546\u7684\u539f\u56e0\u3002", (String)"PdsReturnDataByPickScheme_0", (String)"scm-pds-common", (Object[])new Object[0]));
            context.setSucced(false);
            return false;
        }
        return true;
    }

    public void deleteSupplier(SupplierContext context) {
        String compKey;
        String entityName = null;
        QFilter qfilter = null;
        switch (compKey = PdsCommonUtils.object2String(PdsCommonUtils.getCustomParamValue(context.getView(), "compkey"), "src_supplier_invite")) {
            case "src_supplier_select": {
                entityName = "src_enrollsupplier";
                qfilter = new QFilter("billid", "=", (Object)context.getProjectId());
                break;
            }
            case "src_supplier_invite": {
                entityName = "src_supplierinvite";
                qfilter = new QFilter("billid", "=", (Object)context.getProjectId());
                break;
            }
            case "src_invitesupplier_chg": {
                entityName = "src_supplierinvite";
                qfilter = new QFilter("billid", "=", (Object)PdsCommonUtils.object2Long(context.getParamMap().get("billid")));
                break;
            }
            default: {
                return;
            }
        }
        DeleteServiceHelper.delete((String)entityName, (QFilter[])qfilter.toArray());
    }
}

