/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.selecttool;

import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.selecttool.PdsConfirmByByPurlist;
import kd.scm.pds.common.selecttool.PdsInitModelByPurlist;
import kd.scm.pds.common.selecttool.PdsSelectUtils;
import kd.scm.pds.common.selecttool.PdsSupplierRecordLog;
import kd.scm.pds.common.selecttool.SupplierContext;
import kd.scm.pds.common.suplinkman.PdsLinkManFacade;
import kd.scm.pds.common.supplierfilter.SupplierFilterUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.RandomUtils;
import org.apache.commons.lang3.StringUtils;

public class PdsSelectHelper
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        PdsSelectUtils.setQueryConditionVisible(this.getView(), Boolean.FALSE);
        SupplierContext context = this.getSupplierContext();
        PdsSelectUtils.initModel(context);
        PdsSelectUtils.initContext(context);
        String inviteType = this.getModel().getDataEntity().getString("invitetype");
        if (this.getModel().getDataEntity().getBoolean("isautorefresh") || SupplierFilterUtils.isAutoQueryAndShow(context)) {
            if ("0".equals(inviteType) || "1".equals(inviteType)) {
                this.queryAndShowSupplier(context, true);
            } else {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity2");
                int count = this.getModel().getEntryRowCount("entryentity2");
                for (int i = 0; i < count; ++i) {
                    int count2 = (Integer)this.getModel().getValue("count2", i);
                    this.getModel().setValue("turns", (Object)count2);
                    entryGrid.selectRows(i, true);
                    this.selectByPackageOrPurlist();
                    this.confirmByPackageOrPurlist();
                    this.getModel().setValue("count2", (Object)(count2 + 1), i);
                }
            }
        } else {
            this.queryAndShowSupplier(context, false);
        }
        if ("0".equals(inviteType) || "1".equals(inviteType)) {
            SplitContainer splitc = (SplitContainer)this.getControl("splitcontainerap");
            splitc.changeFlexStatus(SplitDirection.left, true);
            splitc.setSubContainerMinWidth(0);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        String opKey = ((AbstractOperate)evt.getSource()).getOperateKey();
        SupplierContext context = null;
        QFilter qfilters = null;
        String entityName = null;
        switch (opKey) {
            case "confirm": {
                context = this.getSupplierContext();
                PdsSelectUtils.returnData(context);
                evt.setCancel(!context.isSucced());
                break;
            }
            case "refresh": {
                PdsSelectUtils.setQueryConditionVisible(this.getView(), Boolean.FALSE);
                context = this.getSupplierContext();
                PdsSelectUtils.initContext(context);
                this.queryAndShowSupplier(context, true);
                break;
            }
            case "select": {
                int rowIndex = PdsCommonUtils.getEntryEntitySelectIndex(this.getView(), "entryentity2");
                int count2 = (Integer)this.getModel().getValue("count2", rowIndex);
                this.getModel().setValue("turns", (Object)count2);
                this.selectByPackageOrPurlist();
                this.confirmByPackageOrPurlist();
                this.getModel().setValue("count2", (Object)(count2 + 1), rowIndex);
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity2");
                entryGrid.selectRows(rowIndex, true);
                break;
            }
            case "supplier": {
                entityName = "bd_supplier";
                qfilters = QFilter.fromSerializedString((String)this.getView().getPageCache().get(entityName));
                OpenFormUtils.openListPage(this.getView(), entityName, ShowType.MainNewTabPage, null, qfilters, null);
                break;
            }
            case "register": {
                entityName = "srm_supplier";
                qfilters = QFilter.fromSerializedString((String)this.getView().getPageCache().get(entityName));
                OpenFormUtils.openListPage(this.getView(), entityName, ShowType.MainNewTabPage, null, qfilters, null);
                break;
            }
            case "category": {
                entityName = "srm_supcategory";
                qfilters = QFilter.fromSerializedString((String)this.getView().getPageCache().get(entityName));
                OpenFormUtils.openListPage(this.getView(), entityName, ShowType.MainNewTabPage, null, qfilters, null);
                break;
            }
            case "scorerpt": {
                entityName = "srm_scorerpt";
                qfilters = QFilter.fromSerializedString((String)this.getView().getPageCache().get(entityName));
                OpenFormUtils.openListPage(this.getView(), entityName, ShowType.MainNewTabPage, null, qfilters, null);
                break;
            }
            case "logquery": {
                qfilters = new QFilter("project", "=", (Object)this.getModel().getDataEntity().getLong("project.id"));
                OpenFormUtils.openListPage(this.getView(), "pds_supselectlog", ShowType.MainNewTabPage, null, qfilters, null);
                break;
            }
            case "exit": {
                this.exit();
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        ExtPluginContext context = new ExtPluginContext();
        context.setView(this.getView());
        ExtPluginFactory.executeExtplugin(PdsSupplierRecordLog.class.getSimpleName(), context, true);
    }

    private void getSupplierIds(SupplierContext context) {
        String idField;
        SupplierFilterUtils.getSupplierQFilter(this.getView(), context);
        if (context.getFormalSupplierIds().size() > 0) {
            return;
        }
        boolean isByMasterId = context.getToolObj().getBoolean("isbymasterid");
        String string = idField = isByMasterId ? "masterid" : "id";
        if (!context.isEmpty() && context.getUltimateQFilter() != null) {
            DynamicObjectCollection rows;
            Set<Long> supplierIds;
            if (this.isAdd()) {
                context.getUltimateQFilter().and(idField, "not in", this.getPreSupplierIds());
            }
            if (null != (supplierIds = (rows = QueryServiceHelper.query((String)context.getMainDataType(), (String)idField, (QFilter[])context.getUltimateQFilter().toArray())).stream().filter(e -> e.getLong(idField) > 0L).map(e -> e.getLong(idField)).collect(Collectors.toSet())) && supplierIds.size() > 0) {
                supplierIds = RandomUtils.getRandomElement(supplierIds, context.getRandomCount());
                context.setFormalSupplierIds(supplierIds);
            }
        }
    }

    private void queryAndShowSupplier(SupplierContext context, boolean isShowSupplier) {
        this.getSupplierIds(context);
        if (isShowSupplier) {
            this.showSupplier(context);
            this.showCondition(context);
        }
    }

    private void showSupplier(SupplierContext context) {
        Set<Long> supplierIds = context.getFormalSupplierIds();
        if (supplierIds.size() > 0) {
            this.addTurns(supplierIds.size());
        } else if (this.isAdd()) {
            return;
        }
        String selectFields = null;
        if (context.getBaseDataType().equals(context.getMainDataType())) {
            selectFields = DynamicObjectUtil.getSelectfields((String)context.getBaseDataType(), (boolean)false);
        } else {
            StringBuilder selectFieldsBuilder = new StringBuilder();
            selectFieldsBuilder.append("id").append(",");
            selectFieldsBuilder.append("entry_linkman").append(",");
            selectFieldsBuilder.append("contactperson").append(",");
            selectFieldsBuilder.append("email").append(",");
            selectFieldsBuilder.append("address").append(",");
            selectFieldsBuilder.append("contactpersonpost").append(",");
            selectFieldsBuilder.append("phone").append(",");
            selectFieldsBuilder.append("isdefault_linkman").append(",");
            selectFieldsBuilder.append("linkman").append(",");
            selectFieldsBuilder.append("mobile").append(",");
            selectFieldsBuilder.append("postal_code").append(",");
            selectFieldsBuilder.append("bizpartner_address").append(",");
            selectFieldsBuilder.append("bizpartner_phone");
            selectFields = selectFieldsBuilder.toString();
        }
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)context.getMainDataType(), (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIds)});
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        if (!this.isAdd()) {
            model.deleteEntryData("entryentity");
        }
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int i = 0;
        Map<Long, Map<String, String>> linkersMap = PdsLinkManFacade.getSupplierLinkMans(supplierIds);
        for (DynamicObject obj : objs) {
            long supplierId = obj.getLong("id");
            ts.set("isinvite", (Object)Boolean.TRUE, i);
            ts.set("supplier", (Object)obj.getLong("id"), i);
            if (context.getBaseDataType().equals(context.getMainDataType())) {
                ts.set("maindata", (Object)obj.getLong("id"), i);
            } else {
                Map<String, String> linkerMap = linkersMap.get(supplierId);
                if (null != linkerMap) {
                    ts.set("phone", (Object)linkerMap.get("phone"), i);
                    ts.set("linkman", (Object)linkerMap.get("linkman"), i);
                }
            }
            ts.set("entryentityturns", (Object)this.getTurns(), i);
            ++i;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    private SupplierContext getSupplierContext() {
        SupplierContext context = PdsSelectUtils.getContextInstance();
        context.setView(this.getView());
        context.setProjectId(this.getModel().getDataEntity().getLong("project.id"));
        long pickSchemeId = this.getModel().getDataEntity().getLong("pickscheme.id");
        if (pickSchemeId > 0L) {
            DynamicObject pickSchemeObj = BusinessDataServiceHelper.loadSingle((Object)pickSchemeId, (String)"src_supplierpick");
            context.setPickSchemeObj(pickSchemeObj);
        }
        if ("2".equals(this.getModel().getDataEntity().getString("isallsupplier"))) {
            context.setAllSupplier(true);
        }
        Map<String, Object> paramMap = PdsCommonUtils.getCustomParamMap(this.getView());
        context.setParamMap(paramMap);
        context.setBillId(PdsCommonUtils.object2Long(paramMap.get("billid")));
        context.setCompkey(PdsCommonUtils.object2String(paramMap.get("compkey"), ""));
        if ("src_addsupplier".equals(context.getCompkey())) {
            context.setAddSupplier(true);
        }
        context.setToolObj(this.getModel().getDataEntity(true));
        PdsSelectUtils.initExtData(context);
        return context;
    }

    private boolean isAdd() {
        return this.getModel().getDataEntity().getBoolean("isadd");
    }

    private Set<Long> getPreSupplierIds() {
        DynamicObjectCollection rows = this.getView().getModel().getEntryEntity("entryentity");
        return rows.stream().map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
    }

    private int getTurns() {
        return this.getModel().getDataEntity().getInt("turns");
    }

    private void addTurns(int number) {
        this.getModel().setValue("turns", (Object)(this.getTurns() + 1));
        this.getModel().setValue("number", (Object)number);
    }

    private int getNumber() {
        return this.getModel().getDataEntity().getInt("number");
    }

    private void showCondition(SupplierContext context) {
        if (null == context.getFormalSupplierIds() || context.getFormalSupplierIds().size() == 0) {
            return;
        }
        StringBuilder qfilterSb = new StringBuilder();
        StringBuilder descriptionSb = new StringBuilder();
        StringBuilder prefixSb = new StringBuilder();
        prefixSb.append(String.format(ResManager.loadKDString((String)"\u62bd\u53d6\u8f6e\u6b21(%1$s)\uff0c\u62bd\u53d6\u6570(%2$s)\uff1a", (String)"PdsSelectHelper_3", (String)"scm-pds-common", (Object[])new Object[0]), this.getTurns(), this.getNumber()));
        if (this.isAdd() && PdsCommonUtils.object2String(this.getModel().getValue("condition"), "").length() > 0) {
            qfilterSb.append(this.getModel().getValue("condition")).append("\n");
            descriptionSb.append(this.getModel().getValue("description")).append("\n");
        }
        qfilterSb.append((CharSequence)prefixSb).append((CharSequence)context.getAllQFilter());
        descriptionSb.append((CharSequence)prefixSb).append((CharSequence)context.getAllDescription());
        this.getModel().setValue("qfilter", (Object)context.getUltimateQFilter());
        this.getModel().setValue("condition", (Object)qfilterSb);
        this.getModel().setValue("description", (Object)descriptionSb);
    }

    public void exit() {
        if (this.getModel().getDataEntity().getInt("turns") == 0) {
            this.getView().invokeOperation("close");
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u5df2\u62bd\u53d6\u4e86\u4e00\u4e9b\u4f9b\u5e94\u5546\uff0c\u82e5\u76f4\u63a5\u9000\u51fa\uff0c\u5c06\u53d6\u6d88\u8fd9\u4e9b\u62bd\u53d6\u7684\u6570\u636e\uff0c\u662f\u5426\u76f4\u63a5\u9000\u51fa\uff1f", (String)"PdsSelectHelper_2", (String)"scm-pds-common", (Object[])new Object[0]), MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener("exit"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (StringUtils.equals((CharSequence)"exit", (CharSequence)evt.getCallBackId()) && evt.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getView().invokeOperation("close");
        }
    }

    public void selectByPackageOrPurlist() {
        this.initModel();
        SupplierContext context = this.getSupplierContext();
        PdsSelectUtils.initContext(context);
        this.queryAndShowSupplier(context, true);
    }

    public void initModel() {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(this.getView());
        ExtPluginFactory.executeExtplugin(PdsInitModelByPurlist.class.getSimpleName(), context, true, PdsInitModelByPurlist.class.getName());
    }

    public void confirmByPackageOrPurlist() {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(this.getView());
        ExtPluginFactory.executeExtplugin(PdsConfirmByByPurlist.class.getSimpleName(), context, true, PdsConfirmByByPurlist.class.getName());
    }
}

