/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.suplinkman;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.pds.common.suplinkman.IPdsLinkManHandler;
import kd.scm.pds.common.suplinkman.PdsLinkManContext;
import kd.scm.pds.common.suplinkman.PdsLinkManFacade;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;

public class PdsGetLinkManByBizPartnerUser
implements IPdsLinkManHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsLinkManContext context) {
        this.getSupplierLinkMans(context);
    }

    protected void getSupplierLinkMans(PdsLinkManContext context) {
        Set<Long> supplierIds = context.getSupplierIds();
        ArrayList bizPartnerIds = new ArrayList(16);
        HashMap bizMap = new HashMap(16);
        supplierIds.forEach(supplierId -> {
            long bizPartnerId = PdsCommonUtils.object2Long(BizPartnerUtil.getBizPartnerBySupplier((Object)supplierId));
            bizPartnerIds.add(bizPartnerId);
            bizMap.put(bizPartnerId, supplierId);
        });
        QFilter qFilter = new QFilter("bizpartner", "in", bizPartnerIds);
        qFilter.and(new QFilter("usertype", "=", (Object)"3"));
        qFilter.and(new QFilter("bizpartnertype", "=", (Object)"2"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("user", ">", (Object)0));
        String selectProperties = "user,bizpartner,modifytime,isadmin";
        DynamicObject[] supplierObjs = BusinessDataServiceHelper.load((String)"bos_bizpartneruser", (String)selectProperties, (QFilter[])qFilter.toArray());
        if (supplierObjs.length == 0) {
            return;
        }
        Map<Long, List<DynamicObject>> bizPartnerMap = Arrays.stream(supplierObjs).collect(Collectors.groupingBy(obj -> obj.getLong("bizpartner.id")));
        for (Map.Entry<Long, List<DynamicObject>> bizPartner : bizPartnerMap.entrySet()) {
            DynamicObject bizObj = SupplierUtil.getQualifiedSupplierUser(bizPartner.getValue());
            if (!Objects.nonNull(bizObj)) continue;
            HashMap<String, String> linkManMap = PdsLinkManFacade.createLinkManMap();
            this.setLinkManValue(linkManMap, bizObj);
            context.getLinkmanMap().put((Long)bizMap.get(bizPartner.getKey()), (Map<String, String>)linkManMap);
            break;
        }
    }

    private void setLinkManValue(Map<String, String> linkManMap, DynamicObject row) {
        DynamicObject user = row.getDynamicObject("user");
        if (Objects.nonNull(user)) {
            linkManMap.put("linkman", user.getString("name"));
            linkManMap.put("phone", user.getString("phone"));
            linkManMap.put("email", user.getString("email"));
        }
    }
}

