/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.suplinkman;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.suplinkman.IPdsLinkManHandler;
import kd.scm.pds.common.suplinkman.PdsLinkManContext;
import kd.scm.pds.common.suplinkman.PdsLinkManFacade;
import kd.scm.pds.common.util.SupplierUtil;
import org.apache.commons.lang3.StringUtils;

public class PdsGetLinkManByLinkmanEntry
implements IPdsLinkManHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsLinkManContext context) {
        this.getSupplierLinkMans(context);
    }

    protected void getSupplierLinkMans(PdsLinkManContext context) {
        PdsLinkManFacade.getSupplierObjs(context);
        DynamicObject[] supplierObjs = context.getSupplierObjs();
        if (null == supplierObjs || supplierObjs.length == 0) {
            return;
        }
        if (!SupplierUtil.isSupplierBaseData(supplierObjs[0])) {
            return;
        }
        for (DynamicObject supplierObj : supplierObjs) {
            DynamicObjectCollection rows = supplierObj.getDynamicObjectCollection("entry_linkman");
            if (rows.size() == 0) continue;
            HashMap<String, String> linkManMap = PdsLinkManFacade.createLinkManMap();
            Boolean isdefault = false;
            for (DynamicObject row : rows) {
                if (!row.getBoolean("isdefault_linkman") || StringUtils.isBlank((CharSequence)row.getString("contactperson"))) continue;
                this.setLinkManValue(linkManMap, row);
                context.getLinkmanMap().put(SrmCommonUtil.getPkValue((DynamicObject)supplierObj), linkManMap);
                isdefault = true;
                break;
            }
            if (isdefault.booleanValue() || rows.size() <= 0 || StringUtils.isBlank((CharSequence)((DynamicObject)rows.get(0)).getString("contactperson"))) continue;
            this.setLinkManValue(linkManMap, (DynamicObject)rows.get(0));
            context.getLinkmanMap().put(SrmCommonUtil.getPkValue((DynamicObject)supplierObj), linkManMap);
        }
    }

    private void setLinkManValue(Map<String, String> linkManMap, DynamicObject row) {
        linkManMap.put("linkman", row.getString("contactperson"));
        linkManMap.put("phone", row.getString("phone"));
        linkManMap.put("duty", row.getString("contactpersonpost"));
        linkManMap.put("email", row.getString("email"));
        linkManMap.put("address", row.getString("address"));
    }
}

