/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.suplinkman;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.suplinkman.IPdsLinkManHandler;
import kd.scm.pds.common.suplinkman.IPdsRegLinkManHandler;
import kd.scm.pds.common.suplinkman.PdsLinkManContext;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;

public class PdsLinkManFacade {
    public static HashMap<String, String> getSupplierLinkMan(Object supplierId) {
        return (HashMap)PdsLinkManFacade.getLinkManBySupplier(PdsCommonUtils.object2Long(supplierId), null, "bd_supplier");
    }

    public static HashMap<String, String> getSupplierLinkMan(DynamicObject supplierObj) {
        return (HashMap)PdsLinkManFacade.getLinkManBySupplier(0L, supplierObj, "bd_supplier");
    }

    public static Map<Long, Map<String, String>> getSupplierLinkMans(Set<Long> supplierIds) {
        return PdsLinkManFacade.getLinkManBySuppliers(supplierIds, null, "bd_supplier");
    }

    public static Map<Long, Map<String, String>> getSupplierLinkMans(DynamicObject[] supplierObjs) {
        return PdsLinkManFacade.getLinkManBySuppliers(null, supplierObjs, "bd_supplier");
    }

    public static HashMap<String, String> getRegSupplierLinkMan(Object supplierId) {
        return (HashMap)PdsLinkManFacade.getLinkManBySupplier(PdsCommonUtils.object2Long(supplierId), null, "srm_supplier");
    }

    public static HashMap<String, String> getRegSupplierLinkMan(DynamicObject supplierObj) {
        return (HashMap)PdsLinkManFacade.getLinkManBySupplier(0L, supplierObj, "srm_supplier");
    }

    public static Map<Long, Map<String, String>> getRegSupplierLinkMans(Set<Long> supplierIds) {
        return PdsLinkManFacade.getLinkManBySuppliers(supplierIds, null, "srm_supplier");
    }

    public static Map<Long, Map<String, String>> getRegSupplierLinkMans(DynamicObject[] supplierObjs) {
        return PdsLinkManFacade.getLinkManBySuppliers(null, supplierObjs, "srm_supplier");
    }

    private static Map<String, String> getLinkManBySupplier(long supplierId, DynamicObject supplierObj, String supplierEntityId) {
        PdsLinkManContext context = PdsLinkManFacade.createContextBySupplier(supplierId, supplierObj);
        context.setSupplierEntityId(supplierEntityId);
        Map<Object, Object> linkMansMap = new HashMap();
        linkMansMap = PdsLinkManFacade.getSupplierLinkMans(context);
        HashMap<String, String> linkManMap = (HashMap<String, String>)linkMansMap.get(supplierId > 0L ? supplierId : SrmCommonUtil.getPkValue((DynamicObject)supplierObj));
        if (null == linkManMap) {
            linkManMap = PdsLinkManFacade.createLinkManMap();
        }
        return linkManMap;
    }

    private static PdsLinkManContext createContextBySupplier(long supplierId, DynamicObject supplierObj) {
        PdsLinkManContext context = new PdsLinkManContext();
        if (supplierId == 0L && null != supplierObj) {
            supplierId = SrmCommonUtil.getPkValue((DynamicObject)supplierObj);
        }
        HashSet<Long> supplierIds = new HashSet<Long>(1);
        supplierIds.add(supplierId);
        context.setSupplierIds(supplierIds);
        if (null != supplierObj) {
            DynamicObject[] supplierObjs = new DynamicObject[]{supplierObj};
            context.setSupplierObjs(supplierObjs);
        }
        return context;
    }

    private static Map<Long, Map<String, String>> getLinkManBySuppliers(Set<Long> supplierIds, DynamicObject[] supplierObjs, String supplierEntityId) {
        PdsLinkManContext context = PdsLinkManFacade.createContextBySuppliers(supplierIds, supplierObjs);
        context.setSupplierEntityId(supplierEntityId);
        return PdsLinkManFacade.getSupplierLinkMans(context);
    }

    private static PdsLinkManContext createContextBySuppliers(Set<Long> supplierIds, DynamicObject[] supplierObjs) {
        PdsLinkManContext context = new PdsLinkManContext();
        if ((null == supplierIds || supplierIds.size() == 0) && null != supplierObjs && supplierObjs.length > 0) {
            supplierIds = Arrays.asList(supplierObjs).stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        }
        context.setSupplierIds(supplierIds);
        if (null != supplierObjs && supplierObjs.length > 0) {
            context.setSupplierObjs(supplierObjs);
        }
        return context;
    }

    public static Map<Long, Map<String, String>> getSupplierLinkMans(PdsLinkManContext context) {
        List handlers = null;
        if (context.getSupplierEntityId().equals("bd_supplier")) {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(IPdsLinkManHandler.class.getSimpleName(), null);
        } else if (context.getSupplierEntityId().equals("srm_supplier")) {
            handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(IPdsRegLinkManHandler.class.getSimpleName(), null);
        } else {
            return Collections.emptyMap();
        }
        for (IPdsLinkManHandler handler : handlers) {
            handler.process(context);
            if (context.getLinkmanMap().size() <= 0) continue;
            return context.getLinkmanMap();
        }
        return context.getLinkmanMap();
    }

    public static HashMap<String, String> createLinkManMap() {
        HashMap<String, String> linkManMap = new HashMap<String, String>(8);
        linkManMap.put("linkman", "");
        linkManMap.put("phone", "");
        linkManMap.put("duty", "");
        linkManMap.put("email", "");
        linkManMap.put("address", "");
        return linkManMap;
    }

    public static void getSupplierObjs(PdsLinkManContext context) {
        if (null != context.getSupplierObjs() && context.getSupplierObjs().length > 0) {
            return;
        }
        QFilter qfilter = new QFilter("id", "in", context.getSupplierIds());
        DynamicObject[] supplierObjs = PdsCommonUtils.loadBillObjsByQFilter(context.getSupplierEntityId(), qfilter);
        if (null != supplierObjs && supplierObjs.length > 0) {
            context.setSupplierObjs(supplierObjs);
        }
    }

    public static Map<String, String> getLinkManBySupplierUser(DynamicObjectCollection rows) {
        HashMap<String, String> linkManMap = new HashMap<String, String>(2);
        if (null == rows || rows.size() == 0) {
            return linkManMap;
        }
        List<DynamicObject> userList = MultiBasedataUtils.getMultiBasedataObjs(rows);
        DynamicObject userObj = SupplierUtil.getQualifiedSupplierUser(userList);
        if (Objects.nonNull(userObj)) {
            long userId = userObj.getLong("user.id");
            DynamicObject obj = QueryServiceHelper.queryOne((String)"bos_user", (String)"id,name,phone", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)userId)});
            linkManMap.put("linkman", obj.getString("name"));
            linkManMap.put("phone", obj.getString("phone"));
        }
        return linkManMap;
    }
}

