/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.supplierfilter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.common.util.ParamUtil;
import kd.scm.pds.common.expertfilter.schemefilter.ExpertSchemeContext;
import kd.scm.pds.common.extfilter.ExtFilterFactory;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.extfilter.FilterGridUtils;
import kd.scm.pds.common.extfilter.PdsQFilterHelper;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.selecttool.PdsSelectUtils;
import kd.scm.pds.common.selecttool.SupplierContext;
import kd.scm.pds.common.supplierfilter.ISupplierFilter;
import kd.scm.pds.common.supplierscheme.SupplierSchemeUtils;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.RandomUtils;
import kd.scm.pds.common.util.SupplierUtil;

public class SupplierFilterUtils {
    public static void getSupplierQFilter(IFormView view, SupplierContext context) {
        int restCount;
        Map<String, List<DynamicObject>> basedataMap = null;
        List<Object> schemeObjs = new ArrayList(4);
        HashMap<Long, Integer> schemeCountMap = new HashMap<Long, Integer>(4);
        if (null != context.getPickSchemeObj()) {
            DynamicObjectCollection rows = context.getPickSchemeObj().getDynamicObjectCollection("entryentity");
            if (rows.size() == 0) {
                return;
            }
            schemeObjs = rows.stream().map(e -> e.getDynamicObject("scheme")).collect(Collectors.toList());
            if (context.getPickSchemeObj().getBigDecimal("sumvalue").compareTo(BigDecimal.ZERO) > 0) {
                restCount = context.getRandomCount();
                long firstSchemeId = ((DynamicObject)rows.get(0)).getLong("scheme.id");
                for (DynamicObject row : rows) {
                    if (restCount <= 0) continue;
                    int schemeCount = PdsCommonUtils.object2Integer(new BigDecimal(context.getRandomCount()).multiply(row.getBigDecimal("percent")).divide(new BigDecimal(100), 0, RoundingMode.HALF_UP));
                    schemeCountMap.put(row.getLong("scheme.id"), schemeCount);
                    restCount -= schemeCount;
                }
                if (restCount != 0) {
                    schemeCountMap.put(firstSchemeId, (Integer)schemeCountMap.get(firstSchemeId) + restCount);
                }
            } else {
                for (DynamicObject row : rows) {
                    schemeCountMap.put(row.getLong("scheme.id"), context.getRandomCount());
                }
            }
        } else {
            QFilter schemeQfilter = SupplierSchemeUtils.getSchemeFilter(view);
            if (null == schemeQfilter) {
                return;
            }
            String orderBy = "basedata.number,matchfield desc,number";
            DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_supplierscheme", (String)"id,number,matchfield,basedata.number,basedata.name,fieldid,maindata.number", (QFilter[])schemeQfilter.toArray(), (String)orderBy);
            if (null == rows || rows.size() == 0) {
                return;
            }
            basedataMap = rows.stream().collect(Collectors.groupingBy(e -> e.getString("basedata.number")));
            for (Map.Entry<String, List<DynamicObject>> entry : basedataMap.entrySet()) {
                schemeObjs.add(entry.getValue().get(0));
            }
        }
        context.setView(view);
        context.setEmpty(false);
        SupplierFilterUtils.getFilterParameter(context);
        HashSet<Long> basedataIds = new HashSet<Long>(schemeObjs.size());
        restCount = 0;
        for (DynamicObject dynamicObject : schemeObjs) {
            basedataIds.add(dynamicObject.getLong("id"));
            SupplierFilterUtils.setQueryConditionVisible(context, dynamicObject);
            SupplierFilterUtils.getSupplierQFilterByScheme(context, dynamicObject);
            if (context.isEmpty() || null == context.getUltimateQFilter()) continue;
            if (context.isAllSupplier()) {
                int schemeCount;
                boolean isByMasterId = context.getToolObj().getBoolean("isbymasterid");
                String idField = isByMasterId ? "masterid" : "id";
                QFilter qfilter = new QFilter(idField, "not in", context.getFormalSupplierIds()).and(context.getUltimateQFilter());
                DynamicObjectCollection rows = QueryServiceHelper.query((String)context.getMainDataType(), (String)idField, (QFilter[])qfilter.toArray());
                Set supplierIds = rows.stream().filter(e -> e.getLong(idField) > 0L).map(e -> e.getLong(idField)).collect(Collectors.toSet());
                if (null == supplierIds || supplierIds.size() <= 0 || (schemeCount = restCount + (Integer)schemeCountMap.get(dynamicObject.getLong("id"))) == 0) continue;
                if (supplierIds.size() > schemeCount) {
                    restCount = 0;
                    supplierIds = RandomUtils.getRandomElement(supplierIds, schemeCount);
                } else {
                    restCount = supplierIds.size() == schemeCount ? 0 : schemeCount - supplierIds.size();
                }
                context.getFormalSupplierIds().addAll(supplierIds);
                if (context.getFormalSupplierIds().size() < context.getRandomCount()) continue;
                break;
            }
            if (QueryServiceHelper.exists((String)context.getMainDataType(), (QFilter[])context.getUltimateQFilter().toArray())) continue;
            break;
        }
        MultiBasedataUtils.setMultiBasedataForModel(view.getModel(), basedataIds, "scheme");
    }

    private static void getSupplierQFilterByScheme(SupplierContext context, DynamicObject schemeObj) {
        long schemeId = schemeObj.getLong("id");
        schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"src_supplierscheme");
        Map<String, Object> qfilterMap = FilterGridUtils.getQFilter("src_supplierscheme", schemeId);
        context.setQfilter((QFilter)qfilterMap.get("qfilter"));
        context.setDescription(new StringBuilder(PdsCommonUtils.object2String(qfilterMap.get("description"), "")));
        ExtFilterUtils.getFieldMatchQFilter(context, schemeObj, context.getView().getModel().getDataEntity());
        List extFilters = ExtFilterFactory.getInstance().getExtFilterInstance("src_supplierscheme", schemeId);
        if (null != extFilters && extFilters.size() > 0) {
            for (ISupplierFilter extFilter : extFilters) {
                extFilter.buildQFilter(context);
            }
        }
        SupplierFilterUtils.buildSupplierQFilter(context, schemeObj);
        PdsQFilterHelper.buildQFilterDescription(context);
    }

    private static void buildSupplierQFilter(SupplierContext context, DynamicObject schemeObj) {
        String supplierField;
        if (null != context.getView() && null != context.getBaseDataType() && null != context.getQfilter()) {
            context.getView().getPageCache().put(context.getBaseDataType(), context.getQfilter().toSerializedString());
        }
        if (StringUtils.isBlank((CharSequence)(supplierField = schemeObj.getString("fieldid")))) {
            supplierField = "supplier";
        }
        if ("srm_supcategory".equals(context.getBaseDataType())) {
            supplierField = "supplier.supplier";
        }
        String supplierFieldId = supplierField + '.' + "id";
        String orgField = schemeObj.getString("orgfieldid");
        if (StringUtils.isBlank((CharSequence)orgField)) {
            orgField = "org";
        }
        String orgFieldId = orgField + '.' + "id";
        if ("bd_supplier".equals(context.getBaseDataType()) || context.getBaseDataType().equals(context.getMainDataType())) {
            SupplierFilterUtils.linkSupplierQFilter(context, context.getQfilter());
            return;
        }
        QFilter qfilter = context.getQfilter();
        if (qfilter == null) {
            return;
        }
        DynamicObjectCollection rows = QueryServiceHelper.query((String)context.getBaseDataType(), (String)(supplierFieldId + ',' + orgFieldId), (QFilter[])qfilter.toArray());
        if (rows == null || rows.size() == 0) {
            context.setEmpty(true);
        } else {
            DynamicObjectCollection supRows;
            Set supplierIds = rows.stream().filter(e -> e.getLong(supplierFieldId) > 0L).map(e -> e.getLong(supplierFieldId)).collect(Collectors.toSet());
            QFilter supplierFlter = new QFilter("id", "in", supplierIds).or("masterid", "in", supplierIds);
            QFilter extFilter = SupplierUtil.getAddSupplierFilter(context.getToolObj(), null == context.getView().getParentView() ? context.getToolObj() : context.getView().getParentView().getModel().getDataEntity(), context.getProjectId(), 0L);
            if (null != extFilter) {
                supplierFlter.and(extFilter);
            }
            if ((supRows = QueryServiceHelper.query((String)context.getMainDataType(), (String)"id,masterid,org.id", (QFilter[])supplierFlter.toArray())) == null || supRows.size() == 0) {
                context.setEmpty(true);
            } else {
                HashSet<Long> selectSupplierIds = new HashSet<Long>(supRows.size());
                Map<String, Long> orgId_masterIdMap = supRows.stream().filter(e -> e.getLong("masterid") > 0L).collect(Collectors.groupingBy(e -> e.getString("org.id") + '_' + e.getString("masterid"), Collectors.collectingAndThen(Collectors.toList(), value -> ((DynamicObject)value.get(0)).getLong("id"))));
                Set orgId_supplierIdSet = rows.stream().filter(e -> e.getLong(supplierFieldId) > 0L).map(e -> e.getString(orgFieldId) + '_' + e.getString(supplierFieldId)).collect(Collectors.toSet());
                List orgIdSet = rows.stream().filter(e -> e.getLong(supplierFieldId) > 0L).map(e -> e.getLong(orgFieldId)).distinct().collect(Collectors.toList());
                Map allSuperiorOrgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"02", orgIdSet);
                for (String orgId_supplierId : orgId_supplierIdSet) {
                    String org_sup_Key;
                    long supplierId = PdsCommonUtils.object2Long(orgId_masterIdMap.get(orgId_supplierId));
                    if (supplierId > 0L) {
                        selectSupplierIds.add(supplierId);
                        continue;
                    }
                    long currentOrgId = PdsCommonUtils.object2Long(orgId_supplierId.split("\\_")[0]);
                    long currentSupId = PdsCommonUtils.object2Long(orgId_supplierId.split("\\_")[1]);
                    List superiorOrgIdList = (List)allSuperiorOrgIds.get(currentOrgId);
                    if (null == superiorOrgIdList || superiorOrgIdList.size() == 0) continue;
                    for (int i = superiorOrgIdList.size() - 1; i >= 0 && (supplierId = PdsCommonUtils.object2Long(orgId_masterIdMap.get(org_sup_Key = PdsCommonUtils.buildString(superiorOrgIdList.get(i), "_", currentSupId)))) <= 0L; --i) {
                    }
                    if (supplierId > 0L) {
                        selectSupplierIds.add(supplierId);
                        continue;
                    }
                    selectSupplierIds.add(currentSupId);
                }
                QFilter supplierQfilter = new QFilter("id", "in", selectSupplierIds);
                SupplierFilterUtils.linkSupplierQFilter(context, supplierQfilter);
            }
        }
    }

    private static void linkSupplierQFilter(SupplierContext context, QFilter qfilter) {
        if (null == qfilter) {
            return;
        }
        if (context.getUltimateQFilter() == null) {
            context.setUltimateQFilter(qfilter);
        } else if (context.isAllSupplier()) {
            context.setUltimateQFilter(qfilter);
        } else {
            context.setUltimateQFilter(context.getUltimateQFilter().and(qfilter));
        }
    }

    private static void setQueryConditionVisible(SupplierContext context, DynamicObject schemeObj) {
        String baseDataType = schemeObj.getString("basedata.number");
        context.setBaseDataType(baseDataType);
        String mainDataType = PdsCommonUtils.object2String(schemeObj.get("maindata.number"), "bd_supplier");
        context.setMainDataType(mainDataType);
        String baseDataName = schemeObj.getString("basedata.name");
        context.setBaseDataName(baseDataName);
        PdsSelectUtils.setQueryConditionVisible(context.getView(), baseDataType, Boolean.TRUE);
        ExtFilterUtils.setProperiesVisibleByScheme(schemeObj.getLong("id"), "src_supplierscheme", context.getView(), Boolean.TRUE);
    }

    public static void setProjectObj(ExpertSchemeContext context) {
        IFormView componentView = context.getView().getParentView();
        if (Objects.isNull(componentView)) {
            return;
        }
        IFormView projectView = componentView.getParentView();
        if (Objects.isNull(projectView)) {
            return;
        }
        context.setProjectObj(projectView.getModel().getDataEntity());
    }

    public static void getFilterParameter(SupplierContext context) {
        context.setProjectObj(PdsCommonUtils.getProjectObj(context.getView()));
    }

    public static boolean isAutoQueryAndShow(SupplierContext context) {
        QFilter schemeQfilter = SupplierSchemeUtils.getSchemeFilter(context.getView());
        if (null == schemeQfilter) {
            return false;
        }
        String orderBy = "basedata.number,matchfield desc,number";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_supplierscheme", (String)"id,number,matchfield,basedata.number,basedata.name,fieldid", (QFilter[])schemeQfilter.toArray(), (String)orderBy);
        if (null == rows || rows.size() == 0) {
            return false;
        }
        for (DynamicObject row : rows) {
            if (!ExtParameterUtils.convertToBoolen(ExtParameterUtils.getExtParameterValueById("src_supplierscheme", row.getLong("id"), "isautoquerySup", false, context.getProjectId()))) continue;
            return true;
        }
        return false;
    }

    public static String inviteSupplierType() {
        Object invitetype = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"invitetype");
        if (invitetype == null || "".equals(invitetype)) {
            return null;
        }
        if ("4".equals(invitetype)) {
            return "bd_supplier";
        }
        if ("5".equals(invitetype)) {
            return "srm_supplier";
        }
        return null;
    }

    public static void setSupplierF7Filter(BeforeF7SelectEvent evt, DynamicObject billObj, String number, Map<String, Object> paramMap) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        SupplierContext context = new SupplierContext();
        context.setProjectObj(billObj);
        if (null != paramMap) {
            context.setParamMap(paramMap);
        }
        context.setNumber(number);
        List<Long> schemeIds = SchemeFilterUtils.getAllSchemeIds(context);
        if (schemeIds.size() == 0 && (null == paramMap || null == paramMap.get("ismustinput"))) {
            return;
        }
        QFilter qfilter = new QFilter("id", "in", schemeIds);
        showParameter.getListFilterParameter().setFilter(qfilter);
        String orderBy = context.getOrderBy().length() > 0 ? context.getOrderBy() : "createtime desc,number";
        showParameter.getListFilterParameter().setOrderBy(orderBy);
    }
}

