/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.supplierfilter.category;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.extfilter.PdsQFilterHelper;
import kd.scm.pds.common.selecttool.SupplierContext;
import kd.scm.pds.common.supplierfilter.ISupplierFilter;

public class PdsFilterByCategory
implements ISupplierFilter {
    @Override
    public Map<String, Object> getQFilter(SupplierContext context) {
        Map<String, Object> qfilterMap = PdsQFilterHelper.initQFilterMap();
        List<Long> selectCategoryIds = context.getCategoryIds();
        if (selectCategoryIds == null || selectCategoryIds.size() == 0) {
            return qfilterMap;
        }
        QFilter qfilters = new QFilter("category", "in", selectCategoryIds);
        if (context.isAllCategory()) {
            qfilters = this.getSupplyAllCategoryQFilter(context, qfilters);
        }
        qfilterMap.put("qfilter", qfilters);
        qfilterMap.put("description", String.format(ResManager.loadKDString((String)"\u54c1\u7c7b:%1$s", (String)"PdsFilterByCategory_1", (String)"scm-pds-common", (Object[])new Object[0]), PdsQFilterHelper.buildNames(context.getCategoryNames())));
        return qfilterMap;
    }

    public QFilter getSupplyAllCategoryQFilter(SupplierContext context, QFilter qfilters) {
        List<Long> selectCategoryIds = context.getCategoryIds();
        if (selectCategoryIds == null || selectCategoryIds.size() == 0) {
            return qfilters;
        }
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"srm_supcategory", (String)"id,supplier.id,category.id", (QFilter[])qfilters.toArray());
        if (rows == null || rows.size() == 0) {
            return qfilters;
        }
        Map<String, List<DynamicObject>> supplierMap = rows.stream().collect(Collectors.groupingBy(e -> e.getString("supplier.id")));
        HashSet supCategoryIds = new HashSet(16);
        for (Map.Entry<String, List<DynamicObject>> entry : supplierMap.entrySet()) {
            Set supplyCategoryIds = entry.getValue().stream().map(e -> e.getLong("category.id")).collect(Collectors.toSet());
            if (!supplyCategoryIds.containsAll(selectCategoryIds)) continue;
            supCategoryIds.addAll(entry.getValue().stream().map(e -> e.getLong("id")).collect(Collectors.toSet()));
        }
        return new QFilter("id", "in", supCategoryIds);
    }
}

