/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.supplierfilter.category;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.extfilter.PdsQFilterHelper;
import kd.scm.pds.common.selecttool.SupplierContext;
import kd.scm.pds.common.supplierfilter.ISupplierFilter;

public class PdsFilterByCategoryPurOrg
implements ISupplierFilter {
    @Override
    public Map<String, Object> getQFilter(SupplierContext context) {
        Map<String, Object> qfilterMap = PdsQFilterHelper.initQFilterMap();
        List<Long> selectPurOrgIds = context.getPurorgIds();
        if (selectPurOrgIds == null || selectPurOrgIds.size() == 0) {
            return qfilterMap;
        }
        QFilter qfilters = new QFilter("org", "in", selectPurOrgIds);
        if (context.isAllPurorg()) {
            qfilters = this.getSupplyAllPurOrgQFilter(context, qfilters);
        }
        qfilterMap.put("qfilter", qfilters);
        qfilterMap.put("description", String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\uff1a%1$s", (String)"PdsFilterByCategoryPurOrg_1", (String)"scm-pds-common", (Object[])new Object[0]), PdsQFilterHelper.buildNames(context.getPurorgNames())));
        return qfilterMap;
    }

    public QFilter getSupplyAllPurOrgQFilter(SupplierContext context, QFilter qfilters) {
        List<Long> selectPurOrgIds = context.getPurorgIds();
        if (selectPurOrgIds == null || selectPurOrgIds.size() == 0) {
            return qfilters;
        }
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"srm_supcategory", (String)"id,supplier.id,org.id", (QFilter[])qfilters.toArray());
        if (rows == null || rows.size() == 0) {
            return qfilters;
        }
        Map<String, List<DynamicObject>> supplierMap = rows.stream().collect(Collectors.groupingBy(e -> e.getString("supplier.id")));
        HashSet supCategoryIds = new HashSet(16);
        for (Map.Entry<String, List<DynamicObject>> entry : supplierMap.entrySet()) {
            Set supplyPurOrgIds = entry.getValue().stream().map(e -> e.getLong("org.id")).collect(Collectors.toSet());
            if (!supplyPurOrgIds.containsAll(selectPurOrgIds)) continue;
            supCategoryIds.addAll(entry.getValue().stream().map(e -> e.getLong("id")).collect(Collectors.toSet()));
        }
        return new QFilter("id", "in", supCategoryIds);
    }
}

