/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.supplierfilter.category;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.extfilter.PdsQFilterHelper;
import kd.scm.pds.common.selecttool.PdsSelectUtils;
import kd.scm.pds.common.selecttool.SupplierContext;
import kd.scm.pds.common.supplierfilter.ISupplierFilter;
import kd.scm.pds.common.util.OrgAndUserUtils;
import kd.scm.pds.common.util.PdsCategoryUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsFilterByPurOrgAndCategory
implements ISupplierFilter {
    private static final long serialVersionUID = 1L;

    @Override
    public Map<String, Object> getQFilter(SupplierContext context) {
        Map<String, Object> qfilterMap = PdsQFilterHelper.initQFilterMap();
        if (null == context.getPurorgIds() || context.getPurorgIds().size() == 0) {
            return qfilterMap;
        }
        if (null == context.getCategoryIds() || context.getCategoryIds().size() == 0) {
            return qfilterMap;
        }
        DynamicObject toolObj = context.getView().getModel().getDataEntity(true);
        List<Long> purOrgIds = OrgAndUserUtils.getAllLevelPurOrgIds(context.getPurorgIds(), toolObj.getString("orglevel"));
        boolean isAccurate = toolObj.getBoolean("isaccurate");
        List<Long> categoryIds = PdsCategoryUtils.getAllCategoryIdsByLevel(context.getCategoryIds(), toolObj.getInt("categorylevel"), isAccurate);
        boolean isOrgCategory = toolObj.getBoolean("isorgcategory");
        Set<String> orgCategorySet = isOrgCategory ? PdsSelectUtils.getOrgCategorySet(context) : null;
        QFilter qfilters = this.getSupplyQFilter(purOrgIds, categoryIds, context.getPurlistIds(), toolObj, orgCategorySet);
        qfilterMap.put("qfilter", qfilters);
        qfilterMap.put("description", "");
        return qfilterMap;
    }

    public QFilter getSupplyQFilter(List<Long> purOrgIds, List<Long> categoryIds, List<Long> purlistIds, DynamicObject toolObj, Set<String> orgCategorySet) {
        boolean isAllCategory = toolObj.getBoolean("isallcategory");
        boolean isByPurlist = toolObj.getBoolean("isbypurlist");
        QFilter purOrgFilter = new QFilter("org", "in", purOrgIds);
        QFilter statusFilter = new QFilter("auditstatus", "=", (Object)"1");
        QFilter categoryFilter = null;
        categoryFilter = isByPurlist ? new QFilter("material", "in", purlistIds) : new QFilter("category", "in", categoryIds).or("material", "in", purlistIds);
        QFilter qfilters = purOrgFilter.and(statusFilter).and(categoryFilter);
        HashSet selectBillIds = new HashSet();
        Set categoryIdSet = categoryIds.stream().collect(Collectors.toSet());
        Set purlistIdSet = purlistIds.stream().collect(Collectors.toSet());
        String selectFields = "id,org.id org, supplier.id supplier, category.id category, material.group.id categoryid, material.id material";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"srm_supcategory", (String)selectFields, (QFilter[])qfilters.toArray());
        Map<String, List<DynamicObject>> supplierMap = rows.stream().collect(Collectors.groupingBy(e -> e.getString("supplier")));
        for (Map.Entry<String, List<DynamicObject>> entry : supplierMap.entrySet()) {
            boolean isVerifyOk = false;
            if (isByPurlist) {
                Set supplyPurlistIdSet = entry.getValue().stream().filter(e -> e.getLong("material") > 0L).map(e -> e.getLong("material")).collect(Collectors.toSet());
                supplyPurlistIdSet = PdsCommonUtils.getIntersectSet(supplyPurlistIdSet, purlistIdSet);
                isVerifyOk = isAllCategory ? supplyPurlistIdSet.size() == purlistIdSet.size() : supplyPurlistIdSet.size() > 0;
            } else {
                Set supplyCategoryIdSet = entry.getValue().stream().filter(e -> e.getLong("category") > 0L).map(e -> e.getLong("category")).collect(Collectors.toSet());
                Set supplyCategoryIdSet2 = entry.getValue().stream().filter(e -> e.getLong("categoryid") > 0L).map(e -> e.getLong("categoryid")).collect(Collectors.toSet());
                supplyCategoryIdSet.addAll(supplyCategoryIdSet2);
                supplyCategoryIdSet = PdsCommonUtils.getIntersectSet(supplyCategoryIdSet, categoryIdSet);
                boolean bl = isAllCategory ? supplyCategoryIdSet.size() == categoryIdSet.size() : (isVerifyOk = supplyCategoryIdSet.size() > 0);
                if (isVerifyOk && null != orgCategorySet && orgCategorySet.size() > 0) {
                    Set supplyOrgCategorySet = entry.getValue().stream().map(e -> e.getString("org") + '_' + e.getString("category")).collect(Collectors.toSet());
                    Set<String> newOrgCategorySet = PdsCommonUtils.getIntersectSet(orgCategorySet, supplyOrgCategorySet);
                    boolean bl2 = isVerifyOk = orgCategorySet.size() == newOrgCategorySet.size();
                }
            }
            if (!isVerifyOk) continue;
            selectBillIds.addAll(entry.getValue().stream().map(e -> e.getLong("id")).collect(Collectors.toSet()));
        }
        return new QFilter("id", "in", selectBillIds);
    }
}

