/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.supplierfilter.registersupplier;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.extfilter.PdsQFilterHelper;
import kd.scm.pds.common.selecttool.SupplierContext;
import kd.scm.pds.common.supplierfilter.ISupplierFilter;
import kd.scm.pds.common.util.MultiBasedataUtils;

public class PdsFilterBySupplyProvince
implements ISupplierFilter {
    @Override
    public Map<String, Object> getQFilter(SupplierContext context) {
        Map<String, Object> qfilterMap = PdsQFilterHelper.initQFilterMap();
        List<Long> selectProvinces = context.getSupplyProvinceIds();
        if (selectProvinces == null || selectProvinces.size() == 0) {
            return qfilterMap;
        }
        QFilter qfilters = new QFilter("supplyprovince.fbasedataid.id", "in", selectProvinces);
        long countyId = context.getExtData().getSupplyCountryID(context);
        QFilter qFilter = qfilters = countyId == 0L ? qfilters : qfilters.or(new QFilter("supplyprovince.fbasedataid.id", "=", (Object)countyId));
        if (context.isAllProvince()) {
            qfilters = this.getSupplyAllProvinceQFilter(context, qfilters);
        }
        qfilterMap.put("qfilter", qfilters);
        List<String> supplyProvinceNames = context.getSupplyProvinceNames();
        qfilterMap.put("description", String.format(ResManager.loadKDString((String)"\u4f9b\u8d27\u7701\u4efd:%1$s", (String)"PdsFilterBySupplyProvince_1", (String)"scm-pds-common", (Object[])new Object[0]), PdsQFilterHelper.buildNames(supplyProvinceNames)));
        return qfilterMap;
    }

    public QFilter getSupplyAllProvinceQFilter(SupplierContext context, QFilter qfilters) {
        List<Long> selectProvinceIds = context.getSupplyProvinceIds();
        if (selectProvinceIds == null || selectProvinceIds.size() == 0) {
            return qfilters;
        }
        DynamicObject[] supplierObjs = BusinessDataServiceHelper.load((String)"srm_supplier", (String)"id,supplyprovince", (QFilter[])qfilters.toArray());
        if (supplierObjs == null || supplierObjs.length == 0) {
            return qfilters;
        }
        long countryId = context.getExtData().getSupplyCountryID(context);
        HashSet<Long> supplierIds = new HashSet<Long>(16);
        for (DynamicObject supplierObj : supplierObjs) {
            Set<Long> supplyProvinceIds = MultiBasedataUtils.getBasedataIdSet(supplierObj, "supplyprovince");
            if (supplyProvinceIds == null || supplyProvinceIds.size() <= 0 || !supplyProvinceIds.containsAll(selectProvinceIds) && (countryId == 0L || !supplyProvinceIds.contains(countryId))) continue;
            supplierIds.add((Long)supplierObj.getPkValue());
        }
        return new QFilter("id", "in", supplierIds);
    }
}

