/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.pds.common.attach.AttachmentUtils;
import org.apache.commons.lang3.StringUtils;

public class AttachBatchDownloadUtils {
    public static String buildDownloadTempUrl(String fileName, List<BatchDownloadRequest.Dir> dirs, int timeout) {
        if (CollectionUtils.isEmpty(dirs)) {
            return "";
        }
        BatchDownloadRequest bdr = new BatchDownloadRequest(fileName);
        bdr.setDirs(dirs.toArray(new BatchDownloadRequest.Dir[dirs.size()]));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileService fs = FileServiceFactory.getAttachmentFileService();
        fs.batchDownload(bdr, (OutputStream)out, RequestContext.getOrCreate().getUserAgent());
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TempFileCache tfc = CacheFactory.getCommonCacheFactory().getTempFileCache();
        return tfc.saveAsUrl(fileName, (InputStream)in, timeout);
    }

    private static BatchDownloadRequest.Dir buildAttachDir(DynamicObjectCollection attachment, String fileName) {
        BatchDownloadRequest.Dir dir = new BatchDownloadRequest.Dir(fileName);
        ArrayList<BatchDownloadRequest.File> fileList = new ArrayList<BatchDownloadRequest.File>();
        for (DynamicObject attach : attachment) {
            String url;
            DynamicObject attachInfo = attach.getDynamicObject("fbasedataid");
            if (null == attachInfo) continue;
            String path = url = attachInfo.getString("url");
            String name = attachInfo.getString("name");
            path = AttachmentUtils.uploadTempFile(url, name, null);
            if (url.contains("path=")) {
                path = StringUtils.substringAfter((String)url, (String)"path=");
            }
            try {
                path = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new KDBizException("###url decode exception:" + e.getMessage());
            }
            fileList.add(new BatchDownloadRequest.File(name, path));
        }
        dir.setFiles(fileList.toArray(new BatchDownloadRequest.File[0]));
        return dir;
    }

    public static List<BatchDownloadRequest.Dir> buildAttachDirList(DynamicObjectCollection cols, String attachProperties, String fileNameProperties) {
        ArrayList<BatchDownloadRequest.Dir> dirs = new ArrayList<BatchDownloadRequest.Dir>();
        for (DynamicObject col : cols) {
            DynamicObjectCollection attachment = col.getDynamicObjectCollection(attachProperties);
            String fileName = col.getString(fileNameProperties);
            if (StringUtils.isBlank((CharSequence)fileName) || CollectionUtils.isEmpty((Collection)attachment)) continue;
            BatchDownloadRequest.Dir dir = AttachBatchDownloadUtils.buildAttachDir(attachment, fileName);
            dirs.add(dir);
        }
        return dirs;
    }
}

