/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.scm.pds.common.dataimport.DynamicObjectHandler;
import kd.scm.pds.common.dataimport.handler.PdsDynamicObjHandler;
import kd.scm.pds.common.extplugin.ExtPluginFactory;

public class ExportUtil {
    private static final Log LOG = LogFactory.getLog(ExportUtil.class);

    public static String createTxt(String txt) {
        String fp = "." + File.separator + System.currentTimeMillis() + ".txt";
        File file = new File(fp);
        try (FileWriter fw = new FileWriter(file);
             BufferedWriter bufferedWriter = new BufferedWriter(fw);){
            if (!file.exists() && !file.createNewFile()) {
                throw new KDBizException("create File fail");
            }
            bufferedWriter.write(txt);
            bufferedWriter.write("\n");
        }
        catch (IOException e) {
            LOG.error("export log error", (Throwable)e);
        }
        return fp;
    }

    /*
     * Exception decompiling
     */
    public static String export(DynamicObject object, boolean withRenfrence) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<DynamicObject> loadRefrence(DynamicObject object) {
        String entityName = object.getDynamicObjectType().getName();
        Set<String> directEntityKeySet = ExportUtil.getDirctEntityKey(entityName);
        Set<String> refrenceEntityKeySet = ExportUtil.getRefrenceEntityKey(entityName);
        DataEntityPropertyCollection properties = object.getDynamicObjectType().getProperties();
        return ExportUtil.loadRefrence(object, properties, directEntityKeySet, refrenceEntityKeySet);
    }

    public static List<DynamicObject> loadRefrence(DynamicObject target, DataEntityPropertyCollection properties, Set<String> directEntityKeySet, Set<String> refrenceEntityKeySet) {
        ArrayList<DynamicObject> objsList = new ArrayList<DynamicObject>();
        Set<String> ignoreFields = ExportUtil.getIgnoreFields();
        for (IDataEntityProperty property : properties) {
            String entityKey;
            DynamicObject proVal;
            String name = property.getName();
            if (ignoreFields.contains(name)) continue;
            if (property instanceof EntryProp || property instanceof SubEntryProp) {
                DynamicObjectCollection tarEntryList = target.getDynamicObjectCollection(property.getName());
                if (CollectionUtils.isEmpty((Collection)tarEntryList)) continue;
                DataEntityPropertyCollection entryProperties = null;
                boolean isFirst = true;
                for (DynamicObject tarEntry : tarEntryList) {
                    if (isFirst) {
                        isFirst = false;
                        entryProperties = tarEntry.getDataEntityType().getProperties();
                    }
                    objsList.addAll(ExportUtil.loadRefrence(tarEntry, entryProperties, directEntityKeySet, refrenceEntityKeySet));
                }
                continue;
            }
            if (!(property instanceof BasedataProp) || null == (proVal = target.getDynamicObject(property)) || !directEntityKeySet.contains(entityKey = proVal.getDynamicObjectType().getName())) continue;
            DynamicObject newObj = BusinessDataServiceHelper.loadSingle((Object)proVal.getPkValue(), (String)entityKey);
            if (null != refrenceEntityKeySet && refrenceEntityKeySet.contains(entityKey)) {
                Set<String> directEntityKeySet2 = ExportUtil.getDirctEntityKey(entityKey);
                Set<String> refrenceEntityKeySet2 = ExportUtil.getRefrenceEntityKey(entityKey);
                DataEntityPropertyCollection properties2 = newObj.getDynamicObjectType().getProperties();
                objsList.addAll(ExportUtil.loadRefrence(newObj, properties2, directEntityKeySet2, refrenceEntityKeySet2));
            }
            objsList.add(newObj);
        }
        return objsList;
    }

    public static Set<String> getDirctEntityKey(String entityName) {
        HashSet<String> directEntityKey = new HashSet(8);
        String extNumber = String.format("IDataImport-%s", entityName);
        DynamicObjectHandler handler = (DynamicObjectHandler)ExtPluginFactory.getInstance().getExtPluginInstance(extNumber);
        if (null == handler) {
            handler = new PdsDynamicObjHandler();
        }
        directEntityKey = handler.getDirctEntityKey(entityName);
        return directEntityKey;
    }

    public static Set<String> getRefrenceEntityKey(String entityName) {
        HashSet<String> refrenceEntityKey = new HashSet(8);
        String extNumber = String.format("IDataImport-%s", entityName);
        DynamicObjectHandler handler = (DynamicObjectHandler)ExtPluginFactory.getInstance().getExtPluginInstance(extNumber);
        if (null == handler) {
            handler = new PdsDynamicObjHandler();
        }
        refrenceEntityKey = handler.loadRefrenceEntityKey(entityName);
        return refrenceEntityKey;
    }

    public static Set<String> getIgnoreFields() {
        HashSet<String> ignoreFields = new HashSet<String>();
        ignoreFields.add("multilanguagetext");
        ignoreFields.add("creater");
        ignoreFields.add("creater_id");
        ignoreFields.add("creator");
        ignoreFields.add("creator_id");
        ignoreFields.add("modifier");
        ignoreFields.add("modifier_id");
        ignoreFields.add("lastupdateuser");
        return ignoreFields;
    }
}

