/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.list.IListView;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.scm.common.util.ParamUtil;
import kd.scm.pds.common.util.GridColorStyleData;

public class GridColorStyleUtils {
    private static final String[] PARAMPROARRAY = new String[]{"forecolor", "backcolor", "fontsize"};

    public static void setGridColor(Map<String, Object> paraMap) {
        IFormView view = (IFormView)paraMap.get("view");
        String entryName = (String)paraMap.get("entryname");
        String fieldName = (String)paraMap.get("fieldname");
        List condition = (List)paraMap.get("condition");
        String foreColor = (String)paraMap.get("forecolor");
        String backColor = (String)paraMap.get("backcolor");
        EntryGrid grid = (EntryGrid)view.getControl(entryName);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        IDataModel model = view.getModel();
        int entryCount = model.getEntryRowCount(entryName);
        for (int i = 0; i < entryCount; ++i) {
            DynamicObject rowEntiry = model.getEntryRowEntity(entryName, i);
            String nodeStatus = rowEntiry.getString(fieldName);
            if (!condition.contains(nodeStatus)) continue;
            CellStyle cs = new CellStyle();
            if (foreColor != null) {
                cs.setForeColor(foreColor);
            }
            cs.setFontSize(16);
            if (backColor != null) {
                cs.setBackColor(backColor);
            }
            cs.setRow(i);
            cs.setFieldKey(fieldName);
            cellStyles.add(cs);
        }
        if (cellStyles != null && cellStyles.size() > 0) {
            grid.setCellStyle(cellStyles);
        }
    }

    public static void setGridRowColor(GridColorStyleData styleData) {
        GridColorStyleUtils.getGridStylePara(styleData);
        EntryGrid grid = (EntryGrid)styleData.getView().getControl(styleData.getEntryName());
        HashMap styleMap = new HashMap(16);
        List fieldList = grid.getFieldEdits();
        for (int i = 0; i < fieldList.size(); ++i) {
            styleMap.put(((FieldEdit)fieldList.get(i)).getKey(), new ArrayList());
        }
        IDataModel model = styleData.getView().getModel();
        int entryCount = model.getEntryRowCount(styleData.getEntryName());
        for (int i = 0; i < entryCount; ++i) {
            DynamicObject rowEntiry = model.getEntryRowEntity(styleData.getEntryName(), i);
            String key = null;
            key = rowEntiry.get(styleData.getFieldName()) instanceof DynamicObject ? rowEntiry.getString(styleData.getFieldName() + "." + "id") : rowEntiry.getString(styleData.getFieldName());
            if (!styleData.getCondition().contains(key)) continue;
            for (int k = 0; k < fieldList.size(); ++k) {
                String fieldKey = ((FieldEdit)fieldList.get(k)).getKey();
                CellStyle cs = new CellStyle();
                if (styleData.getForeColor() != null) {
                    cs.setForeColor(styleData.getForeColor());
                }
                if (styleData.getBackColor() != null) {
                    cs.setBackColor(styleData.getBackColor());
                }
                if (styleData.getFontSize() > 0) {
                    cs.setFontSize(styleData.getFontSize());
                }
                cs.setRow(i);
                cs.setFieldKey(fieldKey);
                ((ArrayList)styleMap.get(fieldKey)).add(cs);
            }
        }
        for (Map.Entry styleMapEntry : styleMap.entrySet()) {
            grid.setCellStyle((List)styleMapEntry.getValue());
        }
    }

    public static void setListRowColor(GridColorStyleData styleData) {
        GridColorStyleUtils.getGridStylePara(styleData);
        IListView listView = (IListView)styleData.getView();
        ListSelectedRowCollection rows = listView.getCurrentListAllRowCollection();
        HashMap styleMap = new HashMap(16);
        for (int i = 0; i < styleData.getFieldList().size(); ++i) {
            styleMap.put(styleData.getFieldList().get(i), new ArrayList());
        }
        for (int index = 0; index < rows.size(); ++index) {
            String key = String.valueOf(rows.get(index).getPrimaryKeyValue());
            if (!styleData.getCondition().contains(key)) continue;
            for (int i = 0; i < styleData.getFieldList().size(); ++i) {
                String fieldKey = styleData.getFieldList().get(i);
                CellStyle cs = new CellStyle();
                if (styleData.getForeColor() != null) {
                    cs.setForeColor(styleData.getForeColor());
                }
                if (styleData.getBackColor() != null) {
                    cs.setBackColor(styleData.getBackColor());
                }
                if (styleData.getFontSize() > 0) {
                    cs.setFontSize(styleData.getFontSize());
                }
                cs.setRow(index);
                cs.setFieldKey(fieldKey);
                ((ArrayList)styleMap.get(fieldKey)).add(cs);
            }
        }
        AbstractGrid grid = (AbstractGrid)styleData.getView().getControl("billlistap");
        for (Map.Entry styleMapEntry : styleMap.entrySet()) {
            grid.setCellStyle((List)styleMapEntry.getValue());
        }
    }

    public static void getGridStylePara(GridColorStyleData styleData) {
        AppParam appParam = new AppParam();
        appParam.setViewType("15");
        appParam.setAppId("0DUM2+6E41IA");
        appParam.setOrgId(Long.valueOf(RequestContext.get().getOrgId()));
        Map systemMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        if (systemMap == null) {
            return;
        }
        block10: for (String paramPro : PARAMPROARRAY) {
            Object paramVal = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)paramPro);
            if (paramVal == null || paramVal.toString().length() == 0) continue;
            switch (paramPro) {
                case "forecolor": {
                    styleData.setForeColor(paramVal.toString());
                    continue block10;
                }
                case "backcolor": {
                    styleData.setBackColor(paramVal.toString());
                    continue block10;
                }
                case "fontsize": {
                    Integer fontSizeInt = Integer.parseInt(paramVal.toString());
                    if (fontSizeInt <= 0) continue block10;
                    styleData.setFontSize(fontSizeInt);
                    continue block10;
                }
            }
        }
    }
}

