/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;

public class ListSelectUtils {
    public static long selectOne(IFormView currView) {
        BillList list = (BillList)currView.getControl("billlistap");
        ListSelectedRow billId = list.getCurrentSelectedRowInfo();
        if (billId != null) {
            return PdsCommonUtils.object2Long(billId.getPrimaryKeyValue());
        }
        ListSelectedRowCollection billList = list.getCurrentListAllRowCollection();
        if (billList != null && billList.size() > 0) {
            return PdsCommonUtils.object2Long(billList.get(0).getPrimaryKeyValue());
        }
        return 0L;
    }

    public static long selectOne(IFormView currView, String entityName, String fieldName) {
        long billId = ListSelectUtils.selectOne(currView);
        if (billId == 0L) {
            return 0L;
        }
        DynamicObject billObj = QueryServiceHelper.queryOne((String)entityName, (String)fieldName, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)});
        if (billObj != null) {
            return billObj.getLong(fieldName);
        }
        return 0L;
    }

    public static long selectOneFromScorerF7(IFormView currView) {
        return ListSelectUtils.selectOne(currView, "src_scoretask_scorerf7", "project.id");
    }

    public static long selectOneFromPurlistF7(IFormView currView) {
        return ListSelectUtils.selectOne(currView, "src_purlistf7", "project.id");
    }

    public static Set<Long> getListSelectPrimaryKeys(IFormView view) {
        BillList list = (BillList)view.getControl("billlistap");
        Object[] selectedRows = list.getSelectedRows().getPrimaryKeyValues();
        if (selectedRows == null || selectedRows.length == 0) {
            return Collections.emptySet();
        }
        return Arrays.asList(selectedRows).stream().map(row -> PdsCommonUtils.object2Long(row)).collect(Collectors.toSet());
    }

    public static Set<Long> getListSelectEntryPrimaryKeys(IFormView view) {
        BillList list = (BillList)view.getControl("billlistap");
        Object[] selectedRows = list.getSelectedRows().getEntryPrimaryKeyValues();
        if (selectedRows == null || selectedRows.length == 0) {
            return Collections.emptySet();
        }
        return Arrays.asList(selectedRows).stream().map(row -> PdsCommonUtils.object2Long(row)).collect(Collectors.toSet());
    }
}

