/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.MulBasedataProp;
import kd.scm.common.util.SrmCommonUtil;

public class MultiBasedataUtils {
    public static Set<Long> getBasedataIdSet(DynamicObject billObj, String multiBasedataField) {
        try {
            DynamicObjectCollection rows = billObj.getDynamicObjectCollection(multiBasedataField);
            Set<Long> bdSet = MultiBasedataUtils.getBasedataIdSet(rows, "fbasedataid.id");
            if (bdSet.size() > 0) {
                return bdSet;
            }
            bdSet = MultiBasedataUtils.getBasedataIdSet(rows, "fbasedataid_id");
            if (bdSet.size() > 0) {
                return bdSet;
            }
            bdSet = MultiBasedataUtils.getBasedataIdSet(rows, "fbasedataid");
            return bdSet;
        }
        catch (Exception e) {
            return new HashSet<Long>();
        }
    }

    private static Set<Long> getBasedataIdSet(DynamicObjectCollection rows, String key) {
        try {
            Set<Long> bdSet = rows.stream().filter(e -> e.getLong(key) > 0L).map(e -> e.getLong(key)).collect(Collectors.toSet());
            return bdSet;
        }
        catch (Exception e2) {
            return new HashSet<Long>();
        }
    }

    public static void setMultiBasedataForModel(IDataModel model, DynamicObjectCollection rows, String multiFieldName) {
        if (null == rows || rows.size() == 0) {
            return;
        }
        Object[] basedataIds = new Object[rows.size()];
        int index = 0;
        for (DynamicObject row : rows) {
            basedataIds[index++] = row.get("id");
        }
        model.setValue(multiFieldName, (Object)basedataIds);
    }

    public static void setMultiBasedataForModel(IDataModel model, Set<Long> idSet, String multiFieldName) {
        if (null == idSet || idSet.size() == 0) {
            return;
        }
        Object[] basedataIds = new Object[idSet.size()];
        int index = 0;
        for (long id : idSet) {
            basedataIds[index++] = id;
        }
        model.setValue(multiFieldName, (Object)basedataIds);
    }

    public static void setMultiBasedataForModel(IDataModel model, DynamicObject obj, String multiFieldName, int rowIndex) {
        DynamicObjectCollection attachRows = obj.getDynamicObjectCollection(multiFieldName);
        if (null == attachRows || attachRows.size() == 0) {
            return;
        }
        DynamicObjectCollection newAttachRows = new DynamicObjectCollection();
        for (DynamicObject attachRow : attachRows) {
            newAttachRows.add((Object)attachRow.getDynamicObject("fbasedataid"));
        }
        MultiBasedataUtils.setMultiBasedataForModel(model, newAttachRows, multiFieldName, rowIndex);
    }

    public static void setMultiBasedataForModel(IDataModel model, DynamicObjectCollection rows, String multiFieldName, int rowIndex) {
        if (null == rows || rows.size() == 0) {
            return;
        }
        Object[] basedataIds = new Object[rows.size()];
        int index = 0;
        for (DynamicObject row : rows) {
            basedataIds[index++] = row.get("id");
        }
        model.setValue(multiFieldName, (Object)basedataIds, rowIndex);
    }

    public static void setMultiBasedataForObject(DynamicObject obj, DynamicObjectCollection rows, String fieldName) {
        DynamicObjectCollection newCols = obj.getDynamicObjectCollection(fieldName);
        MainEntityType mainType = (MainEntityType)obj.getDataEntityType();
        MulBasedataProp mulBasedataProp = (MulBasedataProp)mainType.findProperty(fieldName);
        DynamicObjectType subEntityType = mulBasedataProp.getDynamicCollectionItemPropertyType();
        Object bdObj = null;
        for (DynamicObject row : rows) {
            bdObj = row.get("fbasedataid");
            if (bdObj == null) continue;
            DynamicObject cl = new DynamicObject(subEntityType);
            if (bdObj instanceof DynamicObject) {
                cl.set("fbasedataid", (Object)SrmCommonUtil.getPkValue((DynamicObject)((DynamicObject)bdObj)));
            } else {
                cl.set("fbasedataid", bdObj);
            }
            newCols.add((Object)cl);
        }
    }

    public static void setMultiBasedataForEntryRow(DynamicObject currentRow, Set<Long> baseDataIdSet, String multiFieldName) {
        DynamicObjectCollection multiBaseDatas = currentRow.getDynamicObjectCollection(multiFieldName);
        Set currentIdSet = multiBaseDatas.stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toSet());
        baseDataIdSet.removeAll(currentIdSet);
        for (long baseDataId : baseDataIdSet) {
            DynamicObject newBaseData = multiBaseDatas.addNew();
            newBaseData.set("fbasedataid", (Object)baseDataId);
        }
    }

    public static void setMultiBasedataForBillObj(DynamicObject billObj, Set<Long> baseDataIdSet, String multiFieldName) {
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection(multiFieldName);
        rows.removeAll((Collection)rows);
        for (long baseDataId : baseDataIdSet) {
            DynamicObject row = rows.addNew();
            row.set("fbasedataid", (Object)baseDataId);
        }
    }

    public static void setMultiBasedataForBillObj(DynamicObject billObj, long baseDataId, String multiFieldName) {
        HashSet<Long> baseDataIdSet = new HashSet<Long>(1);
        baseDataIdSet.add(baseDataId);
        MultiBasedataUtils.setMultiBasedataForBillObj(billObj, baseDataIdSet, multiFieldName);
    }

    public static List<DynamicObject> getMultiBasedataObjs(DynamicObjectCollection rows) {
        if (null == rows || rows.size() == 0) {
            return Collections.emptyList();
        }
        return rows.stream().map(row -> row.getDynamicObject("fbasedataid")).distinct().collect(Collectors.toList());
    }

    public static Object[] getMultiBaseDataIds(DynamicObjectCollection rows, String fieldName) {
        if (null == rows || rows.size() == 0) {
            return null;
        }
        Object[] basedataIds = new Object[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            basedataIds[i] = ((DynamicObject)rows.get(i)).getLong(fieldName);
        }
        return basedataIds;
    }
}

