/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class OpenFormUtils {
    public static void openDynamicPage(IFormView currView, String pageKey, ShowType showType, Map<String, Object> paramMap, CloseCallBack closeCallBack) {
        OpenFormUtils.openDynamicPage(currView, pageKey, showType, paramMap, closeCallBack, null);
    }

    public static void openDynamicPage(IFormView currView, String pageKey, ShowType showType, Map<String, Object> paramMap, CloseCallBack closeCallBack, String pageId) {
        IFormView openedView;
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(pageKey);
        if (paramMap != null) {
            fsp.setCustomParams(paramMap);
        }
        if (StringUtils.isNotEmpty((String)pageId) && null != (openedView = currView.getViewNoPlugin(pageId))) {
            fsp.setPageId(pageId);
        }
        if (closeCallBack != null) {
            fsp.setCloseCallBack(closeCallBack);
        }
        fsp.getOpenStyle().setShowType(showType);
        try {
            currView.showForm(fsp);
        }
        catch (Exception e) {
            BizLog.log((String)("openDynamicPage:" + e.getMessage()));
        }
    }

    public static void openBasePage(IFormView currView, String pageKey, Object billId, BillOperationStatus billOperationStatus, ShowType showType, Map<String, Object> paramMap, CloseCallBack closeCallBack) {
        OpenFormUtils.openBasePage(currView, pageKey, billId, billOperationStatus, showType, paramMap, closeCallBack, null);
    }

    public static void openBasePage(IFormView currView, String pageKey, Object billId, BillOperationStatus billOperationStatus, ShowType showType, Map<String, Object> paramMap, CloseCallBack closeCallBack, String pageId) {
        IFormView openedView;
        BaseShowParameter bsp = new BaseShowParameter();
        bsp.setFormId(pageKey);
        bsp.setPkId(billId);
        bsp.setBillStatus(billOperationStatus);
        bsp.getOpenStyle().setShowType(showType);
        if (paramMap != null) {
            bsp.setCustomParams(paramMap);
        }
        if (StringUtils.isNotEmpty((String)pageId) && null != (openedView = currView.getViewNoPlugin(pageId))) {
            bsp.setPageId(pageId);
        }
        if (closeCallBack != null) {
            bsp.setCloseCallBack(closeCallBack);
        }
        try {
            currView.showForm((FormShowParameter)bsp);
        }
        catch (Exception e) {
            BizLog.log((String)("openBasePage:" + e.getMessage()));
        }
    }

    public static void openBillPage(IFormView currView, String pageKey, Object billId, BillOperationStatus billOperationStatus, ShowType showType, Map<String, Object> paramMap, CloseCallBack closeCallBack) {
        OpenFormUtils.openBillPage(currView, pageKey, billId, billOperationStatus, showType, paramMap, closeCallBack, null);
    }

    public static void openBillPage(IFormView currView, String pageKey, Object billId, BillOperationStatus billOperationStatus, ShowType showType, Map<String, Object> paramMap, CloseCallBack closeCallBack, String pageId) {
        IFormView openedView;
        BillShowParameter bsp = new BillShowParameter();
        bsp.setFormId(pageKey);
        if (billId != null && Long.parseLong(billId.toString()) > 0L) {
            bsp.setPkId(billId);
        }
        bsp.setBillStatus(billOperationStatus);
        bsp.getOpenStyle().setShowType(showType);
        if (paramMap != null) {
            bsp.setCustomParams(paramMap);
        }
        if (StringUtils.isNotEmpty((String)pageId) && null != (openedView = currView.getViewNoPlugin(pageId))) {
            bsp.setPageId(pageId);
        }
        if (closeCallBack != null) {
            bsp.setCloseCallBack(closeCallBack);
        }
        try {
            currView.showForm((FormShowParameter)bsp);
        }
        catch (Exception e) {
            BizLog.log((String)("openBillPage:" + e.getMessage()));
        }
    }

    public static void openListPage(IFormView currView, String pageKey, ShowType showType, Map<String, Object> paramMap, QFilter qFilter, CloseCallBack closeCallBack) {
        OpenFormUtils.openListPage(currView, pageKey, showType, paramMap, qFilter, closeCallBack, null);
    }

    public static void openListPage(IFormView currView, String pageKey, ShowType showType, Map<String, Object> paramMap, QFilter qFilter, CloseCallBack closeCallBack, String pageId) {
        IFormView openedView;
        ListShowParameter lsp = new ListShowParameter();
        lsp.setBillFormId(pageKey);
        lsp.getOpenStyle().setShowType(showType);
        lsp.getListFilterParameter().setFilter(qFilter);
        if (paramMap != null) {
            Object orderBy = paramMap.get("orderby");
            if (null != orderBy) {
                lsp.getListFilterParameter().setOrderBy(orderBy.toString());
            }
            lsp.setCustomParams(paramMap);
        }
        if (StringUtils.isNotEmpty((String)pageId) && null != (openedView = currView.getViewNoPlugin(pageId))) {
            lsp.setPageId(pageId);
        }
        if (closeCallBack != null) {
            lsp.setCloseCallBack(closeCallBack);
        }
        try {
            currView.showForm((FormShowParameter)lsp);
        }
        catch (Exception e) {
            BizLog.log((String)("openListPage:" + e.getMessage()));
        }
    }

    public static void openBaseF7Page(IFormView currView, String pageKey, ShowType showType, Map<String, Object> paramMap, QFilter qFilter, CloseCallBack closeCallBack) {
        OpenFormUtils.openBaseF7Page(currView, pageKey, showType, paramMap, qFilter, closeCallBack, true);
    }

    public static void openBaseF7Page(IFormView currView, String pageKey, ShowType showType, Map<String, Object> paramMap, QFilter qFilter, CloseCallBack closeCallBack, boolean multiSelect) {
        ListShowParameter fsp = new ListShowParameter();
        fsp.getOpenStyle().setShowType(showType);
        fsp.setMultiSelect(multiSelect);
        fsp.setLookUp(true);
        fsp.setFormId("bos_listf7");
        fsp.setBillFormId(pageKey);
        fsp.setCloseCallBack(closeCallBack);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("800");
        styleCss.setHeight("600");
        fsp.getOpenStyle().setInlineStyleCss(styleCss);
        fsp.getListFilterParameter().setFilter(qFilter);
        if (paramMap != null) {
            Object mustInput;
            Object orderBy = paramMap.get("orderby");
            if (null != orderBy) {
                fsp.getListFilterParameter().setOrderBy(orderBy.toString());
            }
            fsp.setCustomParams(paramMap);
            Object selectIds = paramMap.get("select_ids");
            if (null != selectIds) {
                fsp.setSelectedRows((Object[])selectIds);
            }
            if (null != (mustInput = paramMap.get("mustinput"))) {
                fsp.setMustInput(((Boolean)mustInput).booleanValue());
            }
        }
        try {
            currView.showForm((FormShowParameter)fsp);
        }
        catch (Exception e) {
            BizLog.log((String)("openBaseF7Page:" + e.getMessage()));
        }
    }
}

