/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;

public class OrgAndUserUtils {
    public static long getSuperiorIdByUserId(long userId) {
        DynamicObjectCollection superiorRows = QueryServiceHelper.query((String)"bos_user", (String)"id,entryentity.ispartjob,entryentity.superior", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)userId)});
        for (DynamicObject row : superiorRows) {
            boolean ispartjob = row.getBoolean("entryentity.ispartjob");
            if (ispartjob) continue;
            long superiorId = row.getLong("entryentity.superior");
            return superiorId;
        }
        for (DynamicObject row : superiorRows) {
            long superiorId = row.getLong("entryentity.superior");
            if (superiorId <= 0L) continue;
            return superiorId;
        }
        return 0L;
    }

    public static long getHasPermBizOrgId(String entityName, String orgViewType) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        List bizOrgIds = orgService.getAllOrgByViewNumber(orgViewType, false);
        if (CollectionUtils.isEmpty((Collection)bizOrgIds)) {
            return 0L;
        }
        if (bizOrgIds.contains(RequestContext.get().getOrgId())) {
            return RequestContext.get().getOrgId();
        }
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), null, (String)entityName, (String)"47150e89000000ac");
        if (hasPermOrgResult.hasAllOrgPerm()) {
            return (Long)bizOrgIds.get(0);
        }
        List orgList = PdsCommonUtils.getIntersectList(bizOrgIds, hasPermOrgResult.getHasPermOrgs());
        if (null == orgList || orgList.size() == 0) {
            return 0L;
        }
        return (Long)orgList.get(0);
    }

    public static List<Long> getAllLevelPurOrgIds(List<Long> currentOrgIds, String orgLevel) {
        if (null == currentOrgIds || currentOrgIds.size() == 0) {
            return new ArrayList<Long>();
        }
        switch (orgLevel) {
            case "1": {
                return currentOrgIds;
            }
            case "2": {
                return OrgUnitServiceHelper.getAllSubordinateOrgs((String)"02", currentOrgIds, (boolean)true);
            }
            case "3": 
            case "4": {
                return OrgAndUserUtils.getOrgByDirectSuperior(currentOrgIds, orgLevel);
            }
        }
        return currentOrgIds;
    }

    public static List<Long> getOrgByDirectSuperior(List<Long> currentOrgIds, String orgLevel) {
        List<Long> allOrgIds = PdsCommonUtils.buildList(currentOrgIds);
        Map directSuperiorOrgMap = OrgUnitServiceHelper.getDirectSuperiorOrg((String)"02", currentOrgIds);
        for (long currentOrgId : currentOrgIds) {
            long parentOrgId = directSuperiorOrgMap.getOrDefault(currentOrgId, currentOrgId);
            if (parentOrgId == 0L) {
                parentOrgId = 100000L;
            }
            ArrayList<Long> parentOrgIds = new ArrayList<Long>();
            parentOrgIds.add(parentOrgId);
            if ("3".equals(orgLevel)) {
                allOrgIds.addAll(OrgUnitServiceHelper.getAllSubordinateOrgs((String)"02", parentOrgIds, (boolean)false));
                continue;
            }
            allOrgIds.addAll(OrgUnitServiceHelper.getAllSubordinateOrgs((String)"02", parentOrgIds, (boolean)true));
        }
        return allOrgIds;
    }
}

