/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsAptitudeUtils {
    public static boolean isOpenApt(DynamicObject billObj, String openType) {
        long pkValue = PdsCommonUtils.object2Long(billObj.getPkValue());
        QFilter aptFilter = new QFilter("billid", "=", (Object)pkValue);
        aptFilter.and(openType, "=", (Object)true);
        if (PdsCommonUtils.isOpenBySupplier(billObj)) {
            aptFilter.and("istender", "=", (Object)"1");
            aptFilter.and("isdiscard", "=", (Object)"0");
            aptFilter.and("isaptitude", "!=", (Object)"2");
            return QueryServiceHelper.exists((String)"src_supplieropen", (QFilter[])aptFilter.toArray());
        }
        return QueryServiceHelper.exists((String)"src_bidopenpackage", (QFilter[])aptFilter.toArray());
    }

    public static Set<String> getAptitudeInvalidSupplierIds(long projectId, String manageType) {
        QFilter aptFilter = new QFilter("billid", "=", (Object)projectId);
        aptFilter.and("isaptitude", "=", (Object)"2");
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_bidopensupplier", (String)"supplier.id,package.id", (QFilter[])aptFilter.toArray());
        if ("2".equals(manageType)) {
            return rows.stream().map(e -> e.getString("supplier.id") + '_' + e.getString("package.id")).collect(Collectors.toSet());
        }
        return rows.stream().map(e -> e.getString("supplier.id")).collect(Collectors.toSet());
    }
}

