/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.botpinterface.IHandleAfterPushBill;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import org.apache.commons.collections.CollectionUtils;

public class PdsBOTPUtils {
    private static Log log = LogFactory.getLog((String)"BOTPUtil");
    protected static final String[] SET_VALUES = new String[]{"creator", "createtime", "billno", "billdate", "billstatus", "bizstatus", "tieredtype"};
    protected static final Set<String> EXCLUDED_SET = new HashSet<String>(Arrays.asList(SET_VALUES));

    public static Map<String, Object> pushBill(String sourceBill, String targetBill, DynamicObject sourceObj, Map<String, Object> defaultValue) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("billid", 0);
        resultMap.put("message", "");
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(sourceBill);
        pushArgs.setTargetEntityNumber(targetBill);
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
        ListSelectedRow row = new ListSelectedRow();
        row.setPrimaryKeyValue(sourceObj.getPkValue());
        selectedRowList.add(row);
        pushArgs.setSelectedRows(selectedRowList);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)targetBill);
        IRefrencedataProvider refDataProvider = BusinessDataServiceHelper::loadRefence;
        if (result.isSuccess()) {
            List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
            ((DynamicObject)targetData.get(0)).set("isallowoperate", (Object)0);
            if (defaultValue != null) {
                for (Map.Entry<String, Object> map : defaultValue.entrySet()) {
                    ((DynamicObject)targetData.get(0)).set(map.getKey(), map.getValue());
                }
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            option.setVariableValue("ishasright", String.valueOf(true));
            OperationResult saveResult = SaveServiceHelper.saveOperate((String)targetBill, (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)option);
            if (saveResult.isSuccess()) {
                resultMap.put("billid", ((DynamicObject)targetData.get(0)).getLong("id"));
            } else {
                resultMap.put("succed", Boolean.FALSE);
                StringBuilder errMsg = new StringBuilder();
                for (int i = 0; i < saveResult.getAllErrorOrValidateInfo().size(); ++i) {
                    errMsg.append(((IOperateInfo)saveResult.getAllErrorOrValidateInfo().get(i)).getMessage()).append('\t');
                }
                resultMap.put("message", errMsg);
            }
        } else {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", result.getMessage());
        }
        return resultMap;
    }

    public static void pushBill(String srcEntityKey, String targetEntityKey, Object id, List<Object> entryIds, String targetEntryEntityKey, IHandleAfterPushBill handleAfterPushBill) {
        ConvertOperationResult result;
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcEntityKey);
        pushArgs.setTargetEntityNumber(targetEntityKey);
        pushArgs.setBuildConvReport(false);
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(entryIds.size());
        for (Object entryId : entryIds) {
            ListSelectedRow row = new ListSelectedRow(id);
            row.setEntryEntityKey(targetEntryEntityKey);
            row.setEntryPrimaryKeyValue(entryId);
            selectedRowList.add(row);
        }
        pushArgs.setSelectedRows(selectedRowList);
        try {
            result = ConvertServiceHelper.push((PushArgs)pushArgs);
        }
        catch (Exception e) {
            log.error(srcEntityKey + "\u4e0b\u63a8" + targetEntityKey + "\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            throw new KDException(new ErrorCode("push error", ResManager.loadKDString((String)"\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PdsBOTPUtils_0", (String)"scm-pds-common", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)targetEntityKey);
        if (!result.isSuccess()) {
            log.error("@@\u4e0b\u63a8\u53d1\u751f\u4e86\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + result.getMessage() + srcEntityKey + "-" + targetEntityKey + "-" + id + "-" + entryIds);
            throw new KDBizException(new ErrorCode("push error", ResManager.loadKDString((String)"\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PdsBOTPUtils_0", (String)"scm-pds-common", (Object[])new Object[0])), new Object[]{result.getMessage()});
        }
        List targetData = result.loadTargetDataObjects((objects, iDataEntityType) -> BusinessDataServiceHelper.loadRefence((Object[])objects, (IDataEntityType)iDataEntityType), mainType);
        handleAfterPushBill.process(targetData);
    }

    public static void createPushArgs(ExtPluginContext context) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(context.getSourceBill());
        pushArgs.setTargetEntityNumber(context.getTargetBill());
        pushArgs.setBuildConvReport(true);
        PdsBOTPUtils.getConvertRule(context);
        pushArgs.setRuleId(context.getRules() == null ? null : context.getRules().get(0).getId());
        context.setPushArgs(pushArgs);
    }

    public static void initPushArgs(ExtPluginContext context) {
        PdsBOTPUtils.createPushArgs(context);
        PushArgs pushArgs = context.getPushArgs();
        List<DynamicObject> sourceObjs = context.getSourceObjs();
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(sourceObjs.size());
        for (DynamicObject sourceObj : sourceObjs) {
            ListSelectedRow row = new ListSelectedRow((Object)1);
            row.setPrimaryKeyValue(sourceObj.getPkValue());
            selectedRowList.add(row);
        }
        pushArgs.setSelectedRows(selectedRowList);
        context.setPushArgs(pushArgs);
    }

    public static void getConvertRule(ExtPluginContext context) {
        if (context.getRules() == null || context.getRules().size() == 0) {
            List rules = ConvertMetaServiceHelper.loadRules((String)context.getSourceBill(), (String)context.getTargetBill());
            if (rules != null && rules.size() > 0) {
                context.setRules(rules);
            } else {
                context.setMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6eBOTP\u8f6c\u6362\u89c4\u5219\uff0c\u8bf7\u5148\u914d\u7f6e\u3002", (String)"PdsBOTPUtils_1", (String)"scm-pds-common", (Object[])new Object[0]));
            }
        }
    }

    public static void doConvertService(ExtPluginContext context) {
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)context.getPushArgs());
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)context.getTargetBill());
        IRefrencedataProvider refDataProvider = BusinessDataServiceHelper::loadRefence;
        if (result.isSuccess()) {
            context.setTargetObjs(result.loadTargetDataObjects(refDataProvider, mainType));
        } else {
            context.setSucced(false);
            if (CollectionUtils.isEmpty((Collection)result.getBillReports())) {
                context.setMessage(result.getMessage());
            } else {
                for (int i = 0; i < result.getBillReports().size(); ++i) {
                    context.setMessage(((SourceBillReport)result.getBillReports().get(i)).getFailMessage());
                }
            }
        }
    }

    public static void saveTargetObjs(ExtPluginContext context) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        option.setVariableValue("ishasright", String.valueOf(true));
        OperationResult saveResult = SaveServiceHelper.saveOperate((String)context.getTargetBill(), (DynamicObject[])context.getTargetObjs().toArray(new DynamicObject[0]), (OperateOption)option);
        if (!saveResult.isSuccess()) {
            context.setSucced(false);
            StringBuilder errMsg = new StringBuilder();
            for (int i = 0; i < saveResult.getAllErrorOrValidateInfo().size(); ++i) {
                errMsg.append(((IOperateInfo)saveResult.getAllErrorOrValidateInfo().get(i)).getMessage()).append('\t');
            }
            context.setMessage(errMsg);
        }
    }

    public static Set<Long> getSrcEntryIdsByBotpLink(DynamicObject targetObj) {
        DynamicObjectCollection rows = targetObj.getDynamicObjectCollection("billhead_lk");
        return rows.stream().map(e -> e.getLong("billhead_lk_sbillid")).collect(Collectors.toSet());
    }
}

