/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;

public class PdsCalculateUtils {
    public static Map<String, BigDecimal> sumGroupMapValue(Map<String, List<DynamicObject>> groupMap, String valueField) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(groupMap.size());
        for (Map.Entry<String, List<DynamicObject>> entry : groupMap.entrySet()) {
            BigDecimal sumVaule = BigDecimal.ZERO;
            for (DynamicObject value : entry.getValue()) {
                sumVaule = sumVaule.add(value.getBigDecimal(valueField));
            }
            resultMap.put(entry.getKey(), sumVaule);
        }
        return resultMap;
    }

    public static List<BigDecimal> sortGroupMapValue(Map<String, BigDecimal> groupMap, boolean isDescent) {
        LinkedList<BigDecimal> valueList = new LinkedList<BigDecimal>();
        for (Map.Entry<String, BigDecimal> entry : groupMap.entrySet()) {
            valueList.add(entry.getValue());
        }
        List<BigDecimal> sortedValueList = valueList.stream().distinct().sorted().collect(Collectors.toList());
        if (isDescent) {
            Collections.reverse(sortedValueList);
        }
        return sortedValueList;
    }

    public static Map<Integer, BigDecimal> getRankMap(List<BigDecimal> sortedValueList) {
        HashMap<Integer, BigDecimal> rankMap = new HashMap<Integer, BigDecimal>(sortedValueList.size());
        int rank = 1;
        for (BigDecimal value : sortedValueList) {
            rankMap.put(rank, value);
            ++rank;
        }
        return rankMap;
    }

    public static Map<String, Map<String, Object>> getRankMapFromGroupMap(Map<String, List<DynamicObject>> groupMap, String valueField, boolean isDescent, int selectNum) {
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(groupMap.size());
        Map<String, BigDecimal> sumMap = PdsCalculateUtils.sumGroupMapValue(groupMap, valueField);
        Map<Integer, BigDecimal> rankMap = PdsCalculateUtils.getRankMap(PdsCalculateUtils.sortGroupMapValue(sumMap, isDescent));
        block0: for (Map.Entry<String, BigDecimal> sumEntry : sumMap.entrySet()) {
            for (Map.Entry<Integer, BigDecimal> rankEntry : rankMap.entrySet()) {
                if (sumEntry.getValue().compareTo(rankEntry.getValue()) != 0) continue;
                HashMap<String, Object> valueMap = new HashMap<String, Object>(2);
                valueMap.put("rank", rankEntry.getKey());
                valueMap.put("value", rankEntry.getValue());
                if (rankEntry.getKey() <= selectNum) {
                    valueMap.put("isvalid", "1");
                } else {
                    valueMap.put("isvalid", "0");
                }
                resultMap.put(sumEntry.getKey(), valueMap);
                continue block0;
            }
        }
        return resultMap;
    }

    public static BigDecimal setScaleByUnit(DynamicObject unitObj, BigDecimal oldValue) {
        RoundingMode roundingMode;
        String precisionAccount;
        if (BigDecimal.ZERO.compareTo(oldValue) == 0) {
            return BigDecimal.ZERO;
        }
        int scale = unitObj.getInt("precision");
        switch (precisionAccount = unitObj.getString("precisionaccount")) {
            case "2": {
                roundingMode = RoundingMode.DOWN;
                break;
            }
            case "3": {
                roundingMode = RoundingMode.UP;
                break;
            }
            default: {
                roundingMode = RoundingMode.HALF_UP;
            }
        }
        return oldValue.setScale(scale, roundingMode);
    }
}

