/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsCategoryUtils {
    public static List<Long> getAllCategoryIdsByLevel(List<Long> categoryIds, int level, boolean isAccurate) {
        QFilter qfilters;
        if (level <= 0) {
            return categoryIds;
        }
        List<Long> allCategoryIds = PdsCommonUtils.buildList(categoryIds);
        List<Long> parentCategoryIds = PdsCommonUtils.buildList(categoryIds);
        level = level > 10 ? 10 : level;
        for (int i = 1; i <= level && (parentCategoryIds = PdsCategoryUtils.getCategoryIds(qfilters = new QFilter("parent", "in", parentCategoryIds))).size() != 0; ++i) {
            allCategoryIds.addAll(parentCategoryIds);
        }
        if (isAccurate) {
            QFilter qfilters2 = new QFilter("id", "in", allCategoryIds);
            qfilters2.and("level", "=", (Object)level);
            return PdsCategoryUtils.getCategoryIds(qfilters2);
        }
        return allCategoryIds;
    }

    public static List<Long> getCategoryIds(QFilter qfilters) {
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"bd_materialgroup", (String)"id", (QFilter[])qfilters.toArray(), (String)"number");
        return rows.stream().map(e -> e.getLong("id")).distinct().collect(Collectors.toList());
    }

    public static DynamicObjectCollection getSupplierCategoryRows(QFilter qfilters) {
        return QueryServiceHelper.query((String)"srm_supcategory", (String)"id,supplier.id,category.id", (QFilter[])qfilters.toArray());
    }
}

