/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.list.BillList;
import kd.bos.logging.BizLog;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.IUserService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.entity.PdsObjectPools;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.extfilter.ExtFilterContext;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsFlowConfigUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;
import kd.scm.pds.common.util.RandomUtils;
import kd.scm.pds.common.util.TemplateUtil;
import net.sf.json.JSONArray;

public class PdsCommonUtils {
    public static void setPrimaryKey(DynamicObject entryObj) {
        ORM.create().setPrimaryKey(entryObj);
    }

    public static void refreshParentView(IFormView view) {
        IFormView parentView;
        IFormView currView = view;
        for (int i = 0; i < 4 && (parentView = currView.getViewNoPlugin(currView.getFormShowParameter().getParentPageId())) != null; ++i) {
            if (PdsCommonUtils.isSourceEntity(parentView)) {
                parentView = currView.getParentView();
                parentView.invokeOperation("refresh");
                view.sendFormAction(parentView);
            }
            currView = parentView;
        }
    }

    private static boolean isSourceEntity(IFormView view) {
        String entityId = view.getEntityId();
        if (PdsCommonUtils.isCompReg(entityId)) {
            return false;
        }
        String prefix = entityId.substring(0, 4);
        return "pds_".equals(prefix) || "src_".equals(prefix) || "tnd_".equals(prefix) || "bos_".equals(prefix);
    }

    public static boolean isSourceEntityView(IFormView view) {
        String entityId = view.getEntityId();
        if (Objects.equals(entityId, "src_projectcard")) {
            return false;
        }
        String prefix = entityId.substring(0, 4);
        return "pds_".equals(prefix) || "src_".equals(prefix) || "tnd_".equals(prefix);
    }

    private static boolean isCompReg(String entityKey) {
        QFilter entityFilter = new QFilter("bizobject", "=", (Object)entityKey);
        return QueryServiceHelper.exists((String)"pds_compreg", (QFilter[])entityFilter.toArray());
    }

    public static boolean isCloseOrTerminated(long projectId) {
        if (projectId == 0L) {
            return false;
        }
        QFilter qFilters = new QFilter("id", "=", (Object)projectId).and(new QFilter("bizstatus", "=", (Object)ProcessStatusEnums.CLOSED.getValue()).or("bizstatus", "=", (Object)ProcessStatusEnums.TERMINATED.getValue()));
        return QueryServiceHelper.exists((String)"src_project", (QFilter[])qFilters.toArray());
    }

    private static boolean currOrgIsPurchaseOrg() {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        List orgIds = orgService.getAllOrgByViewNumber("02", false);
        if (CollectionUtils.isEmpty((Collection)orgIds)) {
            return false;
        }
        return orgIds.contains(RequestContext.get().getOrgId());
    }

    public static long getPurchaseOrg() {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        List orgIds = orgService.getAllOrgByViewNumber("02", false);
        if (CollectionUtils.isEmpty((Collection)orgIds)) {
            return 0L;
        }
        if (orgIds.contains(RequestContext.get().getOrgId())) {
            return RequestContext.get().getOrgId();
        }
        return 0L;
    }

    public static void setDefaultOrg(IDataModel iDataModel, String entityNum) {
        DynamicObject org = iDataModel.getDataEntity().getDynamicObject("org");
        if (Objects.isNull(org) && PdsCommonUtils.currOrgIsPurchaseOrg()) {
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), null, (String)entityNum, (String)"47150e89000000ac");
            if (Objects.isNull(hasPermOrgResult)) {
                return;
            }
            Long orgId = RequestContext.get().getOrgId();
            if (hasPermOrgResult.hasAllOrgPerm() || hasPermOrgResult.getHasPermOrgs().contains(orgId)) {
                iDataModel.setValue("org", (Object)orgId);
            }
        }
    }

    public static void savePurOrg(IDataModel iDataModel) {
        DynamicObject purOrg = iDataModel.getDataEntity().getDynamicObject("org_tmp");
        if (purOrg == null) {
            return;
        }
        iDataModel.setValue("org", purOrg.getPkValue());
    }

    public static QFilter setOrgFilter(String property, String entityNum) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        List purchaseOrgIds = orgService.getAllOrgByViewNumber("02", false);
        QFilter qFilter = new QFilter(property, "in", (Object)purchaseOrgIds);
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), null, (String)entityNum, (String)"47150e89000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            qFilter.and(new QFilter(property, "in", (Object)hasPermOrgResult.getHasPermOrgs()));
        }
        return qFilter;
    }

    public static QFilter setListPermissionFilter(String entityNum, String appId) {
        QFilter qFilter = null;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        List filters = PermissionFilterUtil.getListPermissionFilters((MainEntityType)dataEntityType, (boolean)true, (String)appId, null, (IUserService)new UserService());
        for (QFilter filter : filters) {
            if (Objects.isNull(filter)) continue;
            if (qFilter != null) {
                qFilter.and(filter);
                continue;
            }
            qFilter = filter;
        }
        return qFilter;
    }

    public static QFilter joinFilterByAnd(QFilter ... qFilters) {
        QFilter resultFilter = null;
        for (QFilter qFilter : qFilters) {
            if (Objects.isNull(qFilter)) continue;
            if (resultFilter != null) {
                resultFilter.and(qFilter);
                continue;
            }
            resultFilter = qFilter;
        }
        return resultFilter;
    }

    public static QFilter joinFilterByOr(QFilter ... qFilters) {
        QFilter resultFilter = null;
        for (QFilter qFilter : qFilters) {
            if (Objects.isNull(qFilter)) continue;
            if (resultFilter != null) {
                resultFilter.or(qFilter);
                continue;
            }
            resultFilter = qFilter;
        }
        return resultFilter;
    }

    public static void setCombListValue(IFormView view, String entityName, String controlName) {
        Map<String, String> propetiesMap = PdsMetadataUtil.getAllProMap(entityName, true, true);
        if (null == propetiesMap || propetiesMap.size() == 0) {
            return;
        }
        List<ComboItem> combList = PdsMetadataUtil.buildPropComboItems(propetiesMap);
        if ("pds_fileobject".equals(view.getEntityId()) || "pds_extfilter".equals(view.getEntityId())) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5355\u636e(ID)", (String)"PdsCommonUtils_7", (String)"scm-pds-common", (Object[])new Object[0])));
            item.setValue("id");
            combList.add(item);
        }
        if (null == combList || combList.size() == 0) {
            return;
        }
        ComboEdit fieldsCombo = (ComboEdit)view.getControl(controlName);
        if (null != fieldsCombo) {
            fieldsCombo.setComboItems(combList);
        }
    }

    public static Set<String> getMulComboFieldValue(IDataModel model, String fieldName) {
        Object obj = model.getValue(fieldName);
        if (obj == null) {
            return null;
        }
        return new HashSet<String>(Arrays.asList(obj.toString().split("\\,"))).stream().filter(s -> !"".equals(s)).collect(Collectors.toSet());
    }

    public static Set<String> getMulComboFieldValue(DynamicObject row, String fieldName) {
        Object obj = row.get(fieldName);
        if (obj == null) {
            return null;
        }
        return new HashSet<String>(Arrays.asList(obj.toString().split("\\,"))).stream().filter(s -> !"".equals(s)).collect(Collectors.toSet());
    }

    public static DynamicObject getSrmExtData(String number) {
        String key = "pds_extdata|" + number;
        DynamicObject extData = (DynamicObject)PdsObjectPools.getInstance(key);
        if (extData == null) {
            QFilter qfilter = new QFilter("number", "=", (Object)number);
            qfilter.and(new QFilter("enable", "=", (Object)"1"));
            extData = QueryServiceHelper.queryOne((String)"pds_extdata", (String)"id,number,name,remark", (QFilter[])qfilter.toArray());
            PdsObjectPools.putInstance(key, extData);
        }
        return extData;
    }

    public static long object2Long(Object obj) {
        long var = 0L;
        if (Objects.nonNull(obj)) {
            try {
                var = Long.parseLong(obj.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return var;
    }

    public static int object2Integer(Object obj) {
        int var = 0;
        if (Objects.nonNull(obj)) {
            try {
                var = Integer.parseInt(obj.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return var;
    }

    public static boolean object2Boolean(Object obj) {
        if (null == obj) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return Objects.equals(String.valueOf(obj), "1") || Objects.equals(String.valueOf(obj), "true");
    }

    public static BigDecimal object2BigDecimal(Object obj) {
        BigDecimal var = BigDecimal.ZERO;
        if (Objects.nonNull(obj)) {
            try {
                var = new BigDecimal(obj.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return var;
    }

    public static String getCustomParams(IFormView iFormView) {
        String number = null;
        Map params = iFormView.getFormShowParameter().getCustomParams();
        Object sourceType = params.get("sourcetype");
        if (Objects.nonNull(sourceType)) {
            number = sourceType.toString();
        }
        return number;
    }

    public static String getCustomParamsByMenu(IFormView iFormView, String paramPro) {
        String paramValStr = null;
        Map params = iFormView.getFormShowParameter().getCustomParams();
        Object paramVal = params.get(paramPro);
        if (Objects.nonNull(paramVal)) {
            paramValStr = String.valueOf(paramVal);
        }
        return paramValStr;
    }

    public static DynamicObject getProjectObj(IFormView view) {
        IFormView componentView = view.getParentView();
        if (Objects.isNull(componentView)) {
            return null;
        }
        IFormView projectView = componentView.getParentView();
        if (Objects.isNull(projectView) || !PdsCommonUtils.isValidBillType(projectView)) {
            return null;
        }
        if ("src_project".equals(projectView.getEntityId())) {
            return projectView.getModel().getDataEntity();
        }
        if ("src_bidchange".equals(projectView.getEntityId())) {
            return projectView.getModel().getDataEntity().getDynamicObject("project");
        }
        if ("src_addsupplier".equals(componentView.getEntityId())) {
            return componentView.getModel().getDataEntity().getDynamicObject("project");
        }
        return projectView.getModel().getDataEntity();
    }

    public static void setPageCache(IPageCache iPageCache, String key, Object value) {
        String cache = iPageCache.get(key);
        if (Objects.isNull(cache)) {
            cache = "";
        }
        iPageCache.put(key, cache + '|' + value);
    }

    public static void setPageCache(IPageCache iPageCache, String key, Set<Long> set) {
        iPageCache.remove(key);
        if (CollectionUtils.isEmpty(set)) {
            return;
        }
        iPageCache.put(key, set.stream().map(String::valueOf).collect(Collectors.joining("|")));
    }

    public static Set<Long> getPageCache(IPageCache iPageCache, String key) {
        String cache = iPageCache.get(key);
        if (StringUtils.isNotEmpty((CharSequence)cache)) {
            return Arrays.stream(cache.split("\\|")).filter(StringUtils::isNotEmpty).map(Long::parseLong).collect(Collectors.toSet());
        }
        return new HashSet<Long>();
    }

    public static void isEnableOthRatio(IFormView formView, String properties) {
        Object isRatioOthObj = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"isratio_oth");
        if (Objects.nonNull(isRatioOthObj) && ((Boolean)isRatioOthObj).booleanValue()) {
            formView.setVisible(Boolean.TRUE, new String[]{properties});
        } else {
            formView.setVisible(Boolean.FALSE, new String[]{properties});
        }
    }

    public static Map<String, Object> isRepeatForEntry(DynamicObjectCollection rows, String key1, String key2, String key3) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        boolean succed = true;
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        StringBuilder message = new StringBuilder();
        int i = 1;
        for (DynamicObject row : rows) {
            String key = PdsCommonUtils.getFieldValue(row, key1);
            if (key2 != null) {
                key = key + "|" + PdsCommonUtils.getFieldValue(row, key2);
            }
            if (key3 != null) {
                key = key + "|" + PdsCommonUtils.getFieldValue(row, key3);
            }
            if ("".equals(key.trim())) continue;
            Integer count = (Integer)countMap.get(key);
            if (count != null) {
                if (message.length() == 0) {
                    message.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c", (String)"PdsCommonUtils_0", (String)"scm-pds-common", (Object[])new Object[0]), String.valueOf(i)));
                } else {
                    message.append("\uff0c");
                    message.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c", (String)"PdsCommonUtils_0", (String)"scm-pds-common", (Object[])new Object[0]), String.valueOf(i)));
                }
                countMap.put(key, count + 1);
                succed = false;
            } else {
                countMap.put(key, 1);
            }
            ++i;
        }
        if (!succed) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", String.format(ResManager.loadKDString((String)"%1$s \u5206\u5f55\u4e2d\u8fd9\u4e9b\u884c\u91cd\u590d\u4e86\uff0c\u8bf7\u68c0\u67e5\uff1a %2$s", (String)"PdsCommonUtils_5", (String)"scm-pds-common", (Object[])new Object[0]), rows.getDynamicObjectType().getDisplayName(), message));
        }
        return resultMap;
    }

    private static String getFieldValue(DynamicObject row, String key) {
        Object value = row.get(key);
        if (null == value) {
            return "";
        }
        if (value instanceof DynamicObject) {
            return String.valueOf(((DynamicObject)value).getPkValue());
        }
        return value.toString();
    }

    public static void setScaleByUnit(IDataModel iDataModel, DynamicObject unitObj, BigDecimal oldValue, String properties, int rowIndex) {
        RoundingMode roundingMode;
        String precisionAccount;
        if (BigDecimal.ZERO.compareTo(oldValue) == 0) {
            return;
        }
        int scale = unitObj.getInt("precision");
        switch (precisionAccount = unitObj.getString("precisionaccount")) {
            case "2": {
                roundingMode = RoundingMode.DOWN;
                break;
            }
            case "3": {
                roundingMode = RoundingMode.UP;
                break;
            }
            default: {
                roundingMode = RoundingMode.HALF_UP;
            }
        }
        iDataModel.setValue(properties, (Object)oldValue.setScale(scale, roundingMode), rowIndex);
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortDescend(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, (o1, o2) -> {
            int compare = new BigDecimal(((Comparable)o1.getValue()).toString()).compareTo(new BigDecimal(((Comparable)o2.getValue()).toString()));
            return -compare;
        });
        LinkedHashMap returnMap = new LinkedHashMap(16);
        for (Map.Entry entry : list) {
            returnMap.put(entry.getKey(), entry.getValue());
        }
        return returnMap;
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortAscend(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, (o1, o2) -> {
            int compare = new BigDecimal(((Comparable)o1.getValue()).toString()).compareTo(new BigDecimal(((Comparable)o2.getValue()).toString()));
            return compare;
        });
        LinkedHashMap returnMap = new LinkedHashMap(16);
        for (Map.Entry entry : list) {
            returnMap.put(entry.getKey(), entry.getValue());
        }
        return returnMap;
    }

    public static boolean verifyExtPlugin(IFormView view) {
        try {
            Object obj = Class.forName(view.getModel().getDataEntity().getString("pluginname")).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ext) {
            view.showMessage(ResManager.loadKDString((String)"\u8be5\u63d2\u4ef6\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff0c\u8bf7\u786e\u8ba4\u63d2\u4ef6\u7684\u8def\u5f84\u53ca\u540d\u79f0\u662f\u5426\u6b63\u786e\u3002", (String)"PdsCommonUtils_3", (String)"scm-pds-common", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean verifyEntryExtPlugin(IFormView view) {
        DynamicObjectCollection rows = view.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        boolean isSucced = true;
        StringBuilder sb = new StringBuilder();
        for (DynamicObject row : rows) {
            String plugName = row.getString("pluginname");
            if (StringUtils.isBlank((CharSequence)plugName)) continue;
            try {
                Object obj = Class.forName(plugName).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ext) {
                sb.append(plugName);
                sb.append(";\n");
                isSucced = false;
            }
        }
        if (!isSucced) {
            view.showMessage(String.format(ResManager.loadKDString((String)"\u8fd9\u4e9b\u63d2\u4ef6\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff0c\u8bf7\u786e\u8ba4\u63d2\u4ef6\u7684\u8def\u5f84\u53ca\u540d\u79f0\u662f\u5426\u6b63\u786e: %1$s", (String)"PdsCommonUtils_4", (String)"scm-pds-common", (Object[])new Object[0]), sb.toString()));
        }
        return isSucced;
    }

    public static Object[] saveDynamicObjects(List<DynamicObject> objs) {
        if (objs == null || objs.size() == 0) {
            return null;
        }
        return SaveServiceHelper.save((DynamicObject[])objs.toArray(new DynamicObject[0]));
    }

    public static Object[] saveDynamicObjects(DynamicObject[] objs) {
        if (objs == null || objs.length == 0) {
            return null;
        }
        return SaveServiceHelper.save((DynamicObject[])objs);
    }

    public static Object[] saveDynamicObjects(DynamicObject obj) {
        if (obj == null) {
            return null;
        }
        return SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
    }

    public static String getIsvId() {
        String isvId = (String)PdsObjectPools.getInstance("isv_id");
        if (isvId != null) {
            return isvId;
        }
        isvId = (String)DB.query((DBRoute)DBRoute.meta, (String)"select FISVID from T_BAS_ISV", rs -> {
            String isv = null;
            if (rs.next()) {
                isv = rs.getString(1);
            }
            return isv;
        });
        PdsObjectPools.putInstance("isv_id", isvId);
        return isvId;
    }

    public static void setIsvId(IFormView view) {
        String isvId = PdsCommonUtils.getIsvId();
        view.getModel().setValue("isv_id", (Object)isvId);
        view.getModel().setDataChanged(false);
    }

    public static DynamicObject getCurrentUserId() {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
    }

    public static void createEntryEntity(IFormView targetView, String sourceEntity, QFilter sourceQfilter, Set<String> excFields, String entryEntity) {
        AbstractFormDataModel model = (AbstractFormDataModel)targetView.getModel();
        model.deleteEntryData(entryEntity);
        String selectfields = DynamicObjectUtil.getSelectfields((String)sourceEntity, (boolean)true);
        DynamicObject[] srouceRows = BusinessDataServiceHelper.load((String)sourceEntity, (String)selectfields, (QFilter[])new QFilter[]{sourceQfilter}, (String)"purlist.id,supplier.id");
        if (srouceRows == null || srouceRows.length == 0) {
            return;
        }
        if (excFields == null) {
            excFields = Collections.emptySet();
        }
        EntryGrid entryGrid = (EntryGrid)targetView.getControl(entryEntity);
        List properties = DynamicObjectUtil.getContainerProperties((Container)entryGrid);
        TableValueSetter ts = new TableValueSetter(new String[0]);
        for (int i = 0; i < srouceRows.length; ++i) {
            DynamicObject row = srouceRows[i];
            for (String pro : properties) {
                if (excFields.contains(pro)) continue;
                try {
                    if (pro.equals("srcentryid")) {
                        ts.set("srcentryid", row.getPkValue(), i);
                        continue;
                    }
                    if (row.get(pro) instanceof DynamicObject) {
                        ts.set(pro, row.getDynamicObject(pro).getPkValue(), i);
                        continue;
                    }
                    if (row.get(pro) instanceof DynamicObjectCollection) {
                        ts.set(pro, (Object)PdsCommonUtils.cloneCols(row, pro), i);
                        continue;
                    }
                    ts.set(pro, row.get(pro), i);
                }
                catch (Exception e) {
                    BizLog.log((String)e.getMessage());
                }
            }
        }
        model.batchCreateNewEntryRow(entryEntity, ts);
    }

    public static String getConnectErp() {
        Object obj = ParamUtil.getParamObj((String)"eae607fb000143ac", (String)"connecterp");
        if (Objects.isNull(obj) || StringUtils.isEmpty((CharSequence)obj.toString())) {
            return "";
        }
        return String.valueOf(obj);
    }

    public static DynamicObject getNoPackageNameObj(long projectId) {
        QFilter projectFilter = new QFilter("project", "=", (Object)projectId);
        projectFilter.and("packagename", "in", (Object)"ByItem");
        DynamicObject packageObj = BusinessDataServiceHelper.loadSingle((String)"src_packagef7", (String)"package", (QFilter[])new QFilter[]{projectFilter});
        return packageObj;
    }

    public static void setOperateListValue(IFormView view, DynamicObject bizObject, String OperateField) {
        ComboEdit entityOpCombo = (ComboEdit)view.getControl(OperateField);
        if (null == entityOpCombo) {
            return;
        }
        if (null == bizObject) {
            entityOpCombo.setComboItems(new ArrayList());
            view.getModel().setValue(OperateField, (Object)"");
            return;
        }
        String entityNumber = bizObject.getString("number");
        List<ComboItem> comboList = PdsMetadataUtil.getOpreateComboItemList(entityNumber);
        if (null == comboList || comboList.size() == 0) {
            entityOpCombo.setComboItems(new ArrayList());
            view.getModel().setValue(OperateField, (Object)"");
            return;
        }
        entityOpCombo.setComboItems(comboList);
    }

    public static DynamicObject[] getPreviousObjs(DynamicObject[] objs) {
        List<Long> idList = Arrays.asList(objs).stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        Object[] pkIds = idList.toArray(new Long[0]);
        DynamicObject[] previousObjs = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)objs[0].getDynamicObjectType());
        return previousObjs;
    }

    public static Map<String, Object> getCustomParamMap(IFormView currView) {
        FormShowParameter formShowParameter = currView.getFormShowParameter();
        return formShowParameter.getCustomParams();
    }

    public static Object getCustomParamValue(IFormView currView, String key) {
        Map<String, Object> paramMap = PdsCommonUtils.getCustomParamMap(currView);
        if (null == paramMap || paramMap.size() == 0) {
            return null;
        }
        Object valurObj = paramMap.get(key);
        if (null == valurObj) {
            return null;
        }
        return valurObj;
    }

    public static Map<String, Object> getSelectPrimaryKeysMap(IFormView currView) {
        Map<String, Object> paramMap = PdsCommonUtils.getCustomParamMap(currView);
        BillList list = (BillList)currView.getControl("billlistap");
        Object[] selectedRows = list.getSelectedRows().getPrimaryKeyValues();
        List billIds = Arrays.asList(selectedRows).stream().map(row -> PdsCommonUtils.object2Long(row)).collect(Collectors.toList());
        paramMap.put("billid", billIds);
        return paramMap;
    }

    public static ChangeData getPropertyChangedData(PropertyChangedArgs evt) {
        ChangeData[] changeSet = evt.getChangeSet();
        ChangeData changeData = changeSet[0];
        if (null == changeData) {
            return null;
        }
        int rowIndex = changeData.getRowIndex();
        if (rowIndex < 0) {
            return null;
        }
        return changeData;
    }

    public static Object getPropertyChangedNewValue(PropertyChangedArgs evt) {
        ChangeData changeData = PdsCommonUtils.getPropertyChangedData(evt);
        if (null == changeData) {
            return null;
        }
        return changeData.getNewValue();
    }

    public static Object getPropertyChangedRowObject(PropertyChangedArgs evt, String fieldName) {
        ChangeData changeData = PdsCommonUtils.getPropertyChangedData(evt);
        if (null == changeData) {
            return null;
        }
        return changeData.getDataEntity().get(fieldName);
    }

    public static DynamicObject[] loadBillObjsByQFilter(String entityName, QFilter qfilter) {
        DynamicObjectCollection rows = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])qfilter.toArray());
        if (rows.size() == 0) {
            return null;
        }
        Object[] pkIds = new Object[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            pkIds[i] = ((DynamicObject)rows.get(i)).getLong("id");
        }
        DynamicObject[] billObjs = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)entityName).getDynamicObjectType());
        return billObjs;
    }

    public static DynamicObject loadBillObjByQFilter(String entityName, QFilter qfilter, String orderBy) {
        DynamicObjectCollection rows = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])qfilter.toArray(), (String)orderBy);
        if (rows.size() == 0) {
            return BusinessDataServiceHelper.newDynamicObject((String)entityName);
        }
        return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)rows.get(0)).getLong("id"), (String)entityName);
    }

    public static DynamicObject[] loadBillObjsByQFilter(String entityName, QFilter qfilter, String orderBy) {
        String selectProperties = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)false);
        return BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])qfilter.toArray(), (String)orderBy);
    }

    public static DynamicObject[] loadBillObjsByIdSet(String entityName, Set<Long> idSet) {
        Object[] pkIds = idSet.toArray(new Object[0]);
        DynamicObject[] billObjs = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)entityName).getDynamicObjectType());
        return billObjs;
    }

    public static <T> List<List<T>> splitList(List<T> list, int count) {
        if (null == list || list.size() == 0) {
            return Collections.emptyList();
        }
        int limit = (list.size() + count - 1) / count;
        List<List<T>> splitList = ((Stream)Stream.iterate(0, n -> n + 1).limit(limit).parallel()).map(a -> ((Stream)list.stream().skip(a * count).limit(count).parallel()).collect(Collectors.toList())).collect(Collectors.toList());
        return splitList;
    }

    public static String object2String(Object obj, String defaultValue) {
        if (StringUtils.isBlank((Object)obj)) {
            if (null != defaultValue) {
                return defaultValue;
            }
            return "";
        }
        if (obj instanceof String) {
            return obj.toString();
        }
        if (obj instanceof List) {
            List objList = (List)obj;
            return null == objList || objList.size() == 0 ? "" : objList.get(0).toString();
        }
        if (obj instanceof Set) {
            Set objSet = (Set)obj;
            return null == objSet || objSet.size() == 0 ? "" : objSet.iterator().next().toString();
        }
        return obj.toString();
    }

    public static String set2String(Set<String> valueSet) {
        return String.join((CharSequence)",", valueSet);
    }

    public static String list2String(List<String> valueList) {
        return String.join((CharSequence)",", valueList);
    }

    public static long getBasedataIdByNumber(String entityName, String number) {
        QFilter qfilters = new QFilter("number", "=", (Object)number);
        DynamicObject baseDataObj = QueryServiceHelper.queryOne((String)entityName, (String)"id", (QFilter[])qfilters.toArray());
        if (null != baseDataObj) {
            return baseDataObj.getLong("id");
        }
        return 0L;
    }

    public static void copyDynamicObjectValue(DynamicObject oldObj, DynamicObject newObj, List<String> properties, Set<String> excludedFields, int seq, String subfix, String prefix) {
        if (null == subfix) {
            subfix = "";
        }
        if (null == prefix) {
            prefix = "";
        }
        for (String property : properties) {
            if (null != excludedFields && excludedFields.size() > 0 && excludedFields.contains(property)) continue;
            try {
                Object objValue = oldObj.get(property);
                if (objValue instanceof DynamicObject) {
                    newObj.set(prefix + property + subfix, ((DynamicObject)objValue).getPkValue());
                    continue;
                }
                if (objValue instanceof DynamicObjectCollection) {
                    newObj.set(prefix + property + subfix, (Object)PdsCommonUtils.cloneCols(oldObj, property));
                    continue;
                }
                newObj.set(prefix + property + subfix, objValue);
            }
            catch (Exception exception) {}
        }
        if (seq >= 0 && !properties.contains("fseq")) {
            newObj.set("seq", (Object)seq);
        }
    }

    public static void copyDynamicObjectValue(DynamicObject oldObj, DynamicObject newObj, List<String> properties, Set<String> excludedFields, int seq, String subfix) {
        PdsCommonUtils.copyDynamicObjectValue(oldObj, newObj, properties, excludedFields, seq, subfix, "");
    }

    public static void copyDynamicObjectValue2(DynamicObject oldObj, DynamicObject newObj, List<String> properties, Set<String> excludedFields, int seq, String subfix) {
        if (null == subfix) {
            subfix = "";
        }
        Iterator<String> iterator = properties.iterator();
        while (iterator.hasNext()) {
            String propertyStr;
            String sourceProperty = propertyStr = iterator.next();
            String targetProperty = propertyStr;
            String[] propertys = propertyStr.split("\\|");
            if (propertys.length > 1) {
                sourceProperty = propertys[0];
                targetProperty = propertys[1];
            }
            if (null != excludedFields && excludedFields.size() > 0 && excludedFields.contains(targetProperty)) continue;
            try {
                Object objValue = oldObj.get(sourceProperty);
                if (objValue instanceof DynamicObject) {
                    newObj.set(targetProperty + subfix, ((DynamicObject)objValue).getPkValue());
                    continue;
                }
                if (objValue instanceof DynamicObjectCollection) {
                    newObj.set(targetProperty + subfix, (Object)PdsCommonUtils.cloneCols(oldObj, sourceProperty));
                    continue;
                }
                newObj.set(targetProperty + subfix, objValue);
            }
            catch (Exception exception) {}
        }
        if (seq >= 0 && !properties.contains("fseq")) {
            newObj.set("seq", (Object)seq);
        }
    }

    public static void copyDynamicObjectValue(DynamicObject oldObj, DynamicObject newObj, List<String> properties, Set<String> excludedFields, int seq) {
        PdsCommonUtils.copyDynamicObjectValue(oldObj, newObj, properties, excludedFields, seq, "");
    }

    public static void copyDynamicObjectValue(DynamicObject oldObj, DynamicObject newObj, DataEntityPropertyCollection properties, Set<String> excludedFields, int seq) {
        List<String> propertiesList = properties.stream().map(e -> e.getName()).collect(Collectors.toList());
        PdsCommonUtils.copyDynamicObjectValue(oldObj, newObj, propertiesList, excludedFields, seq, "");
    }

    public static void copyDynamicObjectValue(DynamicObject oldObj, List<String> properties, Set<String> excludedFields, IDataModel model, int rowIndex, String subfix, String prefix) {
        if (null == subfix) {
            subfix = "";
        }
        if (null == prefix) {
            prefix = "";
        }
        for (String property : properties) {
            if (null != excludedFields && excludedFields.size() > 0 && excludedFields.contains(property)) continue;
            try {
                Object objValue = oldObj.get(property);
                if (objValue instanceof DynamicObject) {
                    model.setValue(prefix + property + subfix, ((DynamicObject)objValue).getPkValue(), rowIndex);
                    continue;
                }
                if (objValue instanceof DynamicObjectCollection) {
                    model.setValue(prefix + property + subfix, (Object)PdsCommonUtils.cloneCols(oldObj, property), rowIndex);
                    continue;
                }
                model.setValue(prefix + property + subfix, objValue, rowIndex);
            }
            catch (Exception exception) {}
        }
    }

    public static void copyDynamicObjectValue(DynamicObject oldObj, List<String> properties, Set<String> excludedFields, IDataModel model, int rowIndex) {
        PdsCommonUtils.copyDynamicObjectValue(oldObj, properties, excludedFields, model, rowIndex, "", "");
    }

    public static void copyDynamicObjectValue(DynamicObject oldObj, List<String> properties, Set<String> excludedFields, IDataModel model, String subfix, String prefix) {
        if (null == subfix) {
            subfix = "";
        }
        if (null == prefix) {
            prefix = "";
        }
        for (String property : properties) {
            if (null != excludedFields && excludedFields.size() > 0 && excludedFields.contains(property)) continue;
            try {
                Object objValue = oldObj.get(property);
                if (objValue instanceof DynamicObject) {
                    model.setValue(prefix + property + subfix, ((DynamicObject)objValue).getPkValue());
                    continue;
                }
                if (objValue instanceof DynamicObjectCollection) {
                    model.setValue(prefix + property + subfix, (Object)PdsCommonUtils.cloneCols(oldObj, property));
                    continue;
                }
                model.setValue(prefix + property + subfix, objValue);
            }
            catch (Exception exception) {}
        }
    }

    public static String getShowCompTitle(String entityKey, String compKey, DynamicObject bidComp) {
        if (Objects.isNull(bidComp)) {
            bidComp = PdsCommonUtils.getCompRegData(entityKey, compKey);
        }
        String title = "";
        if (null != bidComp) {
            title = bidComp.getString("name");
        } else {
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)compKey);
            title = type.getDisplayName().toString();
        }
        return title;
    }

    public static DynamicObject getCompRegData(String entityKey, String compKey) {
        QFilter bidCompfilter = new QFilter("enable", "=", (Object)"1");
        if (null != entityKey) {
            bidCompfilter.and("biznode.bizobject", "=", (Object)entityKey);
        }
        if (null != compKey) {
            bidCompfilter.and("bizobject.number", "=", (Object)compKey);
        }
        return BusinessDataServiceHelper.loadSingle((String)"pds_compreg", (String)"id,name", (QFilter[])new QFilter[]{bidCompfilter});
    }

    public static boolean isNotProjectBill(String entityName) {
        return PdsCommonUtils.getNotProjectBill().contains(entityName);
    }

    public static Set<String> getNotProjectBill() {
        HashSet<String> billSet = new HashSet<String>(8);
        billSet.add("src_negotiatebill");
        billSet.add("tnd_tenderbill");
        billSet.add("tnd_quotebill");
        billSet.add("src_bidchange");
        billSet.add("tnd_bidchange");
        billSet.add("src_batchdecision");
        billSet.add("src_bidopenapply");
        billSet.add("tnd_bidenroll");
        billSet.add("tnd_inviteletter");
        billSet.add("tnd_winnotice");
        return billSet;
    }

    public static void setFieldMastInput(IFormView view, String fieldName, boolean mustInput) {
        Control cont = view.getControl(fieldName);
        if (cont instanceof TextEdit) {
            TextEdit td = (TextEdit)cont;
            td.setMustInput(mustInput);
        } else if (cont instanceof BasedataEdit) {
            BasedataEdit td = (BasedataEdit)cont;
            td.setMustInput(mustInput);
        } else if (cont instanceof ComboEdit) {
            ComboEdit td = (ComboEdit)cont;
            td.setMustInput(mustInput);
        }
    }

    public static void setEntryGridTitle(IFormView view, String entrygrid, String fieldId, String fieldName) {
        EntryGrid grid = (EntryGrid)view.getControl(entrygrid);
        grid.setColumnProperty(fieldId, "header", (Object)new LocaleString(fieldName));
    }

    public static boolean isOpenBySupplier(DynamicObject billObj) {
        if (null != billObj) {
            long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("srctype"));
            return ExtParameterUtils.convertToBoolen(ExtParameterUtils.getExtParameterValueById("pds_flowconfig", sourceFlowId, "isopenbysupplier", false, SrmCommonUtil.getPkValue((DynamicObject)billObj)));
        }
        return false;
    }

    public static boolean isOpenBySupplier(long projectId) {
        if (projectId > 0L) {
            DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_project", (String)"srctype");
            return PdsCommonUtils.isOpenBySupplier(billObj);
        }
        return false;
    }

    public static Map<String, String> getProMapFromPageCache(IFormView view, String entityName, String type, String entryName) {
        Map<String, String> proMap = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)entityName)) {
            return proMap;
        }
        String key = StringUtils.isNotEmpty((CharSequence)entryName) ? entityName + '_' + type + '_' + entryName : entityName + '_' + type;
        String proMapString = view.getPageCache().get(key);
        if (null != proMapString) {
            proMap = (Map)SerializationUtils.fromJsonString((String)proMapString, proMap.getClass());
        } else {
            proMap = type.equals("base") ? PdsMetadataUtil.getDynamicBDProperties(BusinessDataServiceHelper.newDynamicObject((String)entityName), entryName) : PdsMetadataUtil.getProTypeMap(entityName, true);
            view.getPageCache().put(key, SerializationUtils.toJsonString(proMap));
        }
        return proMap;
    }

    public static <T> Set<T> getSetFormShowParam(IFormView view, String key) {
        Map paramMap = view.getFormShowParameter().getCustomParams();
        if (null == paramMap) {
            return Collections.emptySet();
        }
        Object obj = paramMap.get(key);
        if (null == obj) {
            return Collections.emptySet();
        }
        return (Set)SerializationUtils.fromJsonString((String)obj.toString(), Set.class);
    }

    public static void setMultiBasedataValue(IFormView view, String key) {
        Set<Long> idSet = PdsCommonUtils.getSetFormShowParam(view, key);
        if (idSet.size() > 0) {
            MultiBasedataUtils.setMultiBasedataForModel(view.getModel(), idSet, key);
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{key});
        }
    }

    public static void setMultiListValue(IFormView view, String key) {
        Set idSet = PdsCommonUtils.getSetFormShowParam(view, key);
        if (idSet.size() > 0) {
            view.getModel().setValue(key, (Object)String.join((CharSequence)",", idSet));
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{key});
        }
    }

    public static int getMoreThanHalfCount(int count) {
        if (count == 0) {
            return 0;
        }
        BigDecimal ratio = new BigDecimal(count + 1).divide(new BigDecimal(count * 2), 10, RoundingMode.HALF_UP);
        return new BigDecimal(count).multiply(ratio).intValue();
    }

    public static <T> Set<T> getIntersectSet(Set<T> set1, Set<T> set2) {
        if (null == set1 || set1.size() == 0 || null == set2 || set2.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<T> result = new HashSet<T>(set1.size() + set2.size());
        result.addAll(set1);
        result.retainAll(set2);
        return result;
    }

    public static <T> List<T> getIntersectList(List<T> list1, List<T> list2) {
        if (null == list1 || list1.size() == 0 || null == list2 || list2.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>(list1.size() + list2.size());
        result.addAll(list1);
        result.retainAll(list2);
        return result;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        HashMap map = new HashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public static void getSupUser(Set<Long> specialSupUserIds, Set<Long> userIds) {
        if (CollectionUtils.isEmpty(specialSupUserIds)) {
            return;
        }
        DynamicObjectCollection specialUserDyns = QueryServiceHelper.query((String)"pur_supuser", (String)"id,user", (QFilter[])new QFilter[]{new QFilter("id", "in", specialSupUserIds)});
        for (DynamicObject specialUserDyn : specialUserDyns) {
            userIds.add(specialUserDyn.getLong("user"));
        }
    }

    public static boolean isShowTenderBeforeBidOpen(DynamicObject billObj) {
        if (!BidOpenStatusEnums.NOOPEN.getValue().equals(billObj.getString("openstatus"))) {
            return true;
        }
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("srctype"));
        return !ExtParameterUtils.convertToBoolen(ExtParameterUtils.getExtParameterValueById("pds_flowconfig", sourceFlowId, "ishidetenderbeforeopen", false, SrmCommonUtil.getPkValue((DynamicObject)billObj)));
    }

    public static void setPriceProByTaxType(String taxType, String decisionType, IFormView view, boolean isVie, boolean isChange) {
        view.setVisible(Boolean.valueOf(false), new String[]{"maxprice", "maxtaxprice", "maxamount", "maxtaxamount"});
        if (Objects.equals(decisionType, "2")) {
            if ("2".equals(taxType)) {
                PdsCommonUtils.setEnable(Arrays.asList("amount", "tieredprice", "maxamount"), view, isChange);
                view.setVisible(Boolean.valueOf(true), new String[]{"maxamount"});
            } else if (Objects.equals("1", taxType)) {
                PdsCommonUtils.setEnable(Arrays.asList("taxamount", "tieredtaxprice", "maxtaxamount"), view, isChange);
                view.setVisible(Boolean.valueOf(true), new String[]{"maxtaxamount"});
            }
        } else if ("2".equals(taxType)) {
            if (isVie) {
                PdsCommonUtils.setEnable(Collections.singletonList("price"), view, isChange);
            } else {
                PdsCommonUtils.setEnable(Arrays.asList("price", "tieredprice", "maxprice"), view, isChange);
                view.setVisible(Boolean.valueOf(true), new String[]{"maxprice"});
            }
        } else if (Objects.equals("1", taxType)) {
            if (isVie) {
                PdsCommonUtils.setEnable(Collections.singletonList("taxprice"), view, isChange);
            } else {
                PdsCommonUtils.setEnable(Arrays.asList("taxprice", "tieredtaxprice", "maxtaxprice"), view, isChange);
                view.setVisible(Boolean.valueOf(true), new String[]{"maxtaxprice"});
            }
        }
    }

    private static void setEnable(List<String> fields, IFormView view, boolean isChange) {
        List<String> fieldList = Arrays.asList("taxprice", "price", "taxamount", "amount", "tieredprice", "tieredtaxprice", "maxprice", "maxtaxprice", "maxamount", "maxtaxamount");
        for (String field : fieldList) {
            if (fields.contains(field)) {
                if (!isChange) continue;
                view.setEnable(Boolean.TRUE, -1, new String[]{field});
                continue;
            }
            view.setEnable(Boolean.FALSE, -1, new String[]{field});
        }
    }

    public static boolean isEqualCollection(Collection a, Collection b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (Object value : a) {
            if (b.contains(value)) continue;
            return false;
        }
        for (Object o : b) {
            if (a.contains(o)) continue;
            return false;
        }
        return true;
    }

    public static Set<String> buildSet(String ... values) {
        HashSet<String> set = new HashSet<String>(values.length);
        for (String value : values) {
            set.add(value);
        }
        return set;
    }

    public static Set<Long> buildSet(Long ... values) {
        HashSet<Long> set = new HashSet<Long>(values.length);
        for (Long value : values) {
            set.add(value);
        }
        return set;
    }

    public static DynamicObject getProjectObjByCompView(IFormView compView) {
        IFormView parentView = compView.getParentView();
        if (Objects.isNull(parentView)) {
            return null;
        }
        if (Objects.equals("ide_formdesigner", parentView.getEntityId())) {
            return null;
        }
        if (PdsCommonUtils.getNotProjectBill().contains(parentView.getEntityId())) {
            return parentView.getModel().getDataEntity().getDynamicObject("project");
        }
        if ("src_quotebillquery".equals(parentView.getEntityId())) {
            return parentView.getModel().getDataEntity().getDynamicObject("projectf7");
        }
        return parentView.getModel().getDataEntity();
    }

    public static long getProjectIdByCompView(IFormView compView) {
        DynamicObject projectObj = PdsCommonUtils.getProjectObjByCompView(compView);
        if (null == projectObj) {
            return 0L;
        }
        return projectObj.getLong("id");
    }

    public static long getSourceFlowIdByCompView(IFormView compView) {
        DynamicObject projectObj = PdsCommonUtils.getProjectObjByCompView(compView);
        if (null == projectObj) {
            return 0L;
        }
        return projectObj.getLong("srctype.id");
    }

    public static String getTaxTypeByCompView(IFormView compView) {
        DynamicObject projectObj = PdsCommonUtils.getProjectObjByCompView(compView);
        if (null == projectObj) {
            return null;
        }
        return projectObj.getString("taxtype");
    }

    public static String getTieredTypeByCompView(IFormView compView) {
        DynamicObject projectObj = PdsCommonUtils.getProjectObjByCompView(compView);
        if (null == projectObj) {
            return null;
        }
        return projectObj.getString("tieredtype");
    }

    public static DynamicObjectCollection cloneCols(DynamicObjectCollection cols) {
        DynamicObjectCollection newCols = new DynamicObjectCollection(cols.getDynamicObjectType(), (Object)cols);
        for (DynamicObject col : cols) {
            DynamicObject newCol = (DynamicObject)OrmUtils.clone((IDataEntityBase)col, (boolean)true, (boolean)true);
            newCols.add((Object)newCol);
        }
        return newCols;
    }

    public static DynamicObjectCollection cloneCols(DynamicObject row, String pro) {
        return PdsCommonUtils.cloneCols(row.getDynamicObjectCollection(pro));
    }

    public static DynamicObjectCollection cloneAttachment(DynamicObject row, String pro) {
        return PdsCommonUtils.cloneCols(row, pro);
    }

    public static DynamicObjectCollection cloneAttachment(DynamicObjectCollection cols) {
        return PdsCommonUtils.cloneCols(cols);
    }

    public static void cleanExcludedFieldValue(DynamicObject newObj, Set<String> excludedFields) {
        List properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)newObj);
        for (String property : properties) {
            if (!excludedFields.contains(property)) continue;
            newObj.set(property, null);
        }
    }

    public static long getProjectIdByProjectNo(String projectNo) {
        if (StringUtils.isBlank((CharSequence)projectNo)) {
            return 0L;
        }
        DynamicObject projectObj = QueryServiceHelper.queryOne((String)"src_project", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)projectNo)});
        if (null == projectObj) {
            return 0L;
        }
        return projectObj.getLong("id");
    }

    public static String getNodeNoByEntityName(String entityName) {
        QFilter qfilter = new QFilter("bizobject.number", "=", (Object)entityName);
        DynamicObject nodeObj = QueryServiceHelper.queryOne((String)"pds_biznode", (String)"number", (QFilter[])qfilter.toArray());
        if (null == nodeObj) {
            return null;
        }
        return nodeObj.getString("number");
    }

    public static long getNodeIdByEntityName(String entityName) {
        QFilter qfilter = new QFilter("bizobject.number", "=", (Object)entityName);
        DynamicObject nodeObj = QueryServiceHelper.queryOne((String)"pds_biznode", (String)"id", (QFilter[])qfilter.toArray());
        if (null == nodeObj) {
            return 0L;
        }
        return nodeObj.getLong("id");
    }

    public static String getNodeEntityNameById(long nodeId) {
        QFilter qfilter = new QFilter("id", "=", (Object)nodeId);
        DynamicObject nodeObj = QueryServiceHelper.queryOne((String)"pds_biznode", (String)"bizobject.number", (QFilter[])qfilter.toArray());
        if (nodeObj != null) {
            return nodeObj.getString("bizobject.number");
        }
        return null;
    }

    public static Map<String, Object> convertParamMap(ExtPluginContext context) {
        if (null == context.getParamMap() || context.getParamMap().size() == 0) {
            return null;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(context.getParamMap().size());
        for (Map.Entry<Object, Object> entry : context.getParamMap().entrySet()) {
            paramMap.put((String)entry.getKey(), entry.getValue());
        }
        return paramMap;
    }

    public static void deleteBillAndComp(DynamicObject billObj) {
        if (null == billObj) {
            return;
        }
        billObj = BusinessDataServiceHelper.loadSingle((Object)billObj.getPkValue(), (String)billObj.getDataEntityType().getName());
        List<String> compKeys = TemplateUtil.getCompKeyList(billObj);
        for (String compKey : compKeys) {
            DynamicObject compObj = TemplateUtil.getCompData(billObj, compKey);
            if (null == compObj) continue;
            DeleteServiceHelper.delete((String)compObj.getDataEntityType().getName(), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)compObj))});
        }
        DeleteServiceHelper.delete((String)billObj.getDataEntityType().getName(), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)billObj))});
    }

    public static void buildOpErrorMessage(OperationResult saveResult, StringBuilder sb) {
        for (IOperateInfo operateInfo : saveResult.getAllErrorOrValidateInfo()) {
            sb.append(operateInfo.getMessage()).append('\n');
        }
    }

    public static Set<Long> getBizRoleIdSetByEntityName(String entityName) {
        QFilter roleFilter = new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getVal());
        roleFilter.and("enable", "=", (Object)true);
        roleFilter.and("entryentity.biznode.bizobject", "=", (Object)entityName);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"pds_bizrole", (String)"id", (QFilter[])roleFilter.toArray());
        if (rows.size() == 0) {
            return null;
        }
        return rows.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
    }

    public static String getPageIdKey(IFormView currentView, String fromEntityName, String toEntityName) {
        if (null == currentView) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(currentView.getPageId());
        sb.append('_');
        sb.append(fromEntityName);
        sb.append('_');
        sb.append(toEntityName);
        sb.append('_');
        sb.append("pageid");
        return sb.toString();
    }

    public static boolean isEqualOrContain(Object sourceObj, String targetStr) {
        if (null == sourceObj || StringUtils.isBlank((CharSequence)targetStr)) {
            return false;
        }
        if (sourceObj instanceof String) {
            return sourceObj.toString().equals(targetStr);
        }
        if (sourceObj instanceof List) {
            return ((List)sourceObj).contains(targetStr);
        }
        if (sourceObj instanceof Set) {
            return ((Set)sourceObj).contains(targetStr);
        }
        return false;
    }

    public static Long[] getPkIds(DynamicObjectCollection rows) {
        List<Long> idList = rows.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        return idList.toArray(new Long[0]);
    }

    public static boolean isShowPurlistItemBeforeOpen(DynamicObject billObj) {
        String openStatus = billObj.getString("openstatus");
        if (!BidOpenStatusEnums.NOOPEN.getValue().equals(openStatus)) {
            return true;
        }
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("srctype"));
        if (ExtParameterUtils.convertToBoolen(ExtParameterUtils.getExtParameterValueById("pds_flowconfig", sourceFlowId, "isShowPurlistItemBeforeOpen", false, SrmCommonUtil.getPkValue((DynamicObject)billObj)))) {
            return true;
        }
        if ("src_aptitudeaudit".equals(billObj.getDataEntityType().getName())) {
            return PdsCommonUtils.isOpenApt(billObj);
        }
        return false;
    }

    public static boolean isOpenApt(DynamicObject billObj) {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)billObj);
        QFilter aptFilter = new QFilter("billid", "=", (Object)projectId);
        aptFilter.and("isaptopen", "=", (Object)true);
        if (PdsCommonUtils.isOpenBySupplier(billObj)) {
            return QueryServiceHelper.exists((String)"src_supplieropen", (QFilter[])aptFilter.toArray());
        }
        return QueryServiceHelper.exists((String)"src_bidopenpackage", (QFilter[])aptFilter.toArray());
    }

    public static DynamicObjectCollection getFieldMapperRows(String number, String sourceEntity, String targetEneity) {
        QFilter qfilter = null;
        if (null != number) {
            qfilter = new QFilter("number", "=", (Object)number);
        } else {
            qfilter = new QFilter("sourcebill", "=", (Object)sourceEntity);
            qfilter.and("targetbill", "=", (Object)targetEneity);
        }
        qfilter.and("status", "=", (Object)BillStatusEnum.AUDIT.getVal());
        qfilter.and("enable", "=", (Object)"1");
        String oderBy = "isdefault desc,number";
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"pds_fieldmapper", (String)"id", (QFilter[])qfilter.toArray(), (String)oderBy);
        if (objs.size() == 0) {
            return null;
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)objs.get(0)).getLong("id"), (String)"pds_fieldmapper");
        return obj.getDynamicObjectCollection("entryentity");
    }

    public static DynamicObjectCollection getFieldMapperRows(String sourceEntity, String targetEneity) {
        return PdsCommonUtils.getFieldMapperRows(null, sourceEntity, targetEneity);
    }

    public static List<String> getPropertiesFromFieldMapper(String number, String sourceEntity, String targetEneity) {
        DynamicObjectCollection rows = PdsCommonUtils.getFieldMapperRows(number, sourceEntity, targetEneity);
        if (null == rows || rows.size() == 0) {
            return null;
        }
        List<String> properties = rows.stream().filter(e -> e.getString("sourcefield").length() > 0).map(e -> e.getString("sourcefield")).collect(Collectors.toList());
        if (null == properties || properties.size() == 0) {
            return null;
        }
        return properties;
    }

    public static List<String> getPropertiesFromFieldMapper(String sourceEntity, String targetEneity) {
        return PdsCommonUtils.getPropertiesFromFieldMapper(null, sourceEntity, targetEneity);
    }

    public static List<String> getPropertiesFromFieldMapper2(String number, String sourceEntity, String targetEneity) {
        DynamicObjectCollection rows = PdsCommonUtils.getFieldMapperRows(number, sourceEntity, targetEneity);
        if (null == rows || rows.size() == 0) {
            return null;
        }
        List<String> properties = rows.stream().filter(e -> e.getString("sourcefield").length() > 0 && e.getString("targetfield").length() > 0).map(e -> e.getString("sourcefield") + '|' + e.getString("targetfield")).collect(Collectors.toList());
        if (null == properties || properties.size() == 0) {
            return null;
        }
        return properties;
    }

    public static List<String> getPropertiesFromFieldMapper2(String sourceEntity, String targetEneity) {
        return PdsCommonUtils.getPropertiesFromFieldMapper2(null, sourceEntity, targetEneity);
    }

    public static OperationResult doOperation(DynamicObject billObj, String operationKey) {
        return PdsCommonUtils.doOperation(billObj, operationKey, null);
    }

    public static OperationResult doOperation(DynamicObject billObj, String operationKey, OperateOption option) {
        if (null == billObj) {
            return null;
        }
        OperationResult result = null;
        if (null == option) {
            option = OperateOption.create();
        }
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("WF", String.valueOf(false));
        try {
            result = OperationServiceHelper.executeOperate((String)operationKey, (String)billObj.getDynamicObjectType().getName(), (Object[])new Long[]{billObj.getLong("id")}, (OperateOption)option);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void setBillNo(String objectName, DynamicObject billObj) {
        String billNo;
        if (!CodeRuleServiceHelper.isExist((String)objectName, (DynamicObject)billObj, null)) {
            return;
        }
        String preBillNo = billNo = billObj.getString("billno");
        if (StringUtils.isBlank((CharSequence)billNo)) {
            billNo = CodeRuleServiceHelper.getNumber((String)objectName, (DynamicObject)billObj, null);
        }
        if (StringUtils.isBlank((CharSequence)billNo)) {
            return;
        }
        long billId = SrmCommonUtil.getPkValue((DynamicObject)billObj);
        for (int i = 0; i < 5; ++i) {
            QFilter billNoFilter = new QFilter("billno", "=", (Object)billNo);
            if (billId > 0L) {
                billNoFilter.and("id", "!=", (Object)billId);
            }
            if (!QueryServiceHelper.exists((String)objectName, (QFilter[])billNoFilter.toArray())) {
                if (null == preBillNo || !preBillNo.equals(billNo)) {
                    billObj.set("billno", (Object)billNo);
                }
                return;
            }
            billNo = CodeRuleServiceHelper.getNumber((String)objectName, (DynamicObject)billObj, null);
        }
    }

    public static void copyDynamicObjectEntryValue(DynamicObjectCollection sourceRows, DynamicObject sourceObj, String sourceEntry, DynamicObject targetObj, String targetEntry, Set<String> excludedFields) {
        PdsCommonUtils.copyDynamicObjectEntryValue(sourceRows, sourceObj, sourceEntry, targetObj, targetEntry, excludedFields, false, false);
    }

    public static void copyDynamicObjectEntryValue(DynamicObjectCollection sourceRows, DynamicObject sourceObj, String sourceEntry, DynamicObject targetObj, String targetEntry, Set<String> excludedFields, boolean isRemoveAll, boolean isCopyEntryId) {
        if (null == sourceRows || sourceRows.size() == 0) {
            sourceRows = sourceObj.getDynamicObjectCollection(sourceEntry);
        }
        if (null == sourceRows || sourceRows.size() == 0) {
            return;
        }
        DynamicObjectCollection targetRows = targetObj.getDynamicObjectCollection(targetEntry);
        if (isRemoveAll) {
            targetRows.removeAll((Collection)targetRows);
        }
        List rowProperties = null;
        int seq = 1;
        for (DynamicObject sourceRow : sourceRows) {
            DynamicObject targetRow = targetRows.addNew();
            if (null == rowProperties) {
                rowProperties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)targetRow);
            }
            PdsCommonUtils.copyDynamicObjectValue(sourceRow, targetRow, rowProperties, excludedFields, seq++);
            if (!isCopyEntryId) continue;
            targetRow.set(targetEntry + '_' + "entryid", sourceRow.getPkValue());
        }
    }

    public static void setObjectValueFromMap(DynamicObject obj, Map<String, Object> valueMap) {
        if (null == valueMap || valueMap.size() == 0) {
            return;
        }
        for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
            obj.set(entry.getKey(), entry.getValue());
        }
    }

    public static String getLoginIp() {
        String loginIP = StringUtils.trim((String)RequestContext.get().getLoginIP());
        return PdsCommonUtils.getLoginIp(loginIP);
    }

    public static String getLoginIp(String loginIP) {
        if (StringUtils.isBlank((CharSequence)loginIP)) {
            return null;
        }
        String[] loginIPs = loginIP.split("\\,");
        return loginIPs[0];
    }

    public static Set<Long> object2Set(Object object) {
        JSONArray jsonObjs = JSONArray.fromObject((Object)object);
        if (null == jsonObjs || jsonObjs.size() == 0) {
            return null;
        }
        HashSet<Long> idSet = new HashSet<Long>(jsonObjs.size());
        for (int i = 0; i < jsonObjs.size(); ++i) {
            Object obj = jsonObjs.get(i);
            if (null == obj || "null".equals(obj.toString())) continue;
            idSet.add(PdsCommonUtils.object2Long(jsonObjs.get(i)));
        }
        return idSet;
    }

    public static boolean isSaveStatus(DynamicObject billObj) {
        if (null == billObj) {
            return true;
        }
        String status = PdsCommonUtils.object2String(billObj.get("billstatus"), BillStatusEnum.SAVE.getVal());
        return BillStatusEnum.SAVE.getVal().equals(status);
    }

    public static boolean isValidBillType(IFormView view) {
        if (view == null) {
            return false;
        }
        return PdsCommonUtils.isValidBillType(view.getEntityId());
    }

    public static boolean isValidBillType(String entityId) {
        return !"bos_list".equals(entityId) && !"src_apphome".equals(entityId) && !"wf_msg_center".equals(entityId) && !"bos_devportal_bizpagelist".equals(entityId) && !"ide_formdesigner".equals(entityId);
    }

    public static Set<Long> getBiddersByRoleNumber(long projectId, String number) {
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("bizrole.number", "=", (Object)number);
        qfilter.and("entrystatus", "!=", (Object)"E");
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_memberclarify", (String)"bidder.id", (QFilter[])qfilter.toArray());
        if (null == rows || rows.size() == 0) {
            return null;
        }
        return rows.stream().map(e -> e.getLong("bidder.id")).collect(Collectors.toSet());
    }

    public static String buildString(Object ... args) {
        StringBuilder sb = new StringBuilder();
        for (Object arg : args) {
            if (StringUtils.isBlank((Object)arg)) continue;
            sb.append(arg);
        }
        return sb.toString();
    }

    public static OperationResult auditCurrentNode(long projectId, DynamicObject projectObj, String entityName) {
        String nodeNumber = PdsCommonUtils.getNodeNoByEntityName(entityName);
        if (!PdsFlowConfigUtils.existsSpecificNode(projectObj, nodeNumber)) {
            return null;
        }
        OperationResult result = null;
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)entityName);
        if (BillStatusEnum.SAVE.getVal().equals(billObj.getString("billstatus"))) {
            result = PdsCommonUtils.doOperation(billObj, "submit");
        }
        if (null != result && result.isSuccess()) {
            result = PdsCommonUtils.doOperation(billObj, "audit");
        }
        return result;
    }

    public static OperationResult unAuditCurrentNode(long projectId, DynamicObject projectObj, String entityName) {
        String nodeNumber = PdsCommonUtils.getNodeNoByEntityName(entityName);
        if (!PdsFlowConfigUtils.existsSpecificNode(projectObj, nodeNumber)) {
            return null;
        }
        OperationResult result = null;
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)entityName);
        if (BillStatusEnum.SUBMIT.getVal().equals(billObj.getString("billstatus"))) {
            result = PdsCommonUtils.doOperation(billObj, "unsubmit");
        } else if (BillStatusEnum.AUDIT.getVal().equals(billObj.getString("billstatus"))) {
            result = PdsCommonUtils.doOperation(billObj, "unaudit");
        }
        return result;
    }

    public static boolean isByPackage(DynamicObject projectObj) {
        if (null == projectObj) {
            return false;
        }
        String manageType = PdsCommonUtils.object2String(projectObj.get("managetype"), "1");
        return "2".equals(manageType);
    }

    public static String getSup_Pkg_Key(DynamicObject obj, boolean isByPackage) {
        return PdsCommonUtils.getSup_Pkg_Key(obj, isByPackage, 0L, 0L);
    }

    public static String getSup_Pkg_Key(DynamicObject obj, boolean isByPackage, long supplierId, long packageId) {
        supplierId = supplierId > 0L ? supplierId : obj.getLong("supplier.id");
        StringBuilder sb = new StringBuilder(String.valueOf(supplierId));
        if (isByPackage) {
            packageId = packageId > 0L ? packageId : obj.getLong("package.id");
            sb.append('_').append(String.valueOf(packageId));
        }
        return sb.toString();
    }

    public static String generateRandomCode(int codeLength, Set<String> existCodeSet) {
        String newCode;
        if (codeLength <= 0) {
            codeLength = 4;
        }
        StringBuilder sb = new StringBuilder().append('1');
        for (int i = 0; i < codeLength - 1; ++i) {
            sb.append('0');
        }
        int min = Integer.parseInt(sb.toString());
        int max = Integer.parseInt(sb.append('0').toString());
        while ((newCode = String.valueOf(RandomUtils.getRandomInt(max - min + min + 1, new SecureRandom()))).length() != codeLength || !existCodeSet.add(newCode)) {
        }
        return newCode;
    }

    public static void copyDynamicObjectValueByFieldMap(String sourceEntityId, long sourceId, Map<String, DynamicObject> sourceMap, String targetEntityId, long targetId, Map<String, DynamicObject> targetMap) {
        String targetKey;
        DynamicObject targetObj;
        List<String> propertyMap = PdsCommonUtils.getPropertiesFromFieldMapper2(sourceEntityId, targetEntityId);
        if (null == propertyMap || propertyMap.size() == 0) {
            return;
        }
        String sourceKey = PdsCommonUtils.buildString(sourceId, "_", sourceEntityId);
        DynamicObject sourceObj = sourceMap.get(sourceKey);
        if (null == sourceObj) {
            sourceObj = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)sourceEntityId);
            sourceMap.put(sourceKey, sourceObj);
        }
        if (null == (targetObj = targetMap.get(targetKey = PdsCommonUtils.buildString(targetId, "_", targetEntityId)))) {
            targetObj = BusinessDataServiceHelper.loadSingle((Object)targetId, (String)targetEntityId);
            targetMap.put(targetKey, targetObj);
        }
        PdsCommonUtils.copyDynamicObjectValue2(sourceObj, targetObj, propertyMap, Collections.emptySet(), -1, null);
    }

    public static Map<String, String> getMustInputPriceOrAmountField(String taxType, String decisionTpe, String prefix, String subfix) {
        HashMap<String, String> fieldMap = new HashMap<String, String>(2);
        if ("2".equals(taxType)) {
            if ("1".equals(decisionTpe)) {
                fieldMap.put("fieldid", prefix + "price" + subfix);
                fieldMap.put("fieldname", ResManager.loadKDString((String)"\u672a\u7a0e\u5355\u4ef7", (String)"PdsCommonUtils_8", (String)"scm-pds-common", (Object[])new Object[0]));
            } else {
                fieldMap.put("fieldid", prefix + "amount" + subfix);
                fieldMap.put("fieldname", ResManager.loadKDString((String)"\u672a\u7a0e\u91d1\u989d", (String)"PdsCommonUtils_9", (String)"scm-pds-common", (Object[])new Object[0]));
            }
        } else if ("1".equals(decisionTpe)) {
            fieldMap.put("fieldid", prefix + "taxprice" + subfix);
            fieldMap.put("fieldname", ResManager.loadKDString((String)"\u542b\u7a0e\u5355\u4ef7", (String)"PdsCommonUtils_10", (String)"scm-pds-common", (Object[])new Object[0]));
        } else {
            fieldMap.put("fieldid", prefix + "taxamount" + subfix);
            fieldMap.put("fieldname", ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"PdsCommonUtils_11", (String)"scm-pds-common", (Object[])new Object[0]));
        }
        return fieldMap;
    }

    public static Date object2Date(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        return null;
    }

    public static DynamicObject object2DynamicObject(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof DynamicObject) {
            return (DynamicObject)obj;
        }
        return null;
    }

    public static DynamicObjectCollection object2DynamicObjectCollection(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof DynamicObjectCollection) {
            return (DynamicObjectCollection)obj;
        }
        if (obj instanceof DynamicObject[]) {
            DynamicObject[] objs = (DynamicObject[])obj;
            DynamicObjectCollection rows = new DynamicObjectCollection();
            for (DynamicObject row : objs) {
                rows.add((Object)row);
            }
            return rows;
        }
        return null;
    }

    public static Set<Long> getMultiBaseDataIdSet(DynamicObjectCollection rows) {
        if (null == rows || rows.size() == 0) {
            return null;
        }
        try {
            return rows.stream().map(e -> e.getLong("fbasedataid.id")).collect(Collectors.toSet());
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static String getBaseDataName(DynamicObject obj) {
        if (null == obj) {
            return "";
        }
        try {
            return obj.getString("name");
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getMultiBaseDataName(DynamicObjectCollection rows) {
        if (null == rows || rows.size() == 0) {
            return "";
        }
        try {
            Set nameSet = rows.stream().map(e -> e.getString("fbasedataid.name")).collect(Collectors.toSet());
            if (null != nameSet && nameSet.size() > 0) {
                return nameSet.toString();
            }
            return "";
        }
        catch (Exception e2) {
            return "";
        }
    }

    public static DynamicObject getBillObjFromContext(ExtPluginContext context, long billId, String entityName) {
        DynamicObject billObj = null;
        if (null != context.getParamMap().get("context_billid")) {
            billObj = context.getBillObj();
        } else {
            billObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)entityName);
            context.setBillObj(billObj);
            context.getParamMap().put("context_billid", billId);
        }
        return billObj;
    }

    public static List<Long> getSupplierByUserOfBizPartner() {
        List<Long> supplierIds = null;
        try {
            supplierIds = BizPartnerUtil.getSupplierByUserOfBizPartner();
        }
        catch (Exception e) {
            supplierIds = Collections.emptyList();
        }
        return supplierIds;
    }

    public static void updateFlowParam(long flowId, long paramId, Object value) {
        DynamicObject flowObj = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)"pds_flowconfig");
        DynamicObjectCollection rows = flowObj.getDynamicObjectCollection("entryentity_para");
        boolean isChanged = false;
        for (DynamicObject row : rows) {
            if (paramId != row.getLong("parameter.id")) continue;
            row.set("paramvalue", value);
            isChanged = true;
            break;
        }
        if (!isChanged) {
            DynamicObject row = rows.addNew();
            row.set("parameter", (Object)paramId);
            row.set("paramvalue", value);
        }
        PdsCommonUtils.saveDynamicObjects(flowObj);
        PdsCommonUtils.removeFolwInstance(flowObj);
    }

    public static void updateFlowParam(String flowNumber, String paramNumber, Object value) {
        long flowId = PdsCommonUtils.getBasedataIdByNumber("pds_flowconfig", flowNumber);
        long paramId = PdsCommonUtils.getBasedataIdByNumber("pds_extdata", paramNumber);
        PdsCommonUtils.updateFlowParam(flowId, paramId, value);
    }

    public static void removeFolwInstance(DynamicObject flowObj) {
        String id = flowObj.getString("id");
        String number = flowObj.getString("number");
        PdsObjectPools.removeInstance("pds_flowconfig|" + id);
        PdsObjectPools.removeInstance("pds_flowconfig|" + number);
        PdsObjectPools.removeInstance("pds_flowconfig_" + id);
        PdsObjectPools.removeInstance("pds_flowconfig_" + number);
    }

    public static void deleteDataByProject(String entityName, String projectField, long projectId, String projectNo) {
        QFilter delFilter = null;
        delFilter = projectId > 0L ? new QFilter(projectField, "=", (Object)projectId) : new QFilter(projectField + '.' + "billno", "=", (Object)projectNo);
        DeleteServiceHelper.delete((String)entityName, (QFilter[])delFilter.toArray());
    }

    public static void updateObjectValue(String entityName, QFilter qfilter, Map<String, Object> paramMap) {
        String selectFields = paramMap.keySet().toString().replace("[", "").replace("]", "");
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qfilter.toArray());
        if (rows == null || rows.length == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                row.set(entry.getKey(), entry.getValue());
            }
        }
        PdsCommonUtils.saveDynamicObjects(rows);
    }

    public static OperationResult doOperation(String entityName, Long[] billIds, String operationKey, OperateOption option) {
        if (null == billIds || billIds.length == 0) {
            return null;
        }
        OperationResult result = null;
        if (null == option) {
            option = OperateOption.create();
        }
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("WF", String.valueOf(false));
        try {
            result = OperationServiceHelper.executeOperate((String)operationKey, (String)entityName, (Object[])billIds, (OperateOption)option);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean isContainsAll(Set<Long> idSet1, Set<Long> idSet2) {
        if (idSet1 == null || idSet1.size() == 0 || idSet2 == null || idSet2.size() == 0) {
            return false;
        }
        return idSet1.containsAll(idSet2);
    }

    public static boolean isContainsAll(DynamicObject obj, String fieldName1, String fieldName2) {
        if (obj.getDynamicObjectType().getProperties().containsKey((Object)fieldName1) && obj.getDynamicObjectType().getProperties().containsKey((Object)fieldName2)) {
            return PdsCommonUtils.isContainsAll(MultiBasedataUtils.getBasedataIdSet(obj, fieldName1), MultiBasedataUtils.getBasedataIdSet(obj, fieldName2));
        }
        return false;
    }

    public static ExtFilterContext convertExtFilterContext(Object contextObj) {
        if (contextObj instanceof ExtFilterContext) {
            return (ExtFilterContext)contextObj;
        }
        ExtFilterContext fliterContext = new ExtFilterContext();
        if (contextObj instanceof ExtPluginContext) {
            ExtPluginContext extContext = (ExtPluginContext)contextObj;
            fliterContext.setProjectObj(null == extContext.getProjectObj() ? extContext.getBillObj() : extContext.getProjectObj());
            fliterContext.setBillObj(null == extContext.getBillObj() ? extContext.getProjectObj() : extContext.getBillObj());
            fliterContext.setParamMap(PdsCommonUtils.convertParamMap(extContext));
        }
        return fliterContext;
    }

    public static void setTableValueSetterValue(TableValueSetter ts, DynamicObject sourceObj, List<String> properties, int index) {
        for (String pro : properties) {
            if (null == sourceObj.getDynamicObjectType().getProperty(pro)) continue;
            if (sourceObj.get(pro) instanceof DynamicObject) {
                ts.set(pro, (Object)sourceObj.getLong(pro + '.' + "id"), index);
                continue;
            }
            if (sourceObj.get(pro) instanceof DynamicObjectCollection) {
                ts.set(pro, (Object)PdsCommonUtils.cloneCols(sourceObj, pro), index);
                continue;
            }
            ts.set(pro, sourceObj.get(pro), index);
        }
        ts.set("id", sourceObj.getPkValue(), index);
    }

    public static DynamicObject getEntryEntitySelectRow(IFormView view, String entityName) {
        int index = PdsCommonUtils.getEntryEntitySelectIndex(view, entityName);
        if (index < 0) {
            return null;
        }
        return view.getModel().getEntryRowEntity(entityName, index);
    }

    public static int getEntryEntitySelectIndex(IFormView view, String entityName) {
        EntryGrid entryGrid = (EntryGrid)view.getControl(entityName);
        int[] indexs = entryGrid.getSelectRows();
        if (indexs.length == 0) {
            return 0;
        }
        return indexs[0];
    }

    public static <K, T> void putMap_SetValue(Map<K, Set<T>> valueMap, K key, Set<T> values) {
        Set<Object> valueSet = null == valueMap.get(key) ? new HashSet() : valueMap.get(key);
        valueSet.addAll(values);
        valueMap.put(key, valueSet);
    }

    public static <K, T> void putMap_SetValue(Map<K, Set<T>> valueMap, K key, T value) {
        Set<Object> valueSet = null == valueMap.get(key) ? new HashSet() : valueMap.get(key);
        valueSet.add(value);
        valueMap.put(key, valueSet);
    }

    public static <K, T> void putMap_ListValue(Map<K, List<T>> valueMap, K key, List<T> values) {
        List<Object> valueSet = null == valueMap.get(key) ? new ArrayList() : valueMap.get(key);
        valueSet.addAll(values);
        valueMap.put(key, valueSet);
    }

    public static <K, T> void putMap_ListValue(Map<K, List<T>> valueMap, K key, T value) {
        List<Object> valueSet = null == valueMap.get(key) ? new ArrayList() : valueMap.get(key);
        valueSet.add(value);
        valueMap.put(key, valueSet);
    }

    public static <T> Set<T> buildSet(Set<T> valueSet) {
        HashSet<T> newValueSet = new HashSet<T>();
        newValueSet.addAll(valueSet);
        return newValueSet;
    }

    public static <T> List<T> buildList(List<T> valueList) {
        ArrayList<T> newValueList = new ArrayList<T>();
        newValueList.addAll(valueList);
        return newValueList;
    }

    public static boolean isTnd(String appId, String userType) {
        return "tnd".equals(appId) || "sw".equals(appId) || "3".equals(userType);
    }
}

