/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.function.IGetValFunction;
import kd.scm.pds.common.util.PdsMetadataUtil;

public class PdsCompConfigUtil {
    public static DynamicObject getCompConfig(String entityKey, String compKey) {
        DynamicObject bidComp;
        QFilter bidCompfilter = new QFilter("enable", "=", (Object)"1");
        if (null != entityKey) {
            bidCompfilter.and("biznode.bizobject", "=", (Object)entityKey);
        }
        if (null != compKey) {
            bidCompfilter.and("bizobject.number", "=", (Object)compKey);
        }
        if (null == (bidComp = BusinessDataServiceHelper.loadSingle((String)"pds_compreg", (String)"id,biznode,bizobject", (QFilter[])new QFilter[]{bidCompfilter}))) {
            return null;
        }
        String selectFields = "id";
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"pds_compconfig", (String)"entryentity", (boolean)false);
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        DynamicObject bizNode = bidComp.getDynamicObject("biznode");
        if (null != bizNode) {
            filter.and("biznode", "=", (Object)Long.parseLong(bizNode.getPkValue().toString()));
        }
        filter.and("component", "=", (Object)Long.parseLong(bidComp.getPkValue().toString()));
        DynamicObject compConfig = BusinessDataServiceHelper.loadSingle((String)"pds_compconfig", (String)selectFields, (QFilter[])new QFilter[]{filter});
        return compConfig;
    }

    public static DynamicObject getCompConfig(DynamicObject obj, String compKey, List<String> groupPros, IGetValFunction getValFunction) {
        DynamicObject[] compConfigs = PdsCompConfigUtil.getCompconfigObjs(obj, compKey);
        if (null == compConfigs) {
            return null;
        }
        List<String> proValList = PdsCompConfigUtil.getVals(obj, groupPros, true, getValFunction);
        int maxMatchCount = 0;
        DynamicObject compConfig = null;
        Map<String, DynamicObject> groupKeyCompConfigMap = PdsCompConfigUtil.groupCompConfig(compConfigs, groupPros);
        for (Map.Entry<String, DynamicObject> configEntry : groupKeyCompConfigMap.entrySet()) {
            String groupKey = configEntry.getKey();
            String[] vals = groupKey.split("_");
            int matchCount = 0;
            int nullCount = 0;
            boolean isAllNull = true;
            for (int i = 0; i < proValList.size(); ++i) {
                boolean isMatch = false;
                if (proValList.get(i).equals(vals[i])) {
                    ++matchCount;
                    isMatch = true;
                }
                if (!"null".equals(vals[i])) {
                    isAllNull = false;
                    continue;
                }
                if (isMatch) continue;
                ++nullCount;
            }
            if (maxMatchCount < matchCount && matchCount + nullCount == proValList.size()) {
                maxMatchCount = matchCount;
                compConfig = configEntry.getValue();
                continue;
            }
            if (maxMatchCount != 0 || matchCount != 0 || !isAllNull) continue;
            compConfig = configEntry.getValue();
        }
        return compConfig;
    }

    public static DynamicObject getCompConfig(DynamicObject obj, String compKey, List<String> groupPros) {
        return PdsCompConfigUtil.getCompConfig(obj, compKey, groupPros, null);
    }

    public static DynamicObject getCompConfig(DynamicObject obj, String compKey) {
        List<String> groupPros = PdsCompConfigUtil.getGroupKeys();
        return PdsCompConfigUtil.getCompConfig(obj, compKey, groupPros);
    }

    public static DynamicObject[] getCompconfigObjs(DynamicObject obj, String compKey) {
        DynamicObject bidComp;
        if (null == obj) {
            return null;
        }
        String entityKey = obj.getDynamicObjectType().getName();
        QFilter bidCompfilter = new QFilter("enable", "=", (Object)"1");
        if (null != entityKey) {
            bidCompfilter.and("biznode.bizobject", "=", (Object)entityKey);
        }
        if (null != compKey) {
            bidCompfilter.and("bizobject.number", "=", (Object)compKey);
        }
        if (null == (bidComp = BusinessDataServiceHelper.loadSingle((String)"pds_compreg", (String)"id,biznode,bizobject", (QFilter[])new QFilter[]{bidCompfilter}))) {
            return null;
        }
        String selectFields = DynamicObjectUtil.getSelectfields((String)"pds_compconfig", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"pds_compconfig", (String)"entryentity", (boolean)false);
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        DynamicObject bizNode = bidComp.getDynamicObject("biznode");
        if (null != bizNode) {
            filter.and("biznode", "=", (Object)Long.parseLong(bizNode.getPkValue().toString()));
        }
        filter.and("component", "=", (Object)Long.parseLong(bidComp.getPkValue().toString()));
        DynamicObject[] compConfigs = BusinessDataServiceHelper.load((String)"pds_compconfig", (String)selectFields, (QFilter[])new QFilter[]{filter});
        if (compConfigs.length == 0) {
            return null;
        }
        return compConfigs;
    }

    public static Map<String, DynamicObject> groupCompConfig(DynamicObject[] compConfigs, List<String> groupPros) {
        HashMap<String, DynamicObject> groupKeyCompConfigMap = new HashMap<String, DynamicObject>(8);
        for (DynamicObject compConfig : compConfigs) {
            List<String> vals = PdsCompConfigUtil.getVals(compConfig, groupPros, false);
            StringBuilder groupKey = new StringBuilder();
            for (String val : vals) {
                if (groupKey.length() > 0) {
                    groupKey.append('_');
                    groupKey.append(val);
                    continue;
                }
                groupKey.append(val);
            }
            groupKeyCompConfigMap.put(groupKey.toString(), compConfig);
        }
        return groupKeyCompConfigMap;
    }

    private static List<String> getVals(DynamicObject obj, List<String> groupPros, boolean isBill, IGetValFunction getValFunction) {
        if (null == getValFunction) {
            getValFunction = PdsCompConfigUtil.getFunction(PdsCompConfigUtil.getSpecialFields(), PdsCompConfigUtil.getSpecialBills());
        }
        ArrayList<String> proValList = new ArrayList<String>(16);
        for (int j = 0; j < groupPros.size(); ++j) {
            String proName = groupPros.get(j);
            Object proValObj = null;
            String proVal = "null";
            try {
                proValObj = isBill && "purchaser".equals(proName) ? Long.valueOf(RequestContext.get().getCurrUserId()) : obj.get(groupPros.get(j));
                proVal = null != proValObj && proValObj instanceof DynamicObject ? String.valueOf(((DynamicObject)proValObj).getPkValue()) : String.valueOf(proValObj);
            }
            catch (Exception e) {
                BizLog.log((String)e.getMessage());
            }
            proVal = getValFunction.getVal(obj, proName, proVal);
            proValList.add(proVal.trim().length() == 0 ? "null" : proVal);
        }
        return proValList;
    }

    private static List<String> getVals(DynamicObject obj, List<String> groupPros, boolean isBill) {
        return PdsCompConfigUtil.getVals(obj, groupPros, isBill, null);
    }

    public static List<String> getGroupKeys() {
        ArrayList<String> groupPros = new ArrayList<String>();
        groupPros.add("sourcetype");
        groupPros.add("sourceclass");
        groupPros.add("srctype");
        groupPros.add("purdept");
        groupPros.add("purchaser");
        groupPros.add("negotiatetype");
        return groupPros;
    }

    public static List<String> getVisiblePros(DynamicObject obj, String entityKey, String entryKey) {
        return PdsCompConfigUtil.getPros(obj, entityKey, entryKey, Boolean.TRUE, null);
    }

    public static List<String> getEditablePros(DynamicObject obj, String entityKey, String entryKey) {
        return PdsCompConfigUtil.getPros(obj, entityKey, entryKey, Boolean.TRUE, Boolean.TRUE);
    }

    private static List<String> getPros(DynamicObject obj, String entityKey, String entryKey, Boolean isVisable, Boolean isEditable) {
        DynamicObject compConfig = PdsCompConfigUtil.getCompConfig(obj, entityKey);
        ArrayList<String> proList = new ArrayList<String>();
        if (null == compConfig) {
            return proList;
        }
        Map<String, String> propetiesMap = PdsMetadataUtil.getProMap(entityKey);
        DynamicObjectCollection cols = compConfig.getDynamicObjectCollection("entryentity");
        for (DynamicObject col : cols) {
            boolean curIsEditable;
            boolean curIsVisible;
            String fieldId = col.getString("fieldid");
            if (null == fieldId || null == propetiesMap.get(fieldId)) continue;
            String[] fieldKeys = fieldId.split("\\.");
            String fieldKey = null;
            String fieldEntryKey = null;
            if (fieldKeys.length > 1) {
                fieldEntryKey = fieldKeys[0];
                fieldKey = fieldKeys[1];
            } else {
                fieldKey = fieldId;
            }
            if (null != isVisable && isVisable.booleanValue() && !(curIsVisible = col.getBoolean("isvisible")) || null != isEditable && isEditable.booleanValue() && !(curIsEditable = col.getBoolean("iseditable"))) continue;
            if (null != entryKey) {
                if (!entryKey.equals(fieldEntryKey)) continue;
                proList.add(fieldKey);
                continue;
            }
            proList.add(fieldKey);
        }
        return proList;
    }

    public static Map<String, String> getMustInputValByCompConfig(Object configId) {
        HashMap<String, String> mustInputValMap = new HashMap<String, String>(8);
        DynamicObject compConfigObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(configId.toString()), (String)"pds_compconfig");
        if (null == compConfigObj) {
            return mustInputValMap;
        }
        DynamicObjectCollection cols = compConfigObj.getDynamicObjectCollection("entryentity");
        String comKey = compConfigObj.getString("component.bizobject.number");
        Map<String, String> propetiesLinkMap = PdsMetadataUtil.getProMap(comKey);
        for (DynamicObject col : cols) {
            boolean isVisiable = col.getBoolean("isvisible");
            boolean isMustInput = col.getBoolean("ismustinput");
            if (!isVisiable || !isMustInput) continue;
            String fieldId = col.getString("fieldid");
            String fieldName = col.getString("fieldname");
            String metaName = propetiesLinkMap.get(fieldId);
            fieldName = StringUtils.isBlank((CharSequence)metaName) ? fieldName : metaName;
            String displayName = col.getString("displayname");
            if (!StringUtils.isBlank((CharSequence)displayName)) {
                String[] fieldsKey = fieldName.split("\\.");
                String prefix = "";
                if (fieldsKey.length > 1) {
                    prefix = fieldsKey[0];
                    displayName = prefix + '.' + displayName;
                }
            }
            fieldName = StringUtils.isBlank((CharSequence)displayName) ? fieldName : displayName;
            mustInputValMap.put(fieldId, fieldName);
        }
        return mustInputValMap;
    }

    public static boolean isValidate(Object proVal, String fieldKey) {
        boolean isValidate = true;
        if (proVal instanceof Long) {
            Long longVal = (Long)proVal;
            if (longVal == 0L) {
                isValidate = false;
            }
        } else if (proVal instanceof Integer) {
            Integer intVal = (Integer)proVal;
            if (intVal == 0) {
                isValidate = false;
            }
        } else if (proVal instanceof BigDecimal) {
            BigDecimal decimalVal = (BigDecimal)proVal;
            if (decimalVal.compareTo(BigDecimal.ZERO) == 0) {
                isValidate = false;
            }
        } else if (proVal instanceof MulBasedataDynamicObjectCollection) {
            MulBasedataDynamicObjectCollection cols = (MulBasedataDynamicObjectCollection)proVal;
            if (cols.size() == 0) {
                isValidate = false;
            }
        } else if (null == proVal || String.valueOf(proVal).trim().length() == 0) {
            isValidate = false;
        }
        return isValidate;
    }

    public static boolean isValidate(Object proVal, IFormView view, String fieldKey) {
        return PdsCompConfigUtil.isValidate(proVal, fieldKey);
    }

    public static List<String> getPros(DynamicObject obj, String compKey, String compEntryKey, String pro, boolean val) {
        DynamicObject compConfig = PdsCompConfigUtil.getCompConfig(obj, compKey);
        ArrayList<String> proList = new ArrayList<String>();
        if (null == compConfig) {
            return proList;
        }
        return PdsCompConfigUtil.getProsByCompConfig(compConfig, compKey, compEntryKey, pro, val);
    }

    public static List<String> getProsByCompConfig(DynamicObject compConfig, String compKey, String compEntryKey, String pro, boolean val) {
        ArrayList<String> proList = new ArrayList<String>();
        if (null == compConfig) {
            return proList;
        }
        Map<String, String> propetiesMap = PdsMetadataUtil.getProMap(compKey);
        DynamicObjectCollection cols = compConfig.getDynamicObjectCollection("entryentity");
        for (DynamicObject col : cols) {
            boolean proVal;
            String fieldId = col.getString("fieldid");
            if (null == fieldId || null == propetiesMap.get(fieldId)) continue;
            String[] fieldKeys = fieldId.split("\\.");
            String fieldKey = null;
            String fieldEntryKey = null;
            if (fieldKeys.length > 1) {
                fieldEntryKey = fieldKeys[0];
                fieldKey = fieldKeys[1];
            } else {
                fieldKey = fieldId;
            }
            if (!(proVal = col.getBoolean(pro)) == val) continue;
            if (null != compEntryKey) {
                if (!compEntryKey.equals(fieldEntryKey)) continue;
                proList.add(fieldKey);
                continue;
            }
            proList.add(fieldKey);
        }
        return proList;
    }

    public static boolean isTemplateChanged(IFormView compView) {
        String param = (String)compView.getFormShowParameter().getCustomParam("isTemplateChanged");
        return null != param && "1".equals(param);
    }

    public static boolean parentIsProject(IFormView compView) {
        IFormView parentView = compView.getParentView();
        if (parentView == null) {
            return false;
        }
        return Objects.equals(parentView.getEntityId(), "src_project");
    }

    public static IGetValFunction getFunction(final Set<String> fieldSet, final Set<String> billSet) {
        return new IGetValFunction(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getVal(DynamicObject obj, String pro, String val) {
                DynamicObject projectObj;
                String entityKey = obj.getDataEntityType().getName();
                Object proValObj = val;
                String proVal = val;
                if (fieldSet.contains(pro) && billSet.contains(entityKey) && null != (projectObj = obj.getDynamicObject("project"))) {
                    proValObj = projectObj.get(pro);
                }
                proVal = null != proValObj && proValObj instanceof DynamicObject ? String.valueOf(((DynamicObject)proValObj).getPkValue()) : String.valueOf(proValObj);
                return proVal;
            }
        };
    }

    public static Set<String> getSpecialFields() {
        HashSet<String> fieldSet = new HashSet<String>(4);
        fieldSet.add("sourcetype");
        fieldSet.add("sourceclass");
        fieldSet.add("srctype");
        return fieldSet;
    }

    public static Set<String> getSpecialBills() {
        HashSet<String> billSet = new HashSet<String>(4);
        billSet.add("src_negotiatebill");
        billSet.add("tnd_tenderbill");
        billSet.add("tnd_quotebill");
        return billSet;
    }
}

