/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.costdetail.PdsCostDetailCalcTotalAmount;
import kd.scm.pds.common.costdetail.PdsCostDetailUpdatePurlist;
import kd.scm.pds.common.enums.QuoteTurnsEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.ListSelectUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class PdsCostDetailUtils {
    public static void handleCostDetail(String entityName, DynamicObject[] rows, boolean isAudit) {
        Set<Long> idSet = Arrays.asList(rows).stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        PdsCostDetailUtils.handleCostDetail(entityName, idSet, isAudit);
    }

    public static void handleCostDetail(String entityName, DynamicObjectCollection rows, boolean isAudit) {
        Set<Long> idSet = rows.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        PdsCostDetailUtils.handleCostDetail(entityName, idSet, isAudit);
    }

    private static void handleCostDetail(String entityName, Set<Long> idSet, boolean isAudit) {
        QFilter qfilter = new QFilter("id", "in", idSet);
        DynamicObject[] costRows = BusinessDataServiceHelper.load((String)entityName, (String)"billstatus", (QFilter[])qfilter.toArray());
        String billStatus = BillStatusEnum.SAVE.getVal();
        if (isAudit) {
            billStatus = BillStatusEnum.AUDIT.getVal();
        }
        for (DynamicObject costRow : costRows) {
            costRow.set("billstatus", (Object)billStatus);
        }
        PdsCommonUtils.saveDynamicObjects(costRows);
    }

    public static Map<String, Object> getParamMap(DynamicObject billObj) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        paramMap.put("category", billObj.get("category.id"));
        paramMap.put("purlist", billObj.get("purlist.id"));
        DynamicObject projectObj = billObj.getDynamicObject("project");
        if (null != projectObj) {
            paramMap.put("project", projectObj.get("id"));
            paramMap.put("sourcetype", projectObj.get("sourcetype.id"));
            paramMap.put("srctype", projectObj.get("srctype.id"));
        }
        return paramMap;
    }

    public static void calcTotalAmount(DynamicObject billObj) {
        ExtPluginContext context = new ExtPluginContext();
        context.setBillObj(billObj);
        context.setEntityId(billObj.getDataEntityType().getName());
        ExtPluginFactory.executeExtplugin(PdsCostDetailCalcTotalAmount.class.getSimpleName(), context, true);
    }

    public static void updatePurlistValue(IFormView view) {
        DynamicObject billObj = view.getModel().getDataEntity();
        if (billObj.getLong("costdetailtpl.id") == 0L) {
            return;
        }
        if (view.getEntityId().equals("tnd_costdetail") && billObj.getBigDecimal("sumamount").compareTo(BigDecimal.ZERO) == 0 && billObj.getBigDecimal("sumtaxamount").compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        ExtPluginContext context = ExtPluginFactory.createContext(view, null, false);
        ExtPluginFactory.executeExtplugin(PdsCostDetailUpdatePurlist.class.getSimpleName(), context, true);
    }

    public static long getCostDetailBillId(String pEntityName, String entityName, DynamicObject purlistObj) {
        if (!("src_negotiatebill".equals(pEntityName) || "src_decision".equals(pEntityName) || "tnd_costdetail".equals(entityName))) {
            return 0L;
        }
        if ("src_negotiatebill".equals(pEntityName)) {
            return purlistObj.getLong("srcentryid");
        }
        String turns = purlistObj.getString("turns");
        if ("tnd_costdetail".equals(entityName) && !QuoteTurnsEnums.NEGOTIATE00.getValue().equals(turns)) {
            return purlistObj.getLong("srcentryid");
        }
        return purlistObj.getLong("purlist.id");
    }

    public static Map<Long, Integer> getEntryId_IndexMap(DynamicObjectCollection rows) {
        HashMap<Long, Integer> entryId_IndexMap = new HashMap<Long, Integer>(rows.size());
        int index = 0;
        for (DynamicObject row : rows) {
            entryId_IndexMap.put(row.getLong("id"), index++);
        }
        return entryId_IndexMap;
    }

    public static Map<Integer, Long> getIndex_EntryIdMap(DynamicObjectCollection rows) {
        HashMap<Integer, Long> index_EntryIdMap = new HashMap<Integer, Long>(rows.size());
        int index = 0;
        for (DynamicObject row : rows) {
            index_EntryIdMap.put(index++, row.getLong("id"));
        }
        return index_EntryIdMap;
    }

    public static Map<Long, DynamicObject> getEntryId_ObjectMap(DynamicObjectCollection rows) {
        return rows.stream().collect(Collectors.groupingBy(e -> e.getLong("id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
    }

    public static void setParentEntryId(DynamicObject compObj, DynamicObject newCompObj) {
        DynamicObjectCollection rows = compObj.getDynamicObjectCollection("entryentity");
        if (!rows.stream().anyMatch(e -> e.getLong("pid") > 0L)) {
            return;
        }
        Map<Long, Integer> entryId_IndexMap = PdsCostDetailUtils.getEntryId_IndexMap(rows);
        DynamicObjectCollection newRows = newCompObj.getDynamicObjectCollection("entryentity");
        Map<Integer, Long> index_EntryIdMap = PdsCostDetailUtils.getIndex_EntryIdMap(newRows);
        for (int i = 0; i < rows.size(); ++i) {
            if (((DynamicObject)rows.get(i)).getLong("pid") <= 0L) continue;
            ((DynamicObject)newRows.get(i)).set("pid", (Object)index_EntryIdMap.get(entryId_IndexMap.get(((DynamicObject)rows.get(i)).getLong("pid"))));
        }
    }

    public static BigDecimal getQtyAndRatio(BigDecimal qty, BigDecimal ratio) {
        qty = qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : qty;
        ratio = ratio.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : ratio;
        return qty.multiply(ratio);
    }

    public static StringBuilder buildMessage(int parentIndex, int index, String fileldName) {
        StringBuilder sb = new StringBuilder();
        if (parentIndex == -1) {
            sb.append(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u660e\u7ec6\u5206\u5f55\u201d\u7b2c%1$s\u884c\uff1a\u201d%2$s\u201c\u3002", (String)"PdsCostDetailUtils_0", (String)"scm-pds-common", (Object[])new Object[0]), index + 1, fileldName));
        } else {
            sb.append(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201d%3$s\u201c\uff1a\u201c\u6210\u672c\u660e\u7ec6\u5206\u5f55\u201d\u7b2c%1$s\u884c\uff0c\u201c\u6210\u672c\u660e\u7ec6\u5b50\u5206\u5f55\u201d\u7b2c%2$s\u884c\u3002", (String)"PdsCostDetailUtils_1", (String)"scm-pds-common", (Object[])new Object[0]), parentIndex + 1, index + 1, fileldName));
        }
        sb.append('\n');
        return sb;
    }

    public static void costDetailQuery(IFormView view, HyperLinkClickArgs args) {
        if (!StringUtils.equals((CharSequence)"costdetail", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            return;
        }
        args.setCancel(true);
        long entryId = ListSelectUtils.selectOne(view);
        QFilter purlistFilter = new QFilter("id", "=", (Object)entryId);
        purlistFilter.and("costdetail", "=", (Object)"1");
        DynamicObject purlistObj = QueryServiceHelper.queryOne((String)"src_purlistf7", (String)"project.id,supplier.id", (QFilter[])purlistFilter.toArray());
        if (null == purlistObj) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u6807\u7684\u672a\u8bbe\u7f6e\u6210\u672c\u660e\u7ec6\u3002", (String)"PdsCostDetailUtils_2", (String)"scm-pds-common", (Object[])new Object[0]));
            return;
        }
        QFilter qfilter = new QFilter("purlist", "=", (Object)entryId);
        qfilter.and("project", "=", (Object)purlistObj.getLong("project.id"));
        qfilter.and("supplier", "=", (Object)purlistObj.getLong("supplier.id"));
        DynamicObject costObj = QueryServiceHelper.queryOne((String)"src_costdetail", (String)"id", (QFilter[])qfilter.toArray());
        if (null == costObj) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u6807\u7684\u672a\u8bbe\u7f6e\u6210\u672c\u660e\u7ec6\u3002", (String)"PdsCostDetailUtils_2", (String)"scm-pds-common", (Object[])new Object[0]));
            return;
        }
        try {
            OpenFormUtils.openBillPage(view, "src_costdetailquery", costObj.getLong("id"), BillOperationStatus.VIEW, ShowType.MainNewTabPage, null, null);
        }
        catch (Exception e) {
            view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6210\u672c\u660e\u7ec6\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u6388\u6743\u540e\u518d\u67e5\u770b\u3002", (String)"PdsCostDetailUtils_3", (String)"scm-pds-common", (Object[])new Object[0]));
        }
    }

    public static Set<String> allowSetCostDetailEntitys() {
        HashSet<String> entitySet = new HashSet<String>(8);
        entitySet.add("src_project");
        entitySet.add("src_purlist");
        entitySet.add("src_negotiatebill");
        entitySet.add("tnd_tenderbill");
        entitySet.add("tnd_quotebill");
        return entitySet;
    }
}

