/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.defaulthandle.DefaultHandleContext;
import kd.scm.pds.common.defaulthandle.PdsDefaultHandleFacotry;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsDefaultConfigUtil {
    public static DynamicObject getCompDefatultConfig(DynamicObject billObj, String entityKey, String compKey) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("entitykey", entityKey);
        paramMap.put("compkey", compKey);
        long schemeId = SchemeFilterUtils.getFirstSchemeId(billObj, "pds_defaultconfig_filter", paramMap);
        if (schemeId == 0L) {
            if ("src_project".equals(entityKey) && "src_project".equals(compKey)) {
                paramMap.put("compkey", "src_project_base");
                schemeId = SchemeFilterUtils.getFirstSchemeId(billObj, "pds_defaultconfig_filter", paramMap);
                if (schemeId == 0L) {
                    return null;
                }
            } else {
                return null;
            }
        }
        return BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"pds_defaultconfig");
    }

    public static Object isNeedSetDefaultValue(IFormView view) {
        String srcbillid;
        IFormView parentView = view.getParentView();
        QFilter nodeFilter = new QFilter("bizobject", "=", (Object)view.getEntityId());
        if (QueryServiceHelper.exists((String)"pds_biznode", (QFilter[])nodeFilter.toArray())) {
            parentView = view;
        }
        if (null == parentView) {
            return null;
        }
        String parentEntityKey = parentView.getEntityId();
        if (Objects.equals(parentEntityKey, "src_projectend") || Objects.equals(parentEntityKey, "ide_formdesigner") || Objects.equals(parentEntityKey, "src_quotebillquery")) {
            return null;
        }
        String entityKey = view.getEntityId();
        long billId = 0L;
        long srcTypeId = 0L;
        try {
            billId = SrmCommonUtil.getPkValue((DynamicObject)parentView.getModel().getDataEntity());
            srcTypeId = SrmCommonUtil.getPkValue((DynamicObject)parentView.getModel().getDataEntity().getDynamicObject("srctype"));
        }
        catch (Exception e) {
            return null;
        }
        String billStatus = parentView.getModel().getDataEntity().getString("billstatus");
        if (null != billStatus && billStatus.trim().length() != 0 && !BillStatusEnum.SAVE.getVal().equals(billStatus)) {
            return null;
        }
        if ("src_project".equals(parentEntityKey) && "src_project_base".equals(entityKey) && null != (srcbillid = parentView.getModel().getDataEntity().getString("srcbillid")) && srcbillid.trim().length() > 0) {
            return null;
        }
        QFilter qfilter = new QFilter("billid", "=", (Object)billId);
        qfilter.and("srctype", "=", (Object)srcTypeId);
        qfilter.and("pentitykey", "=", (Object)parentEntityKey);
        qfilter.and("entitykey", "=", (Object)entityKey);
        DynamicObject defaultObj = QueryServiceHelper.queryOne((String)"pds_setdefaultvaule", (String)"defaultvalue", (QFilter[])qfilter.toArray());
        if (null != defaultObj) {
            return defaultObj.getLong("defaultvalue");
        }
        return PdsDefaultConfigUtil.getCompDefatultConfig(parentView.getModel().getDataEntity(), parentEntityKey, entityKey);
    }

    public static void hasSetDefaultValue(IFormView view, long defaultValueId) {
        IFormView parentView = view.getParentView();
        if (null == parentView) {
            return;
        }
        if (!PdsCommonUtils.isSourceEntityView(parentView)) {
            parentView = view;
        }
        String parentEntityKey = parentView.getEntityId();
        String entityKey = view.getEntityId();
        long billId = 0L;
        long srcTypeId = 0L;
        try {
            billId = SrmCommonUtil.getPkValue((DynamicObject)parentView.getModel().getDataEntity());
            srcTypeId = SrmCommonUtil.getPkValue((DynamicObject)parentView.getModel().getDataEntity().getDynamicObject("srctype"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        QFilter qfilter = new QFilter("billid", "=", (Object)billId);
        qfilter.and("srctype", "=", (Object)srcTypeId);
        qfilter.and("pentitykey", "=", (Object)parentEntityKey);
        qfilter.and("entitykey", "=", (Object)entityKey);
        if (QueryServiceHelper.exists((String)"pds_setdefaultvaule", (QFilter[])qfilter.toArray())) {
            return;
        }
        DynamicObject setDefaultObj = BusinessDataServiceHelper.newDynamicObject((String)"pds_setdefaultvaule");
        setDefaultObj.set("billid", (Object)billId);
        setDefaultObj.set("srctype", (Object)srcTypeId);
        setDefaultObj.set("pentitykey", (Object)parentEntityKey);
        setDefaultObj.set("entitykey", (Object)entityKey);
        setDefaultObj.set("defaultvalue", (Object)defaultValueId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{setDefaultObj});
    }

    public static Object getDefaultValue(DynamicObject billObj, String entityKey, String compKey, String paramName, Object defaultValue) {
        Object defaultVauleObj;
        Optional<DynamicObject> optimalObj;
        Object paramValue = defaultValue;
        DynamicObject defaultCfgObj = PdsDefaultConfigUtil.getCompDefatultConfig(billObj, entityKey, compKey);
        if (null == defaultCfgObj) {
            return paramValue;
        }
        DynamicObjectCollection rows = defaultCfgObj.getDynamicObjectCollection("entryentity");
        if (null != rows && rows.size() > 0 && (optimalObj = rows.stream().filter(e -> Objects.equals(e.getString("fieldid"), paramName)).findFirst()).isPresent() && StringUtils.isNotBlank((Object)(defaultVauleObj = optimalObj.get().get("defaultvalue")))) {
            paramValue = defaultVauleObj;
        }
        return paramValue;
    }

    public static void setDefaultValue(IFormView view, DynamicObject defaultConfigObj) {
        if (null == defaultConfigObj) {
            return;
        }
        DynamicObjectCollection defalutCols = defaultConfigObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject defaultCol : defalutCols) {
            Control control;
            String fieldKey = defaultCol.getString("fieldid");
            String[] fieldKeys = fieldKey.split("\\.");
            if (fieldKeys.length > 1) {
                fieldKey = fieldKeys[1];
            }
            if (null == (control = view.getControl(fieldKey))) continue;
            String defVal = defaultCol.getString("defaultvalue");
            try {
                Object currVal = view.getModel().getValue(fieldKey);
                if (null != currVal && currVal.toString().trim().length() > 0 && !PdsDefaultConfigUtil.isNeedSetValue(currVal)) continue;
                view.getModel().setValue(fieldKey, (Object)defVal);
            }
            catch (Exception exception) {}
        }
    }

    public static boolean isNeedSetValue(Object currVal) {
        return currVal instanceof Number ? new BigDecimal(currVal.toString()).compareTo(BigDecimal.ZERO) == 0 : currVal instanceof Boolean;
    }

    public static boolean isEntryDefaultValue(DynamicObject defaultConfigObj) {
        if (null == defaultConfigObj) {
            return false;
        }
        DynamicObjectCollection defalutCols = defaultConfigObj.getDynamicObjectCollection("entryentity");
        if (defalutCols.size() == 0) {
            return false;
        }
        for (DynamicObject defaultCol : defalutCols) {
            String fieldKey = defaultCol.getString("fieldid");
            String[] fieldKeys = fieldKey.split("\\.");
            if (fieldKeys.length <= 1) continue;
            return true;
        }
        return false;
    }

    public static void setDefaultValue(IFormView view) {
        Object defaultConfig;
        IDataModel model = view.getModel();
        IFormView parentView = view.getParentView();
        if (null == parentView) {
            parentView = view;
        }
        if ((defaultConfig = PdsDefaultConfigUtil.isNeedSetDefaultValue(view)) instanceof DynamicObject) {
            DynamicObject defaultConfigObj = (DynamicObject)defaultConfig;
            DefaultHandleContext context = new DefaultHandleContext();
            if (!PdsCommonUtils.isSourceEntityView(parentView)) {
                parentView = view;
            }
            context.setParentView(parentView);
            context.setCompView(view);
            context.setDefaultConfigObj(defaultConfigObj);
            model.setValue("defaultvalueconfig", defaultConfigObj.getPkValue());
            Object handle = PdsDefaultHandleFacotry.getService(defaultConfigObj);
            handle.handle(context);
            model.setDataChanged(false);
        } else {
            model.setValue("defaultvalueconfig", defaultConfig);
        }
        view.getModel().setDataChanged(false);
    }
}

