/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.message.PdsMessageContext;

public class PdsDocTplUtil {
    public static DynamicObject getDocTpl(String nodeNumber, String sendTypeNumber) {
        String selectFields = "id";
        QFilter filter = new QFilter("isdefault", "=", (Object)"1");
        filter.and("biznode.number", "=", (Object)nodeNumber);
        filter.and("sendtype.number", "=", (Object)sendTypeNumber);
        filter.and("enable", "=", (Object)"1");
        DynamicObject sendType = BusinessDataServiceHelper.loadSingle((String)"pds_doctpl", (String)selectFields, (QFilter[])new QFilter[]{filter});
        return sendType;
    }

    public static DynamicObject getDocTpl(PdsMessageContext context, String bizobject, String sendTypeNumber, String letterType) {
        QFilter scopeFilter;
        String selectFields = "id";
        QFilter filter = new QFilter("biznode.bizobject", "=", (Object)bizobject);
        filter.and("sendtype.number", "=", (Object)sendTypeNumber);
        filter.and("letterstype", "=", (Object)letterType);
        filter.and("enable", "=", (Object)"1");
        QFilter qFilter = scopeFilter = null == context ? null : PdsDocTplUtil.getTplScopeFilter(context.getBillObj().getDynamicObject("project"));
        if (null != scopeFilter) {
            filter.and(scopeFilter);
        }
        BizLog.log((String)("filter:" + filter.toString()));
        String orderBy = "isdefault desc, lastupdatetime desc, number";
        DynamicObject[] docTplObjs = BusinessDataServiceHelper.load((String)"pds_doctpl", (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)orderBy);
        BizLog.log((String)("docTplObjs size:" + docTplObjs.length));
        return docTplObjs.length > 0 ? docTplObjs[0] : null;
    }

    public static DynamicObject getDocTpl(String bizobject, String sendTypeNumber, String letterType) {
        return PdsDocTplUtil.getDocTpl(null, bizobject, sendTypeNumber, letterType);
    }

    public static DynamicObject getDocTplByBizobject(String bizobject, String sendTypeNumber) {
        String selectFields = "id";
        QFilter filter = new QFilter("isdefault", "=", (Object)"1");
        filter.and("biznode.bizobject", "=", (Object)bizobject);
        filter.and("sendtype.number", "=", (Object)sendTypeNumber);
        filter.and("enable", "=", (Object)"1");
        String orderBy = "isdefault desc, lastupdatetime desc, number";
        DynamicObject[] docTplObjs = BusinessDataServiceHelper.load((String)"pds_doctpl", (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)orderBy);
        return null == docTplObjs || docTplObjs.length == 0 ? null : docTplObjs[0];
    }

    public static QFilter getTplScopeFilter(DynamicObject projectObj) {
        long purOrgId;
        QFilter purOrgFilter;
        long sourceFlowId;
        QFilter sourceFlowFilter;
        if (null == projectObj) {
            return null;
        }
        QFilter qfilter = null;
        long sourceTypeId = projectObj.getLong("sourcetype.id");
        QFilter sourceTypeFilter = ExtFilterUtils.getMultiBaseDataFilter("sourcetype", sourceTypeId);
        if (null != sourceTypeFilter) {
            QFilter qFilter = qfilter = null == qfilter ? sourceTypeFilter : qfilter.and(sourceTypeFilter);
        }
        if (null != (sourceFlowFilter = ExtFilterUtils.getMultiBaseDataFilter("srctype", sourceFlowId = projectObj.getLong("srctype.id")))) {
            QFilter qFilter = qfilter = null == qfilter ? sourceFlowFilter : qfilter.and(sourceFlowFilter);
        }
        if (null != (purOrgFilter = ExtFilterUtils.getMultiBaseDataFilter("purorg", purOrgId = projectObj.getLong("org.id")))) {
            qfilter = null == qfilter ? purOrgFilter : qfilter.and(purOrgFilter);
        }
        return qfilter;
    }
}

