/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;

public class PdsExceptionUtil {
    public static final Charset UTF_8 = StandardCharsets.UTF_8;

    public static String s(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).toPlainString();
        }
        String s = o.toString();
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() == 0 ? null : s;
    }

    public static RuntimeException e(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        return new KDBizException("datainvalid:" + e.getMessage());
    }

    public static Exception e2(Throwable e) {
        if (e instanceof Exception) {
            return (Exception)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        return PdsExceptionUtil.e(e);
    }

    public static String getMessage(Throwable e) {
        String s = PdsExceptionUtil.s(e.getMessage());
        if (s == null) {
            s = e.getClass().getName();
        } else if (e instanceof UnknownHostException) {
            s = String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u786e\u5b9a\u4e3b\u673a\uff08%s\uff09\u7684IP\u5730\u5740\u3002", (String)"PdsExceptionUtil_0", (String)"scm-pds-common", (Object[])new Object[0]), s);
        }
        return s;
    }

    public static String toString(Throwable e) {
        if (e == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            PrintStream ps = new PrintStream((OutputStream)baos, true, "UTF-8");
            ps.append("\r\n\r\n");
            e.printStackTrace(ps);
            ps.flush();
            String s = baos.toString("utf-8");
            return PdsExceptionUtil.getCascadeMessage(e) + s.replace(PdsExceptionUtil.getMessage(e), "");
        }
        catch (UnsupportedEncodingException err) {
            throw PdsExceptionUtil.e(err);
        }
    }

    public static String getCascadeMessage(Throwable e) {
        StringBuilder s = new StringBuilder();
        String message = PdsExceptionUtil.getMessage(e);
        s.append(message);
        String priorMessage = message;
        HashSet<Throwable> visited = new HashSet<Throwable>();
        while (visited.add(e) && (e = e.getCause()) != null) {
            message = PdsExceptionUtil.getMessage(e);
            if (priorMessage.contains(message)) continue;
            s.append("\u3000// \u539f\u56e0\uff1a").append(message);
            priorMessage = message;
        }
        return s.toString();
    }

    public static boolean isBaseType(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> className = object.getClass();
        return className.equals(Integer.class) || className.equals(Byte.class) || className.equals(Long.class) || className.equals(Double.class) || className.equals(Float.class) || className.equals(String.class) || className.equals(Character.class) || className.equals(Short.class) || className.equals(Boolean.class);
    }
}

