/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.SubEntryType;

public class PdsFlowConfigUtils {
    public static boolean existsSpecificNode(DynamicObject projectObj, String nodeNumber) {
        return PdsFlowConfigUtils.existsSpecificNode(projectObj, nodeNumber, "entrymainflow", "entrysubflow");
    }

    public static boolean existsSpecificNode(DynamicObject billObj, String nodeNumber, String mainEntity, String subEntity) {
        DynamicObjectCollection entryNodeCols = billObj.getDynamicObjectCollection(mainEntity);
        for (DynamicObject entryNodeCol : entryNodeCols) {
            String number = entryNodeCol.getString("biznode.number");
            if (nodeNumber.equals(number)) {
                return true;
            }
            DynamicObjectCollection subEntrys = entryNodeCol.getDynamicObjectCollection(subEntity);
            for (DynamicObject subEntryNodeCol : subEntrys) {
                String subNumber = subEntryNodeCol.getString("subbiznode.number");
                if (!nodeNumber.equals(subNumber)) continue;
                return true;
            }
        }
        return false;
    }

    public static DynamicObject getChildrenNode(DynamicObject node, boolean ignoreSubNode) {
        List<DynamicObject> plainNodeList = PdsFlowConfigUtils.getPlainNode(node);
        String nodeName = node.getDataEntityType().getName();
        String bizObject = null;
        boolean isFindNode = false;
        boolean isFlowChart = false;
        for (int i = 0; i < plainNodeList.size(); ++i) {
            boolean isSubNode = false;
            DynamicObject plainNode = plainNodeList.get(i);
            if (plainNode.getDynamicObjectType() instanceof SubEntryType) {
                bizObject = plainNode.getString("subbizobject");
                isSubNode = true;
            } else {
                bizObject = plainNode.getString("bizobject");
            }
            if (bizObject.equals(nodeName)) {
                isFindNode = true;
                continue;
            }
            if (!isFindNode || !(isFlowChart = isSubNode ? plainNode.getBoolean("subisflowchart") : plainNode.getBoolean("isflowchart"))) continue;
            return plainNode;
        }
        return null;
    }

    public static List<DynamicObject> getPlainNode(DynamicObject node) {
        ArrayList<DynamicObject> plainNodeList = new ArrayList<DynamicObject>(16);
        DynamicObjectCollection entryNodeCols = node.getDynamicObjectCollection("entrymainflow");
        for (DynamicObject entryNodeCol : entryNodeCols) {
            plainNodeList.add(entryNodeCol);
            DynamicObjectCollection subEntryCols = entryNodeCol.getDynamicObjectCollection("entrysubflow");
            plainNodeList.addAll((Collection<DynamicObject>)subEntryCols);
        }
        return plainNodeList;
    }

    public static DynamicObject getCurrNode(DynamicObject node, String nodeName, boolean ignoreSubNode) {
        DynamicObjectCollection entryNodeCols = node.getDynamicObjectCollection("entrymainflow");
        int entryNodeSize = entryNodeCols.size();
        for (int i = 0; i < entryNodeSize; ++i) {
            DynamicObject entryNodeCol = (DynamicObject)entryNodeCols.get(i);
            String bizObject = entryNodeCol.getString("bizobject");
            if (bizObject.equals(nodeName)) {
                return entryNodeCol;
            }
            DynamicObjectCollection subEntryCols = entryNodeCol.getDynamicObjectCollection("entrysubflow");
            int subEntrySize = subEntryCols.size();
            for (int j = 0; j < subEntrySize; ++j) {
                DynamicObject subEntryCol = (DynamicObject)subEntryCols.get(j);
                String subBizObject = subEntryCol.getString("subbizobject");
                if (!subBizObject.equals(nodeName)) continue;
                if (ignoreSubNode) {
                    return entryNodeCol;
                }
                return subEntryCol;
            }
        }
        return null;
    }

    public static DynamicObject getNextNode(DynamicObject node) {
        String nodeName = node.getDataEntityType().getName();
        DynamicObjectCollection entryNodeCols = node.getDynamicObjectCollection("entrymainflow");
        int entryNodeSize = entryNodeCols.size();
        for (int i = 0; i < entryNodeSize; ++i) {
            DynamicObject entryNodeCol = (DynamicObject)entryNodeCols.get(i);
            String bizObject = entryNodeCol.getString("bizobject");
            if (i < entryNodeSize - 1 && bizObject.equals(nodeName)) {
                return (DynamicObject)entryNodeCols.get(i + 1);
            }
            DynamicObjectCollection subEntryCols = entryNodeCol.getDynamicObjectCollection("entrysubflow");
            int subEntrySize = subEntryCols.size();
            for (int j = 0; j < subEntrySize; ++j) {
                DynamicObject subEntryCol = (DynamicObject)subEntryCols.get(j);
                String subBizObject = subEntryCol.getString("subbizobject");
                if (!subBizObject.equals(nodeName) || i >= entryNodeSize - 1) continue;
                return (DynamicObject)entryNodeCols.get(i + 1);
            }
        }
        return null;
    }

    public static DynamicObject getCurrNextNode(DynamicObject node) {
        List<DynamicObject> plainNodeList = PdsFlowConfigUtils.getPlainNode(node);
        String nodeName = node.getDataEntityType().getName();
        int nodeSize = plainNodeList.size();
        for (int i = 0; i < nodeSize; ++i) {
            DynamicObject nodeCol = plainNodeList.get(i);
            String bizObject = nodeCol.getDataEntityType() instanceof SubEntryType ? nodeCol.getString("subbizobject") : nodeCol.getString("bizobject");
            if (i >= nodeSize - 1 || !bizObject.equals(nodeName)) continue;
            for (int j = i + 1; j < nodeSize; ++j) {
                DynamicObject nextNode = plainNodeList.get(j);
                if (nextNode.getDataEntityType() instanceof SubEntryType) {
                    if (!nextNode.getBoolean("subisaudit")) continue;
                    return nextNode;
                }
                return nextNode;
            }
        }
        return null;
    }

    public static String getCurrNextNodeNo(DynamicObject node) {
        DynamicObject nextNode = PdsFlowConfigUtils.getCurrNextNode(node);
        if (null == nextNode) {
            return null;
        }
        if ("entrymainflow".equals(nextNode.getDataEntityType().getName())) {
            return nextNode.getString("biznode.number");
        }
        if ("entrysubflow".equals(nextNode.getDataEntityType().getName())) {
            return nextNode.getString("subbiznode.number");
        }
        return null;
    }

    public static DynamicObject getCurrPreviousNode(DynamicObject node) {
        List<DynamicObject> plainNodeList = PdsFlowConfigUtils.getPlainNode(node);
        String nodeName = node.getDataEntityType().getName();
        int nodeSize = plainNodeList.size();
        for (int i = 0; i < nodeSize; ++i) {
            DynamicObject nodeCol = plainNodeList.get(i);
            String bizObject = nodeCol.getDataEntityType() instanceof SubEntryType ? nodeCol.getString("subbizobject") : nodeCol.getString("bizobject");
            if (i <= 0 || !bizObject.equals(nodeName)) continue;
            for (int j = i - 1; j > 0; --j) {
                DynamicObject nextNode = plainNodeList.get(j);
                if (nextNode.getDataEntityType() instanceof SubEntryType) {
                    if (!nextNode.getBoolean("subisaudit")) continue;
                    return nextNode;
                }
                return nextNode;
            }
        }
        return null;
    }

    public static String getCurrPreviousNodeNo(DynamicObject node) {
        DynamicObject nextNode = PdsFlowConfigUtils.getCurrPreviousNode(node);
        if (null == nextNode) {
            return null;
        }
        if ("entrymainflow".equals(nextNode.getDataEntityType().getName())) {
            return nextNode.getString("biznode.number");
        }
        if ("entrysubflow".equals(nextNode.getDataEntityType().getName())) {
            return nextNode.getString("subbiznode.number");
        }
        return null;
    }

    public static DynamicObject getNextNode(DynamicObject node, boolean ignoreSubNode) {
        if (ignoreSubNode) {
            return PdsFlowConfigUtils.getNextNode(node);
        }
        DynamicObject nextNode = null;
        String nodeName = node.getDataEntityType().getName();
        DynamicObjectCollection entryNodeCols = node.getDynamicObjectCollection("entrymainflow");
        int entryNodeSize = entryNodeCols.size();
        for (int i = 0; i < entryNodeSize; ++i) {
            DynamicObject entryNodeCol = (DynamicObject)entryNodeCols.get(i);
            String bizObject = entryNodeCol.getString("bizobject");
            if (i < entryNodeSize - 1 && bizObject.equals(nodeName)) {
                nextNode = (DynamicObject)entryNodeCols.get(i + 1);
                return nextNode;
            }
            boolean currNodeIsSubNode = false;
            DynamicObjectCollection subEntryCols = entryNodeCol.getDynamicObjectCollection("entrysubflow");
            int subEntrySize = subEntryCols.size();
            for (int j = 0; j < subEntrySize; ++j) {
                boolean isAudit;
                DynamicObject subEntryCol = (DynamicObject)subEntryCols.get(j);
                String subBizObject = subEntryCol.getString("subbizobject");
                if (subBizObject.equals(nodeName)) {
                    currNodeIsSubNode = true;
                }
                if (!currNodeIsSubNode) continue;
                DynamicObject nextSubNode = null;
                if (j >= subEntrySize - 1 || !(isAudit = (nextSubNode = (DynamicObject)subEntryCols.get(j + 1)).getBoolean("subisaudit"))) continue;
                nextNode = nextSubNode;
                break;
            }
            if (!currNodeIsSubNode || nextNode != null || i >= entryNodeSize - 1) continue;
            nextNode = (DynamicObject)entryNodeCols.get(i + 1);
            return nextNode;
        }
        return nextNode;
    }
}

