/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class PdsHyperLinkUtils {
    public static void listOpenFormByEntryBillNo(IFormView currentView, HyperLinkClickArgs args, String billNoField, String targetEntity) {
        if (!StringUtils.equals((CharSequence)billNoField, (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            return;
        }
        args.setCancel(true);
        Object billNoObj = PdsHyperLinkUtils.getEntryBillNoObj(currentView, args, billNoField);
        long billId = PdsHyperLinkUtils.getTargetBillId(billNoObj, targetEntity);
        PdsHyperLinkUtils.openTargetBill(currentView, targetEntity, billId);
    }

    public static void editOpenFormByEntryBillNo(IFormView currentView, HyperLinkClickEvent args, String billNoField, String targetEntity) {
        if (!StringUtils.equals((CharSequence)billNoField, (CharSequence)args.getFieldName())) {
            return;
        }
        long billId = PdsHyperLinkUtils.getTargetBillId(currentView.getModel().getValue(billNoField, args.getRowIndex()), targetEntity);
        PdsHyperLinkUtils.openTargetBill(currentView, targetEntity, billId);
    }

    public static void editOpenFormByEntryBillId(IFormView currentView, HyperLinkClickEvent args, String billTypeField, String billNoField, String billIdField, String targetEntity) {
        if (!StringUtils.equals((CharSequence)billNoField, (CharSequence)args.getFieldName())) {
            return;
        }
        long billId = PdsCommonUtils.object2Long(currentView.getModel().getValue(billIdField, args.getRowIndex()));
        if (null != billTypeField) {
            targetEntity = PdsCommonUtils.object2String(currentView.getModel().getValue(billTypeField, args.getRowIndex()), targetEntity);
        }
        PdsHyperLinkUtils.openTargetBill(currentView, targetEntity, billId);
    }

    private static Object getEntryBillNoObj(IFormView currentView, HyperLinkClickArgs args, String billNoField) {
        BillList list = (BillList)currentView.getControl("billlistap");
        String currentEntity = list.getEntityId();
        String entryEntity = list.getCurrentSelectedRowInfo().getEntryEntityKey();
        long pkValue = PdsCommonUtils.object2Long(list.getCurrentSelectedRowInfo().getPrimaryKeyValue());
        long entryPkValue = PdsCommonUtils.object2Long(list.getCurrentSelectedRowInfo().getEntryPrimaryKeyValue());
        QFilter qfilter = new QFilter("id", "=", (Object)pkValue);
        qfilter.and(entryEntity + '.' + "id", "=", (Object)entryPkValue);
        DynamicObject entryObj = QueryServiceHelper.queryOne((String)currentEntity, (String)(entryEntity + ',' + entryEntity + '.' + billNoField), (QFilter[])qfilter.toArray());
        if (null == entryObj) {
            return null;
        }
        return entryObj.get(entryEntity + '.' + billNoField);
    }

    private static long getTargetBillId(Object billno, String targetEntity) {
        if (null == billno) {
            return 0L;
        }
        QFilter targetfilter = new QFilter("billno", "=", billno);
        DynamicObject targetObj = QueryServiceHelper.queryOne((String)targetEntity, (String)"id", (QFilter[])targetfilter.toArray());
        if (null == targetObj) {
            return 0L;
        }
        return targetObj.getLong("id");
    }

    public static void openTargetBill(IFormView currentView, String targetEntity, long billId) {
        if (billId == 0L || null == targetEntity) {
            currentView.showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u6253\u5f00\u3002", (String)"PdsHyperLinkUtils_0", (String)"scm-pds-common", (Object[])new Object[0]));
        } else {
            OpenFormUtils.openBillPage(currentView, targetEntity, billId, BillOperationStatus.VIEW, ShowType.MainNewTabPage, null, null);
        }
    }

    public static void listOpenFormByBillId(IFormView currentView, HyperLinkClickArgs args, String billNoField, String billIdField, String targetEntity) {
        if (!StringUtils.equals((CharSequence)billNoField, (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            return;
        }
        args.setCancel(true);
        long billId = PdsHyperLinkUtils.getTargetBillId(currentView, args, billIdField);
        if (billId > 0L) {
            PdsHyperLinkUtils.openTargetBill(currentView, targetEntity, billId);
        }
    }

    private static long getTargetBillId(IFormView currentView, HyperLinkClickArgs args, String billIdField) {
        BillList list = (BillList)currentView.getControl("billlistap");
        String currentEntity = list.getEntityId();
        long pkValue = PdsCommonUtils.object2Long(list.getCurrentSelectedRowInfo().getPrimaryKeyValue());
        QFilter qfilter = new QFilter("id", "=", (Object)pkValue);
        DynamicObject billObj = QueryServiceHelper.queryOne((String)currentEntity, (String)(billIdField + '.' + "id"), (QFilter[])qfilter.toArray());
        if (null == billObj) {
            return 0L;
        }
        return billObj.getLong(billIdField + '.' + "id");
    }
}

