/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsLogInfoUtils {
    public static void logInfo(Map<String, Object> paramMap) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = PdsLogInfoUtils.buildLogInfo(paramMap);
        logService.addLog(logInfo);
    }

    public static AppLogInfo buildLogInfo(Map<String, Object> paramMap) {
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(PdsCommonUtils.getLoginIp());
        logInfo.setBizAppID(PdsCommonUtils.object2String(paramMap.get("appid"), ""));
        logInfo.setBizObjID(PdsCommonUtils.object2String(paramMap.get("object"), ""));
        logInfo.setOpName(PdsCommonUtils.object2String(paramMap.get("operatekey"), ""));
        logInfo.setOpDescription(PdsCommonUtils.object2String(paramMap.get("description"), ""));
        if (null == paramMap.get("org")) {
            logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        } else {
            logInfo.setOrgID(Long.valueOf(PdsCommonUtils.object2Long(paramMap.get("org"))));
        }
        if (null == paramMap.get("user")) {
            logInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        } else {
            logInfo.setUserID(Long.valueOf(PdsCommonUtils.object2Long(paramMap.get("user"))));
        }
        logInfo.setOpTime(TimeServiceHelper.now());
        return logInfo;
    }

    public static void logUnitTestInfo(String bizAppID, String bizObjID, String message) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("appid", bizAppID);
        paramMap.put("object", bizObjID);
        paramMap.put("operatekey", "unittest");
        paramMap.put("description", message);
        PdsLogInfoUtils.logInfo(paramMap);
    }
}

