/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.control.Control;
import kd.bos.form.field.AddressEdit;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.AssistantEdit;
import kd.bos.form.field.AttachmentEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.form.field.BillStatusEdit;
import kd.bos.form.field.CityEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.EmailEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.GroupEdit;
import kd.bos.form.field.IntegerEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.field.MainOrgEdit;
import kd.bos.form.field.MaterielEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.QtyEdit;
import kd.bos.form.field.TelephoneEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.UnitEdit;
import kd.bos.form.field.UserEdit;
import kd.bos.logging.BizLog;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.scm.common.util.LowTimer;
import kd.scm.pds.common.concurrent.PdsMetaDataTask;
import kd.scm.pds.common.entity.PdsObjectPools;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsMetadataUtil {
    private static ThreadPool pdsMetaDataThreadPool = null;

    public static Map<String, String> getProMap(String entityKey) {
        Map<String, String> columnMap = new LinkedHashMap<String, String>();
        FormMetadata formmeta = PdsMetadataUtil.getFormMetaData(entityKey);
        if (null != formmeta) {
            columnMap = PdsMetadataUtil.getPro(formmeta.getItems(), null);
        }
        return columnMap;
    }

    public static Map<String, String> getProMap(String entityKey, boolean isHidden) {
        Map<String, String> columnMap = new LinkedHashMap<String, String>();
        FormMetadata formmeta = PdsMetadataUtil.getFormMetaData(entityKey);
        if (null != formmeta) {
            columnMap = PdsMetadataUtil.getPro(formmeta.getItems(), null, isHidden);
        }
        return columnMap;
    }

    public static Map<String, String> getProTypeMap(String entityKey, boolean isHidden) {
        String key = "protypemap_" + entityKey;
        Map<String, String> columnMap = (LinkedHashMap<String, String>)PdsObjectPools.getInstance(key);
        if (null != columnMap) {
            // empty if block
        }
        columnMap = new LinkedHashMap<String, String>();
        FormMetadata formmeta = PdsMetadataUtil.getFormMetaData(entityKey);
        if (null != formmeta) {
            columnMap = PdsMetadataUtil.getProType(formmeta.getItems(), null, isHidden);
            PdsObjectPools.putInstance(key, columnMap);
        }
        return columnMap;
    }

    public static Map<String, String> getPro(List<ControlAp<?>> items, ControlAp<?> parent) {
        return PdsMetadataUtil.getPro(items, parent, false);
    }

    public static Map<String, String> getProType(List<ControlAp<?>> items, ControlAp<?> parent) {
        return PdsMetadataUtil.getProType(items, parent, false);
    }

    public static FormMetadata getFormMetaData(String entityKey) {
        String entityId = MetadataDao.getIdByNumber((String)entityKey, (MetaCategory)MetaCategory.Entity);
        if (null == entityId) {
            return null;
        }
        FormMetadata formmeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        EntityMetadata entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        formmeta.bindEntityMetadata(entitymeta);
        return formmeta;
    }

    public static Map<String, Map<String, String>> getButtonPro(String entityKey, boolean isHidden, boolean isDropdownItem) {
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>(2);
        LinkedHashMap<String, String> buttonMap = new LinkedHashMap<String, String>(16);
        LinkedHashMap<String, String> queryMap = new LinkedHashMap<String, String>(16);
        FormMetadata formmeta = PdsMetadataUtil.getFormMetaData(entityKey);
        for (ControlAp ap : formmeta.getItems()) {
            List itemAps;
            LocaleString displayName;
            if (!(ap instanceof ButtonAp)) continue;
            if (!isHidden) {
                int visVal = ap.getVisibleValue();
                if (ap.isHidden() || visVal == 0) continue;
            }
            if (null == (displayName = ap.getName())) continue;
            String btnKey = ap.getKey();
            String btnName = displayName.toString();
            buttonMap.put(btnKey, btnName);
            if (!isDropdownItem || !(ap instanceof BarItemAp) || null == (itemAps = ((BarItemAp)ap).getDropdownItems()) || itemAps.size() == 0) continue;
            for (DropdownItem itemAp : itemAps) {
                btnKey = itemAp.getKey();
                btnName = itemAp.getTitle().toString();
                String subTitle = itemAp.getSubTitle().toString();
                if ("businessquery".equalsIgnoreCase(subTitle)) {
                    queryMap.put(btnKey, btnName);
                }
                buttonMap.put(btnKey, btnName);
            }
        }
        resultMap.put("businessop", buttonMap);
        resultMap.put("businessquery", queryMap);
        return resultMap;
    }

    public static Map<String, Map<String, String>> getButtonMap(String entityName) {
        String buttonMapKey = "buttonmap_" + entityName;
        Map<String, Map<String, String>> resultMap = (Map<String, Map<String, String>>)PdsObjectPools.getInstance(buttonMapKey);
        resultMap = PdsMetadataUtil.getButtonPro(entityName, false, true);
        return resultMap;
    }

    private static Map<String, String> getPro(List<ControlAp<?>> items, ControlAp<?> parent, boolean isHidden) {
        return PdsMetadataUtil.getPro(null, items, parent, isHidden);
    }

    public static List<String> getEntryKey(String entityKey) {
        ArrayList<String> entryList = new ArrayList<String>(8);
        FormMetadata formmeta = PdsMetadataUtil.getFormMetaData(entityKey);
        if (Objects.isNull(formmeta)) {
            return entryList;
        }
        for (ControlAp ap : formmeta.getItems()) {
            int result;
            if (!(ap instanceof EntryAp) || (result = ap.getName().toString().indexOf("(MOV)")) != -1 || Objects.equals(ap.getKey(), "entrysubflow") || Objects.equals(ap.getKey(), "entrymainflow") || Objects.equals(ap.getKey(), "tplentry")) continue;
            entryList.add(ap.getKey());
        }
        return entryList;
    }

    private static Map<String, String> getProType(List<ControlAp<?>> items, ControlAp<?> parent, boolean isHidden) {
        LinkedHashMap<String, String> columnMap = new LinkedHashMap<String, String>();
        EntryAp entryAp = null;
        for (ControlAp<?> ap : items) {
            LocaleString displayName;
            if (ap instanceof EntryAp) {
                int result = ap.getName().toString().indexOf("(MOV)");
                if (result != -1) continue;
                entryAp = (EntryAp)ap;
                columnMap.putAll(PdsMetadataUtil.getProType(entryAp.getItems(), entryAp));
                continue;
            }
            if (ap instanceof BillFormAp || ap instanceof ContainerAp || ap instanceof ButtonAp || ap instanceof BarItemAp || ap instanceof FlexPanelAp || ap instanceof VectorAp || null == parent && ap instanceof EntryFieldAp) continue;
            if (!isHidden) {
                int visVal = ap.getVisibleValue();
                if (ap.isHidden() || visVal == 0) continue;
            }
            if (null == (displayName = ap.getName())) continue;
            String proKey = ap.getKey();
            String text = ap.buildRuntimeControl().getClass().getSimpleName();
            columnMap.put(proKey, text);
            if (!"DateRangeEdit".equals(text)) continue;
            columnMap.put(proKey + "from", "DateEdit");
            columnMap.put(proKey + "to", "DateEdit");
        }
        return columnMap;
    }

    public static Map<String, String> getDynamicBDProperties(DynamicObject obj, String entryName) {
        HashMap<String, String> bdMap = new HashMap<String, String>();
        if (Objects.isNull(obj)) {
            return bdMap;
        }
        obj.getDataEntityType().getProperties().forEach(iDataEntityProperty -> {
            if (!(iDataEntityProperty instanceof AssistantProp) && iDataEntityProperty instanceof BasedataProp) {
                bdMap.put(iDataEntityProperty.getName(), ((BasedataProp)iDataEntityProperty).getBaseEntityId());
            }
        });
        if (StringUtils.isEmpty((CharSequence)entryName)) {
            return bdMap;
        }
        obj.getDynamicObjectCollection(entryName).getDynamicObjectType().getProperties().forEach(iDataEntityProperty -> {
            if (!(iDataEntityProperty instanceof AssistantProp) && iDataEntityProperty instanceof BasedataProp) {
                bdMap.put(iDataEntityProperty.getName(), ((BasedataProp)iDataEntityProperty).getBaseEntityId());
            }
        });
        return bdMap;
    }

    public static List<ComboItem> buildPropComboItems(Map<String, String> propertiesMap) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        for (Map.Entry<String, String> propertyEntry : propertiesMap.entrySet()) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(propertyEntry.getValue()));
            item.setValue(propertyEntry.getKey());
            items.add(item);
        }
        items.sort(new Comparator<ComboItem>(){

            @Override
            public int compare(ComboItem comb1, ComboItem comb2) {
                String comb1Str = comb1.getValue();
                String comb2Str = comb2.getValue();
                if ("".equals(comb1Str)) {
                    return -1;
                }
                if ("".equals(comb2Str)) {
                    return 1;
                }
                if (comb1Str.indexOf(46) >= 0 && comb2Str.indexOf(46) < 0) {
                    return 1;
                }
                if (comb1Str.indexOf(46) < 0 && comb2Str.indexOf(46) >= 0) {
                    return -1;
                }
                return comb1.getValue().compareTo(comb1.getValue());
            }
        });
        return items;
    }

    public static String getFieldDisplayName(Control control) {
        if (control instanceof AmountEdit) {
            return ((AmountEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof AttachmentEdit) {
            return ((AttachmentEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof BasedataEdit) {
            return ((BasedataEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof BasedataPropEdit) {
            return ((BasedataPropEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof BillStatusEdit) {
            return ((BillStatusEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof CityEdit) {
            return ((CityEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof ComboEdit) {
            return ((ComboEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof DateEdit) {
            return ((DateEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof DateRangeEdit) {
            return ((DateRangeEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof DateTimeEdit) {
            return ((DateTimeEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof DecimalEdit) {
            return ((DecimalEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof ItemClassEdit) {
            return ((ItemClassEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof ItemClassTypeEdit) {
            return ((ItemClassTypeEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof LargeTextEdit) {
            return ((LargeTextEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof MainOrgEdit) {
            return ((MainOrgEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof MulBasedataEdit) {
            return ((MulBasedataEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof MulComboEdit) {
            return ((MulComboEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof OrgEdit) {
            return ((OrgEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof QtyEdit) {
            return ((QtyEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof TextEdit) {
            return ((TextEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof UnitEdit) {
            return ((UnitEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof UserEdit) {
            return ((UserEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof GroupEdit) {
            return ((GroupEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof MaterielEdit) {
            return ((MaterielEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof AddressEdit) {
            return ((AddressEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof AssistantEdit) {
            return ((AssistantEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof EmailEdit) {
            return ((EmailEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof TelephoneEdit) {
            return ((TelephoneEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof IntegerEdit) {
            return ((IntegerEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        if (control instanceof FieldEdit) {
            return ((FieldEdit)control).getProperty().getDisplayName().getLocaleValue();
        }
        return "";
    }

    public static List<String> getContainerProperties(String metadataName, String containerName) {
        String entityId = MetadataDao.getIdByNumber((String)metadataName, (MetaCategory)MetaCategory.Entity);
        FormMetadata formmeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        EntityMetadata entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        formmeta.bindEntityMetadata(entitymeta);
        String containerId = null;
        for (ControlAp ap : formmeta.getItems()) {
            if (!containerName.equals(ap.getKey())) continue;
            containerId = ap.getId();
            break;
        }
        if (null == containerId) {
            return null;
        }
        ArrayList<String> properties = new ArrayList<String>();
        for (ControlAp ap : formmeta.getItems()) {
            int result = ap.getName().toString().indexOf("(MOV)");
            if (result != -1 || !containerId.equals(ap.getParentId())) continue;
            int visVal = ap.getVisibleValue();
            if (ap.isHidden() || visVal == 0) continue;
            properties.add(ap.getKey());
        }
        return properties;
    }

    public static List<ComboItem> getOpreateComboItemList(String entityNumber) {
        ArrayList<ComboItem> comboList = new ArrayList<ComboItem>(16);
        List dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)entityNumber);
        if (dataEntityOperate.size() == 0) {
            return comboList;
        }
        LocaleString localeString = null;
        for (Map operate : dataEntityOperate) {
            String key = (String)operate.get("key");
            Object name = operate.get("name");
            if (name == null) continue;
            localeString = new LocaleString(ResManager.loadKDString((String)"\u672a\u547d\u540d\u64cd\u4f5c", (String)"PdsMetadataUtil_0", (String)"scm-pds-common", (Object[])new Object[0]));
            localeString = name instanceof Map ? LocaleString.fromMap((Map)((Map)name)) : new LocaleString(name.toString());
            comboList.add(new ComboItem(localeString, key));
        }
        return comboList;
    }

    public static List<ComboItem> getComboItemFiled(String entityKey, String controlType) {
        ArrayList<ComboItem> entries = new ArrayList<ComboItem>(16);
        if (StringUtils.isBlank((CharSequence)entityKey)) {
            return entries;
        }
        FormMetadata formMetadata = PdsMetadataUtil.getFormMetaData(entityKey);
        List items = formMetadata.getItems();
        HashSet<String> keySet = new HashSet<String>(8);
        for (ControlAp item : items) {
            switch (controlType) {
                case "attachmentpanelap": {
                    if (!(item instanceof AttachmentPanelAp)) break;
                    entries.add(new ComboItem(item.getName(), item.getKey()));
                    keySet.add(item.getKey());
                    break;
                }
                case "entryap": {
                    int result = item.getName().toString().indexOf("(MOV)");
                    if (result != -1 || !(item instanceof EntryAp)) break;
                    List entryItems = ((EntryAp)item).getItems();
                    for (ControlAp entryItem : entryItems) {
                        try {
                            Field fieldAp = ((EntryFieldAp)entryItem).getField();
                            if (!(fieldAp instanceof AttachmentField)) continue;
                            entries.add(new ComboItem(new LocaleString(item.getName() + "." + fieldAp.getName()), item.getKey() + "." + fieldAp.getKey()));
                            keySet.add(fieldAp.getKey());
                        }
                        catch (Exception e) {
                            BizLog.log((String)("tranferexception error:" + e.getMessage()));
                        }
                    }
                    break;
                }
            }
        }
        if ("entryap".equals(controlType)) {
            HashSet<String> excludedFields = new HashSet<String>(8);
            excludedFields.add("bidattach_biddoc");
            for (ControlAp item : items) {
                if (keySet.contains(item.getKey()) || excludedFields.contains(item.getKey())) continue;
                PdsMetadataUtil.getSpecialAttachFields(item, entries);
            }
        }
        return entries;
    }

    private static void getSpecialAttachFields(ControlAp<?> item, List<ComboItem> entries) {
        Field fieldAp;
        if (item instanceof FieldAp && (fieldAp = ((FieldAp)item).getField()) instanceof AttachmentField) {
            entries.add(new ComboItem(item.getName(), item.getKey()));
        }
    }

    public static Map<String, String> getOpreateMap(String entityNumber) {
        HashMap<String, String> opreateMap = new HashMap<String, String>(8);
        List dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)entityNumber);
        if (dataEntityOperate.size() == 0) {
            return opreateMap;
        }
        LocaleString localeString = null;
        for (Map operate : dataEntityOperate) {
            String key = (String)operate.get("key");
            Object name = operate.get("name");
            if (name == null) continue;
            localeString = new LocaleString(ResManager.loadKDString((String)"\u672a\u547d\u540d\u64cd\u4f5c", (String)"PdsMetadataUtil_0", (String)"scm-pds-common", (Object[])new Object[0]));
            localeString = name instanceof Map ? LocaleString.fromMap((Map)((Map)name)) : new LocaleString(name.toString());
            opreateMap.put(key, localeString.getLocaleValue());
        }
        return opreateMap;
    }

    public static List<ComboItem> getComboProp(String entityName, String fieldName) {
        if (null == entityName || null == fieldName) {
            return new ArrayList<ComboItem>();
        }
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityName);
        ComboProp comboProp = (ComboProp)type.findProperty(fieldName);
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(16);
        for (ValueMapItem valueMapItem : comboProp.getComboItems()) {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(valueMapItem.getValue());
            comboItem.setCaption(valueMapItem.getName());
            comboItem.setItemVisible(valueMapItem.isItemVisible());
            comboItem.setImageKey(valueMapItem.getImageKey());
            comboItemList.add(comboItem);
        }
        return comboItemList;
    }

    public static Set<String> getInheritMetaNumber(String inheritpath) {
        HashSet<String> metaNumberSet = new HashSet<String>(256);
        QFilter inheriPathFilter = new QFilter("inheritpath", "match", (Object)inheritpath);
        inheriPathFilter.and("enabled", "=", (Object)"1");
        inheriPathFilter.and("masterid", "=", (Object)" ");
        Map formmetaMap = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"id,number", (QFilter[])inheriPathFilter.toArray());
        for (Map.Entry formmetaMapEntry : formmetaMap.entrySet()) {
            metaNumberSet.add(((DynamicObject)formmetaMapEntry.getValue()).getString("number"));
        }
        return metaNumberSet;
    }

    public static Map<String, String> getAllProMap(String entityKey, boolean isHidden, boolean includeRef) {
        Map<String, String> columnMap = new LinkedHashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)entityKey)) {
            return columnMap;
        }
        FormMetadata formmeta = PdsMetadataUtil.getFormMetaData(entityKey);
        if (null != formmeta) {
            DynamicObject entityObj = null;
            if (includeRef) {
                entityObj = BusinessDataServiceHelper.newDynamicObject((String)entityKey);
            }
            columnMap = PdsMetadataUtil.getPro(entityObj, formmeta.getItems(), null, isHidden);
        }
        return columnMap;
    }

    private static ThreadPool getThreadPool() {
        if (null == pdsMetaDataThreadPool) {
            pdsMetaDataThreadPool = ThreadPools.newCachedThreadPool((String)"Scm-Pds-PdsMetaDataGetProTask", (int)0, (int)100);
        }
        return pdsMetaDataThreadPool;
    }

    private static Map<String, String> getPro(DynamicObject entityObj, List<ControlAp<?>> items, ControlAp<?> parent, boolean isHidden) {
        LinkedHashMap<String, String> columnMap = new LinkedHashMap<String, String>();
        EntryAp entryAp = null;
        HashMap<String, String> baseDataEntityMap = new HashMap<String, String>();
        HashMap<String, String> baseDataNameMap = new HashMap<String, String>();
        HashMap<String, Map<String, String>> baseDataProMap = new HashMap<String, Map<String, String>>();
        StringBuilder val = null;
        for (ControlAp<?> ap : items) {
            DynamicProperty pro;
            LocaleString displayName;
            if (ap instanceof EntryAp) {
                int result = ap.getName().toString().indexOf("(MOV)");
                if (result != -1) continue;
                entryAp = (EntryAp)ap;
                columnMap.putAll(PdsMetadataUtil.getPro(entryAp.getItems(), entryAp));
                continue;
            }
            if (ap instanceof BillFormAp || ap instanceof ContainerAp || ap instanceof ButtonAp || ap instanceof BarItemAp || ap instanceof FlexPanelAp || ap instanceof VectorAp || null == parent && ap instanceof EntryFieldAp) continue;
            if (!isHidden) {
                int visVal = ap.getVisibleValue();
                if (ap.isHidden() || visVal == 0) continue;
            }
            if (null == (displayName = ap.getName())) continue;
            String proKey = ap.getKey();
            String text = displayName.toString();
            if (null != entityObj && (pro = entityObj.getDynamicObjectType().getProperty(ap.getKey())) instanceof BasedataProp) {
                BasedataProp bdPro = (BasedataProp)pro;
                if (null == bdPro.getBaseEntityId()) continue;
                DataEntityPropertyCollection proCols = bdPro.getComplexType().getProperties();
                HashMap<String, String> refProMap = new HashMap<String, String>();
                for (IDataEntityProperty dtPro : proCols) {
                    if (dtPro.getName().endsWith("_id") || "multilanguagetext".equals(dtPro.getName()) || "masterid".equals(dtPro.getName()) || "id".equals(dtPro.getName())) continue;
                    columnMap.put(ap.getKey() + "." + dtPro.getName(), text + "." + dtPro.getName());
                    refProMap.put(dtPro.getName(), text + "." + dtPro.getName());
                }
                baseDataNameMap.put(ap.getKey(), text);
                baseDataEntityMap.put(ap.getKey(), bdPro.getBaseEntityId());
                baseDataProMap.put(ap.getKey(), refProMap);
            }
            if (null != parent) {
                val = new StringBuilder();
                val.append(parent.getKey());
                val.append('.');
                val.append(proKey);
                proKey = val.toString();
                val = new StringBuilder();
                val.append(parent.getName());
                val.append('.');
                val.append(ap.getName());
                text = val.toString();
            }
            columnMap.put(proKey, text);
        }
        if (null != entityObj) {
            LowTimer timer = new LowTimer();
            PdsMetadataUtil.updateBdRefName(columnMap, baseDataEntityMap, baseDataNameMap, baseDataProMap);
            BizLog.log((String)("updateBdRefName cost:" + timer.msValue()));
        }
        return columnMap;
    }

    private static void updateBdRefName(Map<String, String> columnMap, Map<String, String> baseDataEntityMap, Map<String, String> baseDataNameMap, Map<String, Map<String, String>> baseDataProMap) {
        HashSet<String> entityKeySet = new HashSet<String>(baseDataEntityMap.size());
        for (Map.Entry<String, String> baseDataEntity : baseDataEntityMap.entrySet()) {
            if (null == baseDataEntity.getValue()) continue;
            entityKeySet.add(baseDataEntity.getValue());
        }
        HashSet<String> handledEntitySet = new HashSet<String>(entityKeySet.size());
        CountDownLatch countDownLatch = new CountDownLatch(entityKeySet.size());
        ConcurrentHashMap<String, Map<String, String>> entityProMap = new ConcurrentHashMap<String, Map<String, String>>(baseDataEntityMap.size());
        ThreadPool pool = PdsMetadataUtil.getThreadPool();
        for (Map.Entry<String, String> entry : baseDataEntityMap.entrySet()) {
            if (!handledEntitySet.add(entry.getValue())) continue;
            PdsMetaDataTask metaDataTask = new PdsMetaDataTask(entry.getValue(), entityProMap, countDownLatch);
            pool.execute((Runnable)metaDataTask);
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            BizLog.log((String)("contDaowLatch exception :" + e.getMessage()));
        }
        for (Map.Entry<String, Object> entry : baseDataProMap.entrySet()) {
            String entityKey = baseDataEntityMap.get(entry.getKey());
            Map<String, String> proMap = entityProMap.get(entityKey);
            if (null == proMap) continue;
            for (Map.Entry proEntry : ((Map)entry.getValue()).entrySet()) {
                String proText = proMap.get(proEntry.getKey());
                if (null == proText) continue;
                columnMap.put(entry.getKey() + "." + (String)proEntry.getKey(), baseDataNameMap.get(entry.getKey()) + "." + proText);
            }
        }
    }

    public static Set<String> getAllProSet(String entityKey, boolean isHidden, boolean includeRef) {
        Set<String> proSet = new HashSet<String>();
        FormMetadata formmeta = PdsMetadataUtil.getFormMetaData(entityKey);
        if (null != formmeta) {
            DynamicObject entityObj = null;
            if (includeRef) {
                entityObj = BusinessDataServiceHelper.newDynamicObject((String)entityKey);
            }
            proSet = PdsMetadataUtil.getProSet(entityObj, formmeta.getItems(), null, isHidden, includeRef);
        }
        return proSet;
    }

    public static Set<String> getProSet(DynamicObject entityObj, List<ControlAp<?>> items, ControlAp<?> parent, boolean isHidden, boolean isRef) {
        HashSet<String> proSet = new HashSet<String>();
        EntryAp entryAp = null;
        StringBuilder val = null;
        for (ControlAp<?> ap : items) {
            DynamicProperty pro;
            FieldAp fieldAp;
            Field field;
            LocaleString displayName;
            if (ap instanceof EntryAp) {
                int result = ap.getName().toString().indexOf("(MOV)");
                if (result != -1) continue;
                entryAp = (EntryAp)ap;
                proSet.addAll(PdsMetadataUtil.getProSet(null, entryAp.getItems(), entryAp, true, true));
                continue;
            }
            if (ap instanceof BillFormAp || ap instanceof ContainerAp || ap instanceof ButtonAp || ap instanceof BarItemAp || ap instanceof FlexPanelAp || ap instanceof VectorAp || null == parent && ap instanceof EntryFieldAp) continue;
            if (!isHidden) {
                int visVal = ap.getVisibleValue();
                if (ap.isHidden() || visVal == 0) continue;
            }
            if (null == (displayName = ap.getName())) continue;
            String proKey = ap.getKey();
            if (ap instanceof FieldAp && (field = (fieldAp = (FieldAp)ap).getField()) instanceof BasedataPropField) continue;
            if (null != entityObj && (pro = entityObj.getDynamicObjectType().getProperty(ap.getKey())) instanceof BasedataProp) {
                BasedataProp bdPro = (BasedataProp)pro;
                if (null == bdPro.getBaseEntityId()) continue;
                DataEntityPropertyCollection proCols = bdPro.getComplexType().getProperties();
                for (IDataEntityProperty dtPro : proCols) {
                    if (dtPro.getName().endsWith("_id") || "multilanguagetext".equals(dtPro.getName()) || "masterid".equals(dtPro.getName()) || "id".equals(dtPro.getName())) continue;
                    proSet.add(ap.getKey() + "." + dtPro.getName());
                }
            }
            if (null != parent) {
                val = new StringBuilder();
                val.append(parent.getKey());
                val.append('.');
                val.append(proKey);
                proKey = val.toString();
            }
            proSet.add(proKey);
        }
        return proSet;
    }

    public static List<String> getEntityKey_namesByControlType(String entityKey, String controlType) {
        ArrayList<String> entityKeyList = new ArrayList<String>(8);
        if (Objects.isNull(entityKey) || Objects.isNull(controlType)) {
            return entityKeyList;
        }
        FormMetadata formMetadata = PdsMetadataUtil.getFormMetaData(entityKey);
        if (null == formMetadata) {
            return entityKeyList;
        }
        List items = formMetadata.getItems();
        for (ControlAp item : items) {
            switch (controlType) {
                case "attachmentpanelap": {
                    if (!(item instanceof AttachmentPanelAp)) break;
                    entityKeyList.add(PdsCommonUtils.buildString(item.getKey(), "|", item.getName()));
                    break;
                }
                case "entryap": {
                    int result;
                    if (!(item instanceof EntryAp) || (result = item.getName().toString().indexOf("(MOV)")) != -1) break;
                    entityKeyList.add(PdsCommonUtils.buildString(item.getKey(), "|", item.getName()));
                }
            }
        }
        return entityKeyList;
    }
}

