/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.entity.PdsObjectPools;
import kd.scm.pds.common.util.PdsCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class PdsObjectCacheUtils {
    public static String getProjectParam(long projectId, String paramName) {
        String poolKey = PdsObjectCacheUtils.getProjectPoolKey(projectId);
        Map paramMap = PdsObjectPools.getCache().getAll(poolKey);
        if (null != paramMap) {
            return (String)paramMap.get(paramName);
        }
        return null;
    }

    public static void setProjectParam(long projectId, String paramName, String value) {
        String poolKey = PdsObjectCacheUtils.getProjectPoolKey(projectId);
        HashMap<String, String> paramMap = PdsObjectPools.getCache().getAll(poolKey);
        if (null == paramMap) {
            paramMap = new HashMap<String, String>(8);
        }
        paramMap.put(paramName, value);
        PdsObjectPools.getCache().put(poolKey, paramMap);
    }

    public static String getProjectOpenStatus(long projectId) {
        String openStatus = PdsObjectCacheUtils.getProjectParam(projectId, "openstatus");
        if (!StringUtils.isBlank((CharSequence)openStatus)) {
            return openStatus;
        }
        QFilter qfilters = new QFilter("id", "=", (Object)projectId);
        DynamicObject projectObj = QueryServiceHelper.queryOne((String)"src_project", (String)"openstatus", (QFilter[])qfilters.toArray());
        if (null != projectObj) {
            openStatus = projectObj.getString("openstatus");
            PdsObjectCacheUtils.setProjectParam(projectId, "openstatus", openStatus);
        }
        return openStatus;
    }

    public static boolean isEndedOpenStatus(long projectId) {
        String openStatus = PdsObjectCacheUtils.getProjectOpenStatus(projectId);
        if (StringUtils.isBlank((CharSequence)openStatus)) {
            return false;
        }
        return "9".equals(openStatus) || "A".equals(openStatus) || "B".equals(openStatus);
    }

    public static String getProjectPoolKey(long projectId) {
        return PdsCommonUtils.buildString(RequestContext.get().getAccountId(), Character.valueOf('_'), "project", Character.valueOf('_'), projectId);
    }
}

