/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsProjectIdUtils {
    public static Set<Long> getDecisionProjectIds(QFilter prefixFilter) {
        DynamicObjectCollection rows;
        QFilter qfilter = new QFilter("bizstatus", "=", (Object)ProcessStatusEnums.PROCESSED.getValue());
        if (null != prefixFilter) {
            qfilter.and(prefixFilter);
        }
        if ((rows = QueryServiceHelper.query((String)"src_decision", (String)"id", (QFilter[])qfilter.toArray())).size() == 0) {
            return Collections.emptySet();
        }
        return rows.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
    }

    public static Set<Long> getTerminatedProjectIds(QFilter prefixFilter) {
        DynamicObjectCollection rows;
        QFilter qfilter = new QFilter("bizstatus", "=", (Object)ProcessStatusEnums.CLOSED.getValue());
        qfilter.or("bizstatus", "=", (Object)ProcessStatusEnums.TERMINATED.getValue());
        if (null != prefixFilter) {
            qfilter.and(prefixFilter);
        }
        if ((rows = QueryServiceHelper.query((String)"src_project", (String)"id", (QFilter[])qfilter.toArray())).size() == 0) {
            return Collections.emptySet();
        }
        return rows.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
    }

    public static Set<Long> getSourceNoticeProjectIds(QFilter prefixFilter) {
        QFilter qfilter = new QFilter("biztype", "=", (Object)"C");
        qfilter.or("biztype", "=", (Object)"2");
        if (null != prefixFilter) {
            qfilter.and(prefixFilter);
        }
        return PdsProjectIdUtils.getNoticeProjectIds(qfilter);
    }

    public static Set<Long> getWinNoticeProjectIds(QFilter prefixFilter) {
        QFilter qfilter = new QFilter("biztype", "=", (Object)"5");
        if (null != prefixFilter) {
            qfilter.and(prefixFilter);
        }
        return PdsProjectIdUtils.getNoticeProjectIds(qfilter);
    }

    public static Set<Long> getFailNoticeProjectIds(QFilter prefixFilter) {
        QFilter qfilter = new QFilter("biztype", "=", (Object)"D");
        if (null != prefixFilter) {
            qfilter.and(prefixFilter);
        }
        return PdsProjectIdUtils.getNoticeProjectIds(qfilter);
    }

    public static Set<Long> getWinMessageProjectIds(QFilter prefixFilter) {
        DynamicObjectCollection rows;
        QFilter qfilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        QFilter typeFilter = new QFilter("winportaltpl", ">", (Object)0);
        typeFilter.or("backupportaltpl", ">", (Object)0);
        typeFilter.or("cultivateportaltpl", ">", (Object)0);
        qfilter.and(typeFilter);
        if (null != prefixFilter) {
            qfilter.and(prefixFilter);
        }
        if ((rows = QueryServiceHelper.query((String)"pds_noticesupplier", (String)"project.id", (QFilter[])qfilter.toArray())).size() == 0) {
            return Collections.emptySet();
        }
        return rows.stream().map(e -> e.getLong("project.id")).collect(Collectors.toSet());
    }

    private static Set<Long> getNoticeProjectIds(QFilter qfilter) {
        QFilter qfilters = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        qfilters.and(qfilter);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"sou_notice", (String)"srcbillid", (QFilter[])qfilters.toArray());
        if (rows.size() == 0) {
            return Collections.emptySet();
        }
        return rows.stream().map(e -> e.getLong("srcbillid")).collect(Collectors.toSet());
    }

    public static Set<Long> getAllMyScoreProjectIds(String status) {
        QFilter qfilters = new QFilter("scorer", "=", (Object)RequestContext.get().getCurrUserId()).or("agent", "=", (Object)RequestContext.get().getCurrUserId());
        qfilters.and("scored", "=", (Object)status);
        qfilters.and("billid.bizstatus", "!=", (Object)"E");
        QFilter aptFilter = new QFilter("billid.basetype", "=", (Object)"4");
        QFilter bidFilter = new QFilter("billid.basetype", "!=", (Object)"4").and("project.openstatus", "in", PdsCommonUtils.buildSet(BidOpenStatusEnums.TECOPEN.getValue(), BidOpenStatusEnums.BIZOPEN.getValue(), BidOpenStatusEnums.OPEN.getValue()));
        qfilters.and(aptFilter.or(bidFilter));
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_scoreanalyse", (String)"project.id", (QFilter[])qfilters.toArray());
        Set<Long> unScoreIds = rows.stream().map(e -> e.getLong("project.id")).collect(Collectors.toSet());
        return unScoreIds;
    }
}

