/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;

public class PdsPurlistUtils {
    public static Set<Long> getPurilstEndIds(long projectId) {
        HashSet<Long> allIdSet = new HashSet<Long>(16);
        QFilter qfilters = new QFilter("project", "=", (Object)projectId);
        qfilters.and("template.number", "=", (Object)"SYS080");
        qfilters.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        DynamicObject[] bidChangeObjs = PdsCommonUtils.loadBillObjsByQFilter("src_bidchange", qfilters);
        if (null == bidChangeObjs) {
            return allIdSet;
        }
        for (DynamicObject bidChangeObj : bidChangeObjs) {
            DynamicObjectCollection chgEntryRows;
            DynamicObject endChgObj = TemplateUtil.getComponentData(bidChangeObj.getString("id"), "src_materialend");
            if (null == endChgObj || (chgEntryRows = endChgObj.getDynamicObjectCollection("entryentity")).size() == 0) continue;
            Set idSet = chgEntryRows.stream().filter(e -> e.getLong("supplier.id") == 0L).map(e -> e.getLong("purlist.id")).collect(Collectors.toSet());
            allIdSet.addAll(idSet);
        }
        return allIdSet;
    }

    public static DynamicObjectCollection getInitPurilstRows(long projectId) {
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("billtype", "=", (Object)"1");
        return QueryServiceHelper.query((String)"src_purlistf7", (String)"id,purlist.id", (QFilter[])qfilter.toArray());
    }

    public static Set<Long> getInitPurilstIds(long projectId) {
        DynamicObjectCollection rows = PdsPurlistUtils.getInitPurilstRows(projectId);
        return rows.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
    }

    public static DynamicObjectCollection getValidPurilstRows(long projectId, Set<String> statusSet) {
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("supplier", ">", (Object)0L);
        qfilter.and("isdiscarded", "=", (Object)"0");
        qfilter.and("entrystatus2", "!=", (Object)ProjectStatusEnums.TERMINATED.getValue());
        qfilter.and("entrystatus2", "!=", (Object)ProjectStatusEnums.INVALID.getValue());
        qfilter.and("entrystatus", "in", statusSet);
        return QueryServiceHelper.query((String)"src_purlistf7", (String)"id,purlist.id,supplier.id", (QFilter[])qfilter.toArray());
    }

    public static Set<Long> getValidPurilstIds(long projectId, Set<String> statusSet) {
        DynamicObjectCollection rows = PdsPurlistUtils.getValidPurilstRows(projectId, statusSet);
        return rows.stream().map(e -> e.getLong("purlist.id")).collect(Collectors.toSet());
    }

    public static Map<Long, Integer> getValidPurilstCount(long projectId, Set<String> statusSet) {
        DynamicObjectCollection rows = PdsPurlistUtils.getValidPurilstRows(projectId, statusSet);
        if (rows.size() == 0) {
            return Collections.emptyMap();
        }
        Map<Long, List<DynamicObject>> purlistMap = rows.stream().collect(Collectors.groupingBy(e -> e.getLong("purlist.id")));
        HashMap<Long, Integer> countMap = new HashMap<Long, Integer>(8);
        for (Map.Entry<Long, List<DynamicObject>> entry : purlistMap.entrySet()) {
            Set supIdSet = entry.getValue().stream().map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
            countMap.put(entry.getKey(), supIdSet.size());
        }
        return countMap;
    }

    public static DynamicObjectCollection getIsDiscardedPurilstRows(long projectId, long supplierId, boolean isdiscarded) {
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("supplier", "=", (Object)supplierId);
        qfilter.and("isdiscarded", "=", (Object)isdiscarded);
        qfilter.and("entrystatus", ">=", (Object)ProjectStatusEnums.OPENED.getValue());
        return QueryServiceHelper.query((String)"src_purlistf7", (String)"purlist.id", (QFilter[])qfilter.toArray());
    }

    public static Set<Long> getIsDiscardedPurilstIds(long projectId, long supplierId, boolean isdiscarded) {
        DynamicObjectCollection rows = PdsPurlistUtils.getIsDiscardedPurilstRows(projectId, supplierId, isdiscarded);
        return rows.stream().map(e -> e.getLong("purlist.id")).collect(Collectors.toSet());
    }

    public static void clearDiscardedValue(DynamicObject row) {
        row.set("isdiscardbid", (Object)"1");
        row.set("isdiscarded", (Object)"1");
        row.set("price", (Object)0);
        row.set("amount", (Object)0);
        row.set("taxitem", null);
        row.set("taxrate", (Object)0);
        row.set("tax", (Object)0);
        row.set("taxprice", (Object)0);
        row.set("taxamount", (Object)0);
        row.set("dctrate", (Object)0);
        row.set("dctamount", (Object)0);
        row.set("feerate", (Object)0);
        row.set("rebate", (Object)0);
        row.set("decrease", (Object)0);
        row.set("actprice", (Object)0);
        row.set("acttaxprice", (Object)0);
        row.set("transcost", (Object)0);
        row.set("rank", (Object)0);
        row.set("sysresult", null);
        row.set("preresult", null);
        row.set("preorderratio", (Object)0);
        row.set("precfmqty", (Object)0);
        row.set("result", null);
        row.set("orderratio", (Object)0);
        row.set("cfmqty", (Object)0);
    }

    public static QFilter getOriginalPurlistQFilter(long projectId) {
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("billtype", "=", (Object)"1");
        qfilter.and("isbizitem", "=", (Object)"0");
        return qfilter;
    }
}

