/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import org.apache.commons.lang3.StringUtils;

public class PdsReportUtils {
    private static Log log = LogFactory.getLog(PdsReportUtils.class);

    public static String getPrintTplIdByNumber(DynamicObject billObj, String number) {
        QFilter qfilter = new QFilter("formid.number", "=", (Object)billObj.getDataEntityType().getName());
        qfilter.and("number", "=", (Object)number);
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"bos_print_meta", (String)"id", (QFilter[])qfilter.toArray());
        if (null == queryOne) {
            return null;
        }
        return queryOne.getString("id");
    }

    public static List<String> getPrintTplIdByEntiyName(String entiyName) {
        QFilter qfilter = new QFilter("formid.number", "=", (Object)entiyName);
        qfilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"bos_print_meta", (String)"id", (QFilter[])qfilter.toArray());
        if (null == rows) {
            return Collections.emptyList();
        }
        return rows.stream().map(e -> e.getString("id")).collect(Collectors.toList());
    }

    public static List<PrtAttach.AttachDetail> generatePDFAttachment(DynamicObject billObj, String prtTplId) {
        if (null == billObj) {
            return Collections.emptyList();
        }
        ArrayList<Object> pkIds = new ArrayList<Object>();
        pkIds.add(billObj.getPkValue());
        ArrayList<PrintTask> taskList = new ArrayList<PrintTask>();
        PrintTask printTask = new PrintTask();
        printTask.setTplId(prtTplId);
        printTask.setPkIds(pkIds);
        printTask.setPrintType("billForm");
        String formId = billObj.getDataEntityType().getName();
        printTask.setFormId(formId);
        taskList.add(printTask);
        PrintWork printWork = new PrintWork();
        printWork.setPrintLang("zh_CN");
        printWork.setExpType("pdf");
        printWork.setTaskList(taskList);
        try {
            PrtAttach doPrint = BosPrintServiceHelper.execPrint((PrintWork)printWork);
            List attachDetails = doPrint.getAttachDetail();
            return attachDetails;
        }
        catch (Exception e) {
            log.error("###generatePDFAttachment excption:" + e.getMessage());
            return Collections.emptyList();
        }
    }

    public static List<Map<String, Object>> createFieldAttachment(DynamicObject billObj, String prtTplId, String filename) {
        ArrayList<Map<String, Object>> attachmentList = new ArrayList<Map<String, Object>>(8);
        List<PrtAttach.AttachDetail> attachDetails = PdsReportUtils.generatePDFAttachment(billObj, prtTplId);
        for (PrtAttach.AttachDetail attachDetail : attachDetails) {
            Map<String, Object> attachMap = PdsReportUtils.buildAttachMap(attachDetail, true);
            attachMap.put("pageid", billObj.getString("id") + "_" + prtTplId);
            if (!StringUtils.isBlank((CharSequence)filename)) {
                StringBuilder fileNameSb = new StringBuilder(filename);
                if (!filename.contains(".pdf")) {
                    fileNameSb.append(".pdf");
                }
                attachMap.put("name", fileNameSb.toString());
            }
            AttachmentUtils.createBdAttachment(attachMap);
            attachmentList.add(attachMap);
        }
        return attachmentList;
    }

    public static List<Map<String, Object>> createFieldAttachmentAndRebuildUrl(DynamicObject billObj, String prtTplId, String filename, boolean isRebuildUrl) {
        ArrayList<Map<String, Object>> attachmentList = new ArrayList<Map<String, Object>>(8);
        List<PrtAttach.AttachDetail> attachDetails = PdsReportUtils.generatePDFAttachment(billObj, prtTplId);
        for (PrtAttach.AttachDetail attachDetail : attachDetails) {
            Map<String, Object> attachMap = PdsReportUtils.buildAttachMap(attachDetail, isRebuildUrl);
            attachMap.put("pageid", billObj.getString("id") + "_" + prtTplId);
            if (!StringUtils.isBlank((CharSequence)filename)) {
                StringBuilder fileNameSb = new StringBuilder(filename);
                if (!filename.contains(".pdf")) {
                    fileNameSb.append(".pdf");
                }
                attachMap.put("name", fileNameSb.toString());
            }
            AttachmentUtils.createBdAttachment(attachMap);
            attachmentList.add(attachMap);
        }
        return attachmentList;
    }

    public static List<Map<String, Object>> createPanelAttachment(DynamicObject billObj, String prtTplId, String attachPanelKey) {
        ArrayList<Map<String, Object>> attachmentList = new ArrayList<Map<String, Object>>(8);
        List<PrtAttach.AttachDetail> attachDetails = PdsReportUtils.generatePDFAttachment(billObj, prtTplId);
        for (PrtAttach.AttachDetail attachDetail : attachDetails) {
            Map<String, Object> attachMap = PdsReportUtils.buildAttachMap(attachDetail, false);
            attachmentList.add(attachMap);
        }
        AttachmentServiceHelper.upload((String)billObj.getDataEntityType().getName(), (Object)billObj.getPkValue(), (String)attachPanelKey, attachmentList);
        return attachmentList;
    }

    public static List<Map<String, Object>> createPanelAttachment(DynamicObject billObj, DynamicObject compObj, String prtTplId, String attachPanelKey) {
        ArrayList<Map<String, Object>> attachmentList = new ArrayList<Map<String, Object>>(8);
        List<PrtAttach.AttachDetail> attachDetails = PdsReportUtils.generatePDFAttachment(compObj, prtTplId);
        for (PrtAttach.AttachDetail attachDetail : attachDetails) {
            Map<String, Object> attachMap = PdsReportUtils.buildAttachMap(attachDetail, false);
            attachmentList.add(attachMap);
        }
        AttachmentServiceHelper.upload((String)billObj.getDataEntityType().getName(), (Object)billObj.getPkValue(), (String)attachPanelKey, attachmentList);
        return attachmentList;
    }

    public static List<Map<String, Object>> createPanelAttachmentAndRebuildUrl(DynamicObject billObj, String prtTplId, String attachPanelKey, boolean isRebuildUrl) {
        ArrayList<Map<String, Object>> attachmentList = new ArrayList<Map<String, Object>>(8);
        List<PrtAttach.AttachDetail> attachDetails = PdsReportUtils.generatePDFAttachment(billObj, prtTplId);
        for (PrtAttach.AttachDetail attachDetail : attachDetails) {
            Map<String, Object> attachMap = PdsReportUtils.buildAttachMap(attachDetail, isRebuildUrl);
            attachmentList.add(attachMap);
        }
        AttachmentServiceHelper.upload((String)billObj.getDataEntityType().getName(), (Object)billObj.getPkValue(), (String)attachPanelKey, attachmentList);
        return attachmentList;
    }

    public static List<Map<String, Object>> createPanelAttachmentAndRebuildUrl(DynamicObject billObj, DynamicObject compObj, String prtTplId, String attachPanelKey, boolean isRebuildUrl) {
        ArrayList<Map<String, Object>> attachmentList = new ArrayList<Map<String, Object>>(8);
        List<PrtAttach.AttachDetail> attachDetails = PdsReportUtils.generatePDFAttachment(compObj, prtTplId);
        for (PrtAttach.AttachDetail attachDetail : attachDetails) {
            Map<String, Object> attachMap = PdsReportUtils.buildAttachMap(attachDetail, isRebuildUrl);
            attachmentList.add(attachMap);
        }
        AttachmentServiceHelper.upload((String)billObj.getDataEntityType().getName(), (Object)billObj.getPkValue(), (String)attachPanelKey, attachmentList);
        return attachmentList;
    }

    private static Map<String, Object> buildAttachMap(PrtAttach.AttachDetail attachDetail, boolean isRebuildUrl) {
        HashMap<String, Object> attachMap = new HashMap<String, Object>(16);
        long time = System.currentTimeMillis();
        attachMap.put("createdate", time);
        attachMap.put("creator", RequestContext.get().getCurrUserId());
        attachMap.put("lastModified", time);
        attachMap.put("status", "success");
        String attType = attachDetail.getFileType();
        attachMap.put("type", attType);
        attachMap.put("name", attachDetail.getFileName());
        try {
            InputStream in = BosPrintServiceHelper.getFileInputStream((String)attachDetail.getFilePath());
            byte[] AttByte = PdsReportUtils.InputStreamToByte(in);
            attachMap.put("size", AttByte.length);
        }
        catch (IOException e1) {
            BizLog.log((String)("buildAttachMap exception:" + e1.getMessage()));
        }
        StringBuilder uid = new StringBuilder();
        uid.append("rc-upload-");
        uid.append(time);
        uid.append("-");
        uid.append("1");
        attachMap.put("uid", uid.toString());
        if (isRebuildUrl) {
            attachMap.put("url", AttachmentUtils.rebuildUrl(attachDetail.getFilePath(), attachDetail.getFileName()));
        } else {
            attachMap.put("url", attachDetail.getFilePath());
        }
        return attachMap;
    }

    private static byte[] InputStreamToByte(InputStream in) throws IOException {
        int ch;
        if (null == in) {
            return new byte[0];
        }
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        while ((ch = in.read()) != -1) {
            bytestream.write(ch);
        }
        byte[] imgdata = bytestream.toByteArray();
        bytestream.close();
        return imgdata;
    }

    public static List<Map<String, Object>> getPrintAttachments(String entityName, List<Long> billIds, List<String> prtTplIds, String attachPanelKey) {
        if (null == billIds || billIds.size() == 0) {
            return null;
        }
        if (null == prtTplIds || prtTplIds.size() == 0) {
            prtTplIds = PdsReportUtils.getPrintTplIdByEntiyName(entityName);
        }
        if (null == prtTplIds || prtTplIds.size() == 0) {
            return null;
        }
        Map<Long, DynamicObject> billObjMap = PdsReportUtils.getObjMap(entityName, billIds);
        ArrayList<Map<String, Object>> prtAttachMaps = new ArrayList<Map<String, Object>>(8);
        for (String prtTplId : prtTplIds) {
            for (Long billId : billIds) {
                DynamicObject billObj = billObjMap.get(billId);
                if (null == billObj) continue;
                List<Object> prtAttachMap = new ArrayList(8);
                if (null == attachPanelKey) {
                    List<Map<String, Object>> prtAttachList = PdsReportUtils.createFieldAttachment(billObj, prtTplId, "");
                    if (null != prtAttachList) {
                        prtAttachMap = PdsReportUtils.fieldAttach2PanelAttach(prtAttachList, billId);
                    }
                } else {
                    prtAttachMap = PdsReportUtils.createPanelAttachment(billObj, prtTplId, "attachmentpanel");
                }
                prtAttachMaps.addAll(prtAttachMap);
            }
        }
        if (null == prtAttachMaps || prtAttachMaps.size() == 0) {
            return null;
        }
        return prtAttachMaps;
    }

    public static Map<Long, DynamicObject> getObjMap(String entityName, List<Long> billIds) {
        QFilter filter = new QFilter("id", "in", billIds);
        DynamicObject[] billObjs = BusinessDataServiceHelper.load((String)entityName, (String)"id", (QFilter[])filter.toArray());
        HashMap<Long, DynamicObject> billObjMap = new HashMap<Long, DynamicObject>(billIds.size());
        for (DynamicObject obj : billObjs) {
            billObjMap.put(obj.getLong("id"), obj);
        }
        return billObjMap;
    }

    public static List<Map<String, Object>> fieldAttach2PanelAttach(List<Map<String, Object>> prtAttachMap, long billId) {
        ArrayList<Map<String, Object>> newPrtAttachMap = new ArrayList<Map<String, Object>>(8);
        HashSet<String> uidSet = new HashSet<String>(8);
        for (Map<String, Object> prtAttach : prtAttachMap) {
            uidSet.add(String.valueOf(prtAttach.get("uid")));
        }
        QFilter qfilter = new QFilter("uid", "in", uidSet);
        DynamicObject[] attachInfoRows = PdsCommonUtils.loadBillObjsByQFilter("bd_attachment", qfilter);
        if (null == attachInfoRows || attachInfoRows.length == 0) {
            return newPrtAttachMap;
        }
        for (DynamicObject attachInfo : attachInfoRows) {
            HashMap<String, Object> attachMap = new HashMap<String, Object>(16);
            attachMap.put("billPkId", String.valueOf(billId));
            AttachmentUtils.setAttachMapValue(attachMap, attachInfo);
            newPrtAttachMap.add(attachMap);
            uidSet.remove(attachInfo.get("uid"));
        }
        if (uidSet.size() > 0) {
            Map<Object, List<Map>> tempMap = prtAttachMap.stream().collect(Collectors.groupingBy(e -> e.get("uid")));
            for (String uid : uidSet) {
                List<Map> tempAttachMap = tempMap.get(uid);
                if (null == tempAttachMap) continue;
                newPrtAttachMap.addAll(tempAttachMap);
            }
        }
        return newPrtAttachMap;
    }

    public static void openCreatePdf(IFormView view, boolean isComponent, String entryName) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        if (!isComponent) {
            paramMap.put("entityname", view.getEntityId());
            paramMap.put("compkey", view.getEntityId());
            paramMap.put("currentrow", 0);
        } else {
            paramMap.put("entityname", view.getParentView().getEntityId());
            paramMap.put("compkey", view.getEntityId());
            int index = view.getModel().getEntryCurrentRowIndex(entryName);
            if (index < 0 || view.getModel().getEntryRowCount(entryName) == 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u6570\u636e\u8fdb\u884c\u6807\u4e66\u7f16\u5236\u3002", (String)"PdsReportUtils_0", (String)"scm-pds-common", (Object[])new Object[0]));
                return;
            }
            paramMap.put("currentrow", index);
            paramMap.put("entryname", entryName);
        }
        OpenFormUtils.openDynamicPage(view, "pds_print_pdf", ShowType.Modal, paramMap, null);
    }

    public static void createCompPdfAttach(ExtPluginContext context) {
        boolean isChanged = false;
        List<String> compKeys = TemplateUtil.getCompKeyList(context.getBillObj());
        String attachPanelKey = PdsCommonUtils.object2String(context.getParamMap().get("attachmentpanel"), "attachmentpanel");
        for (String compKey : compKeys) {
            DynamicObject compObj;
            QFilter qfilter = new QFilter("formid.number", "=", (Object)compKey);
            qfilter.and("enable", "=", (Object)"1");
            DynamicObjectCollection prtTplObjs = QueryServiceHelper.query((String)"bos_print_meta", (String)"id", (QFilter[])qfilter.toArray(), (String)" modifytime desc");
            if (null == prtTplObjs || prtTplObjs.size() == 0 || null == (compObj = TemplateUtil.getCompData(context.getBillObj(), compKey))) continue;
            PdsReportUtils.createPanelAttachmentAndRebuildUrl(context.getBillObj(), compObj, ((DynamicObject)prtTplObjs.get(0)).getString("id"), attachPanelKey, true);
            isChanged = true;
        }
        if (isChanged && null != context.getView()) {
            context.getView().updateView(attachPanelKey);
            context.getView().sendFormAction(context.getView());
        }
    }

    public static void createCompPdfAttach(IFormView view, String attachPanelKey, String number) {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(view);
        context.setBillObj(view.getModel().getDataEntity(true));
        context.getParamMap().put("attachmentpanel", attachPanelKey);
        ExtPluginFactory.executeExtplugin(number, context, false);
    }

    public static void createBillPdfAttach(ExtPluginContext context) {
        boolean isChanged = false;
        String number = PdsCommonUtils.object2String(context.getParamMap().get("number"), "");
        String attachPanelKey = PdsCommonUtils.object2String(context.getParamMap().get("attachmentpanel"), "attachmentpanel");
        QFilter qfilter = null;
        qfilter = !StringUtils.isBlank((CharSequence)number) ? new QFilter("number", "=", (Object)number) : new QFilter("formid.number", "=", (Object)context.getBillObj().getDataEntityType().getName());
        qfilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection prtTplObjs = QueryServiceHelper.query((String)"bos_print_meta", (String)"id", (QFilter[])qfilter.toArray(), (String)" modifytime desc");
        if (null == prtTplObjs || prtTplObjs.size() == 0) {
            return;
        }
        number = ((DynamicObject)prtTplObjs.get(0)).getString("id");
        PdsReportUtils.createPanelAttachmentAndRebuildUrl(context.getBillObj(), number, attachPanelKey, true);
        isChanged = true;
        if (isChanged && null != context.getView()) {
            context.getView().updateView(attachPanelKey);
            context.getView().sendFormAction(context.getView());
        }
    }
}

