/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsSourcePlanUtils {
    public static BigDecimal nD = new BigDecimal(86400000);

    public static void updatePlan(long projectId, String entityName, Date beginDate2, Date endDate2, boolean isFinished, long srcbillId, String srcbilltype, Map<String, Object> paramMap) {
        long nodeId = PdsCommonUtils.getNodeIdByEntityName(entityName);
        if (nodeId > 0L) {
            PdsSourcePlanUtils.updatePlan(projectId, nodeId, beginDate2, endDate2, isFinished, srcbillId, srcbilltype, paramMap);
        }
    }

    public static void updatePlan(long projectId, long nodeId, Date beginDate2, Date endDate2, boolean isFinished, long srcbillId, String srcbilltype, Map<String, Object> paramMap) {
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("planitem.biznode", "=", (Object)nodeId);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_planitemf7", (boolean)false);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_planitemf7", (String)selectFields, (QFilter[])qfilter.toArray());
        if (null == rows || rows.length == 0) {
            return;
        }
        if (isFinished) {
            for (DynamicObject row : rows) {
                long diff;
                row.set("srcbillid", (Object)srcbillId);
                row.set("srcbilltype", (Object)srcbilltype);
                if (null == row.getDate("begindate2") || beginDate2.before(row.getDate("begindate2"))) {
                    row.set("begindate2", (Object)beginDate2);
                }
                if (null == row.getDate("enddate2") || row.getDate("enddate2").before(endDate2)) {
                    row.set("enddate2", (Object)endDate2);
                }
                if (null != row.getDate("enddate2") && null != row.getDate("begindate2")) {
                    diff = row.getDate("enddate2").getTime() - row.getDate("begindate2").getTime();
                    BigDecimal hours2 = new BigDecimal(diff).divide(nD, 2, RoundingMode.HALF_DOWN);
                    row.set("hours2", (Object)hours2);
                    BigDecimal hours = row.getBigDecimal("hours");
                    row.set("timediff", (Object)hours.subtract(hours2));
                    if (hours.compareTo(BigDecimal.ZERO) > 0) {
                        row.set("diffrate", (Object)hours.subtract(hours2).multiply(BigDecimal.TEN).multiply(BigDecimal.TEN).divide(hours, 2, RoundingMode.HALF_DOWN));
                    }
                }
                if (null == row.getDate("enddate") || null == row.getDate("enddate2")) continue;
                diff = row.getDate("enddate").getTime() - row.getDate("enddate2").getTime();
                row.set("plandiff", (Object)new BigDecimal(diff).divide(nD, 2, RoundingMode.HALF_DOWN));
            }
        } else {
            for (DynamicObject row : rows) {
                row.set("begindate2", null);
                row.set("enddate2", null);
                row.set("hours2", null);
                row.set("timediff", null);
                row.set("diffrate", null);
                row.set("plandiff", null);
                row.set("srcbillid", (Object)0);
                row.set("srcbilltype", null);
            }
        }
        PdsCommonUtils.saveDynamicObjects(rows);
    }
}

